package com.streamscape.mf.agent.sdo;

import com.streamscape.mf.agent.enums.ProcessesRetrievalStrategy;
import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents request which can be raised by portal to get list of processes for specific process type
 * </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  10.06.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 public class ProcessListRequest extends CloneableDataObject
 {
    protected String processType                  = null;
    protected int    processNumber                = 0;
    protected int    pageNumber                   = 0;
    protected String filter                       = null;
    
    protected String sortByField                  = null;
    protected String order                        = null;
   
    protected ProcessesRetrievalStrategy strategy = null;
     
    public ProcessListRequest()
    {}
    
    public String getOrder()
    {
       return order;
    }

    public void setOrder(String order)
    {
       this.order = order;
    }
    
    public int getPageNumber()
    {
       return pageNumber;
    }
    
    public String getFilter()
    {
       return filter;
    }

    public void setFilter(String filter)
    {
       this.filter = filter;
    }

    public void setPageNumber(int pageNumber)
    {
       this.pageNumber = pageNumber;
    }

    public String getSortByField()
    {
       return sortByField;
    }

    public void setSortByField(String sortByField)
    {
       this.sortByField = sortByField;
    }

    public void setStrategy(ProcessesRetrievalStrategy strategy)
    {
       this.strategy = strategy;
    }
    
    public ProcessListRequest(String processType)
    {
       this.processType = processType;
    }
    
    public String getProcessType()
    {
       return processType;
    }
    
    public void setProcessType(String type)
    {
       this.processType = type;
    }
    
    public int getProcessNumber()
    {
       return processNumber;
    }

    public void setProcessNumber(int processNumber)
    {
       this.processNumber = processNumber;
    }

    public ProcessesRetrievalStrategy getStrategy()
    {
       return strategy;
    }

    public void setProcessesRetrievalStrategy(ProcessesRetrievalStrategy strategy)
    {
       this.strategy = strategy;
    }
 }
