package com.streamscape.mf.agent.sdo;

import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents process identifier (instance)
 * </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  28.06.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 //  16.01.2011 | Andrey Solovyev  | Adding of userName parameter
 // -------------------------------------------------------------------------------------------------------------------
 public class ProcessIdentifier extends CloneableDataObject
 {
    protected String processType = null;
    protected String processId   = null;
    protected String comment     = null;
    protected String userName    = null;
  
    public ProcessIdentifier()
    {       
    }
    
    public ProcessIdentifier(String processId)
    {       
       this.processId = processId;
    }
    
    public String getComment()
    {
       return comment;
    } 

    public void setComment(String comment)
    {
       this.comment = comment;
    }
    
    public String getProcessId()
    {
       return processId;
    }
    
    public void setProcessId(String id)
    {
       this.processId = id;
    }
    
    public String getProcessType()
    {
       return processType;
    }

    public void setProcessType(String processType)
    {
       this.processType = processType;
    }

    /**
     * @param userName the userName to set
     */
    public void setUserName(String userName)
    {
        this.userName = userName;
    }

    /**
     * @return the userName
     */
    public String getUserName()
    {
        return userName;
    }
 }
