package com.streamscape.mf.agent.sdo;

import com.streamscape.mf.agent.enums.AuditTypeEnum;
import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents request which can be raised by portal to get audit trail for specific process
 * </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  10.06.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 //  15.07.2010 | Sergey Zakharov  | Added auditId field to identify audit in case of duplicated steps
 // -------------------------------------------------------------------------------------------------------------------
 public class ProcessAuditRequest extends CloneableDataObject
 {
    protected String process     = null;
    protected String processId   = null;
    protected String step        = null;
    protected String auditId     = null;
    protected AuditTypeEnum type = null;
    
    public ProcessAuditRequest()
    {       
    }
    
    public String getAuditId()
    {
       return auditId;
    }

    public void setAuditId(String auditId)
    {
       this.auditId = auditId;
    }  
    
    public ProcessAuditRequest(String process, String processId)
    {
       this(process, processId, null, null);
    }
    
    public ProcessAuditRequest(String process, String processId, String step)
    {
       this(process, processId, step, null);
    }
    
    public ProcessAuditRequest(String process, String processId, String step, String auditId)
    {
       this.process   = process;
       this.processId = processId;
       this.step      = step;
       this.auditId   = auditId;
    }
    
    public String getStep()
    {
       return step;
    }

    public void setStep(String step)
    {
       this.step = step;
    }

    public String getProcessType()
    {
       return process;
    }
    
    public void setProcessType(String type)
    {
       this.process = type;
    }
    
    public String getProcessId()
    {
       return processId;
    }
    
    public void setProcessId(String id)
    {
       this.processId = id;
    }

    /**
     * @param type the type to set
     */
    public void setType(AuditTypeEnum type)
    {
        this.type = type;
    }

    /**
     * @return the type
     */
    public AuditTypeEnum getType()
    {
        return type;
    }
 }
