package com.streamscape.mf.agent.sdo;

import java.util.ArrayList;
import java.util.List;

/**
 * <p> Title: Red Square Framework </p>
 *
 * <p> Description: SDO list user functions response.</p>
 *
 * <p> Copyright: Copyright (c) 2017 </p>
 *
 * <p> Company: StreamScape Technologies </p>
 *
 * @author Nikita Kutuzov
 * @version 3.6
 * @since 3.6
 */
 public class ListUserFunctionsResponse
 {
    public static class UserFunctionArgument
    {
       private String name;
       private String type;

       public UserFunctionArgument(String name, String type)
       {
          this.name = name;
          this.type = type;
       }
    }

    public static class UserFunction
    {
       private String nodeName;
       private String dataspace;
       private String functionName;
       private List<UserFunctionArgument> arguments = new ArrayList<>();
       private String returnType;

       public UserFunction(String nodeName, String dataspace, String functionName)
       {
          this.nodeName = nodeName;
          this.dataspace = dataspace;
          this.functionName = functionName;
       }

       public void addArgument(String name, String type)
       {
          arguments.add(new UserFunctionArgument(name, type));
       }

       public void setReturnType(String returnType)
       {
          this.returnType = returnType;
       }

       public String getFunctionName()
       {
          return functionName;
       }

       public String getDataspace()
       {
          return dataspace;
       }
    }

    private List<UserFunction> functions = new ArrayList<>();

    public ListUserFunctionsResponse()
    {
    }

    public void addFunction(UserFunction function)
    {
       this.functions.add(function);
    }

    public void addFunctions(List<UserFunction> functions)
    {
       this.functions.addAll(functions);
    }

    public List<UserFunction> getFunctions()
    {
       return functions;
    }

 }
