package com.streamscape.mf.agent.sdo;

import java.util.ArrayList;
import java.util.List;

/**
 * <p> Title: Red Square Framework </p>
 *
 * <p> Description: SDO for list user functions request.</p>
 *
 * <p> Copyright: Copyright (c) 2017 </p>
 *
 * <p> Company: StreamScape Technologies </p>
 *
 * @author Nikita Kutuzov
 * @version 3.6
 * @since 3.6
 */
 public class ListUserFunctionsRequest
 {
    private List<String> dataspaces = new ArrayList<>();
    private boolean includeRedSquareDataspaces;
    private boolean includeAllDataspaces;
    private List<String> includeAllDataspacesWithEventScope = new ArrayList<>();
    private boolean includeAgents;

    public ListUserFunctionsRequest()
    {
    }

    public List<String> getDataspaces()
    {
       return dataspaces;
    }

    public ListUserFunctionsRequest setDataspaces(List<String> dataspaces)
    {
       this.dataspaces = dataspaces;
       return this;
    }

    public boolean isIncludeRedSquareDataspaces()
    {
       return includeRedSquareDataspaces;
    }

    public ListUserFunctionsRequest setIncludeRedSquareDataspaces(boolean includeRedSquareDataspaces)
    {
       this.includeRedSquareDataspaces = includeRedSquareDataspaces;
       return this;
    }

    public List<String> getIncludeAllDataspacesWithEventScope()
    {
       return includeAllDataspacesWithEventScope;
    }

    public ListUserFunctionsRequest setIncludeAllDataspacesWithEventScope(List<String> includeAllDataspacesWithEventScope)
    {
       this.includeAllDataspacesWithEventScope = includeAllDataspacesWithEventScope;
       return this;
    }

    public boolean isIncludeAllDataspaces()
    {
       return includeAllDataspaces;
    }

    public ListUserFunctionsRequest setIncludeAllDataspaces(boolean includeAllDataspaces)
    {
       this.includeAllDataspaces = includeAllDataspaces;
       return this;
    }

    public boolean isIncludeAgents()
    {
       return includeAgents;
    }

    public ListUserFunctionsRequest setIncludeAgents(boolean includeAgents)
    {
       this.includeAgents = includeAgents;
       return this;
    }
 }
