package com.streamscape.mf.agent.sdo;

import java.util.ArrayList;
import java.util.List;

/**
 * <p> Title: Red Square Framework </p>
 *
 * <p> Description: SDO for list dataspaces response.</p>
 *
 * <p> Copyright: Copyright (c) 2017 </p>
 *
 * <p> Company: StreamScape Technologies </p>
 *
 * @author Nikita Kutuzov
 * @version 3.6
 * @since 3.6
 */
 public class ListDataspacesResponse
 {
    private List<DataspaceResponse> dataspaces = new ArrayList<>();

    public ListDataspacesResponse()
    {
    }

    public List<DataspaceResponse> getDataspaces()
    {
       return dataspaces;
    }

    public ListDataspacesResponse setDataspaces(List<DataspaceResponse> dataspaces)
    {
       this.dataspaces = dataspaces;
       return this;
    }

    public ListDataspacesResponse addDataspaces(List<DataspaceResponse> dataspaces)
    {
       this.dataspaces.addAll(dataspaces);
       return this;
    }

    public static class DataspaceResponse
    {
       private String nodeName;
       private String eventScope;
       private String dataspace;

       public DataspaceResponse(String nodeName, String eventScope, String dataspace)
       {
          this.nodeName = nodeName;
          this.eventScope = eventScope;
          this.dataspace = dataspace;
       }

       public String getEventScope()
       {
          return eventScope;
       }

       public DataspaceResponse setEventScope(String eventScope)
       {
          this.eventScope = eventScope;
          return this;
       }

       public String getDataspace()
       {
          return dataspace;
       }

       public DataspaceResponse setDataspace(String dataspace)
       {
          this.dataspace = dataspace;
          return this;
       }

       public String getNodeName()
       {
          return nodeName;
       }

       public DataspaceResponse setNodeName(String nodeName)
       {
          this.nodeName = nodeName;
          return this;
       }
    }
 }
