package com.streamscape.mf.utils;

import java.sql.SQLException;

import com.streamscape.mf.agent.sdo.RedSquareRowSet;
import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.sdo.rowset.RowSet;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Utils to simplify work with Row Sets in the portal.</p>
 *
 * <p>Copyright: Copyright (c) 2011</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @since 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 // 20/NOV/2011 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 public class RowSetUtils
 {
    public static RedSquareRowSet initFromRowSet(RowSet rowSet) throws IllegalStateException, SQLException
    {
        int columnCount = rowSet.getRowMetaData().getColumnCount();
        int size = rowSet.getRowCount();
        RedSquareRowSet result = new RedSquareRowSet(columnCount, size);

        rowSet.beforeFirst();
        while (rowSet.next())
        {
            Object row[] = new Object[columnCount];
            for (int i = 1; i <= columnCount; ++i)
            {
                Object obj = rowSet.getObject(i);
                if (obj instanceof java.sql.Timestamp)
                    obj = ((java.sql.Timestamp) obj).toString();

                if (obj instanceof Integer)
                    obj = ((Integer) obj).toString();

                if (obj instanceof Long)
                    obj = ((Long) obj).toString();

                row[i - 1] = obj;
            }
            result.addRow(row);
        }

        result.compact();
        return result;
    }
 }
