package com.streamscape.mf.manager.sdo;

import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents request which can be raised by portal to get list of process types
 * </p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Sergey Zakharov
 * @version 3.2
 */
 // -------------------------------------------------------------------------------------------------------------------
 //     DATE    |      AUTHOR      |                              SUBJECT
 // -------------------------------------------------------------------------------------------------------------------
 //  10.06.2010 | Sergey Zakharov  | Creation
 // -------------------------------------------------------------------------------------------------------------------
 public class ProcessTypesRequest extends CloneableDataObject
 {  
    /**
     * if only processes for some organization needed
     */
    private String organization = null; 
    /**
     * do we need main link or sublinks?
     */
    private boolean getSublinks = false;
    
    /**
     * for documentation table to select only needed fields
     */
    private String filterProcessTypeName = null;
    /**
     * @param organization the organization to set
     */
    public void setOrganization(String organization)
    {
        this.organization = organization;
    }
    /**
     * @return the organization
     */
    public String getOrganization()
    {
        return organization;
    }
    /**
     * @param getSublinks the getSublinks to set
     */
    public void setGetSublinks(boolean getSublinks)
    {
        this.getSublinks = getSublinks;
    }
    /**
     * @return the getSublinks
     */
    public boolean getGetSublinks()
    {
        return getSublinks;
    }
    /**
     * @param filterProcessTypeName the filterProcessTypeName to set
     */
    public void setFilterProcessTypeName(String filterProcessTypeName)
    {
        this.filterProcessTypeName = filterProcessTypeName;
    }
    /**
     * @return the filterProcessTypeName
     */
    public String getFilterProcessTypeName()
    {
        return filterProcessTypeName;
    }
    public ProcessTypesRequest()
    {
    }    
 }
