package com.streamscape.mf.manager.sdo;

import com.streamscape.sdo.CloneableDataObject;

/**
 * <p>Title: Red Square Framework</p>
 *
 * <p>Description: Represents process identifier (instance)</p>
 *
 * <p>Copyright: Copyright (c) 2010</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Mikhail Batsyn
 * @version 3.2
 * @since 3.2
 */
 public class PortalNotificationArray extends CloneableDataObject
 {
   private PortalNotification[] notifications;
   private transient int size = 0;
   private transient int cursor = -1; 
   
   public PortalNotificationArray(int size)
   {
      this.size = size;
      this.notifications = new PortalNotification[size];
   }
   
   public void addNotification(PortalNotification notif)
   {
      if (cursor == size)
      {
         throw new IllegalStateException("Portal notifications array is full.");
      }
      
      notifications[++cursor] = notif;
   }
 }
