global class StreamScapeUtils
{
  private static String settingsName = 'StreamScape';
  
  @future (callout=true)
  public static void postEvent(String uri)
  {
    //Get StreamScape node credentials and make URL
    StreamScapeInfo__c ssi = StreamScapeInfo__c.getValues(settingsName);
    String url = ssi.get('URL__c')+uri;
    System.debug(url);

    try
    {
      SObject[] sObj = [SELECT Request__c FROM StreamScapeRequest__c ORDER BY LastModifiedDate];
      if(sObj.size() == 0)
      {
        System.debug('Send requst: '+url);
        sendRequest(url);
      }
      else
      {
        System.debug('Queue is not empty, size: '+sObj.size()+'. Add request to queue');
        addRequestToQueue(url);
      }
    }
    catch(Exception ex)
    {
      addRequestToQueue(url);
      System.debug('Exception: '+ex.getMessage());
    }
  }
  
  public static void sendRequest(String url)
  {
    // Create HTTP object
    Http http = new Http();
    // Instantiate a new HTTP request, specify the method (GET) as well as the endpoint 
    HttpRequest req = new HttpRequest();
    req.setMethod('GET');
    req.setTimeout(3000);

    // Setup Authorizaton.  Noe that the user must be a member of the
    // HTTP group and Realm at a minimum.
    StreamScapeInfo__c ssi = StreamScapeInfo__c.getValues(settingsName);
    Blob headerValue = Blob.valueOf(ssi.get('User__c') + ':' + ssi.get('Password__c'));
    String authorizationHeader = 'BASIC ' +
    EncodingUtil.base64Encode(headerValue);
    req.setHeader('Authorization', authorizationHeader);

    // build the Raise Event query
    req.setEndpoint(url);

    // Send the request, and return a response 
    HttpResponse res = http.send(req);
    if(res.getStatusCode() != 200)
    {
      throw new BadResponseException('Cann`t perform the request: '+res.toString());
    }
    System.debug(res.toString());
  }
  
  public static void addRequestToQueue(String requestUrl)
  {
    StreamScapeRequest__c obj = new StreamScapeRequest__c(Request__c=requestUrl);
    insert obj;
  }
  
  public static String makeURI(String sObjName)
  {
    String json = '';
    String action = '';
    String objId = '';
    if(Trigger.isDelete)
    {
      for(SObject a : Trigger.old)
      {
        action = 'delete';
        objId = a.Id;
        json = toJSON(a);
      }
    }
    else
    {
      if(Trigger.isInsert)
      {
        action = 'insert';
      }
      else if(Trigger.isUpdate)
      {
        action = 'update';
      }
      else
      {
        action = 'unknown';
      }
      for (SObject a : Trigger.new) 
      {
        objId = a.Id;
        json = toJSON(a);
      }  
    }
    
    return '/exchange/raiseEvent?eventId=event.sf.trigger.'+sObjName+'&responseFormat=json&eventProperties=Action='+action+'&correlationId='+objId+'&eventGroupId=SalesForce&eventKey='+action+'&data={"'+sObjName+'": ' + json + '}&requestFormat=json';
  }
  
  public static String toJSON(Object o)
  {
    return JSON.serialize(o).replaceAll(' ', '%20');
  }
}