/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.service;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.service.SFActiveSyncManagerVersion;
import com.streamscape.sf.util.ErrorResponse;
import com.streamscape.sf.util.QueryResult;
import com.streamscape.sf.util.SFTokenExpiredException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SFActiveSyncManager
extends AbstractDaemonService
implements StateNotificationEventListener,
ExceptionEventListener {
    private static final String CONNECTION_FACTORY = "connection.factory";
    private SFConnection sfConnection = null;
    private long pollingInterval = 300000L;
    private JSONSerializer jsonSerializer = null;
    private String eventIds = "";
    private final NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "application/json")};
    private final NVPair[] formData = new NVPair[]{new NVPair("q", "SELECT Id, Request__c FROM StreamScapeRequest__c ORDER BY LastModifiedDate")};
    private final String removeEventsSuccessResponse = "\"Done\"";
    private static final String POLLING_INTERVAL = "polling.interval";
    protected FabricConnection connection = null;
    protected DataspaceAccessor accessor = null;

    public int getMinorBuild() {
        return SFActiveSyncManagerVersion.getBuild();
    }

    public int getMajorVersion() {
        return SFActiveSyncManagerVersion.getMajorVersion();
    }

    public int getMinorVersion() {
        return SFActiveSyncManagerVersion.getMinorVersion();
    }

    public String getVersion() {
        return SFActiveSyncManagerVersion.getVersionString();
    }

    public void start() throws ServiceFrameworkException {
        try {
            this.jsonSerializer = ((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder().setAliasManager((ObjectMediationAliasManager)RuntimeContext.getInstance().getSemanticAliasManager())).setName("SalesforceJSerializer")).setJsonNotation(JsonNotation.TYPE)).setJsonNotationLevel(new JsonNotationLevel[]{JsonNotationLevel.NONE})).build();
            this.ctx.logInfo("SFMethodInvoker starting...");
            ClientFactory connFactory = this.ctx.lookupClientFactoryProperty(CONNECTION_FACTORY);
            Integer timeOut = -1;
            try {
                String timeOutStr = this.ctx.lookupStringProperty("TimeOut");
                if (timeOutStr != null && timeOutStr.isEmpty()) {
                    timeOut = new Integer(timeOutStr);
                }
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("TimeOut property is not specified or incorrect");
            }
            catch (NumberFormatException e) {
                this.ctx.logError("The TimeOut value is not a number");
            }
            this.sfConnection = (SFConnection)connFactory.createConnection();
            this.sfConnection.setStateNotificationEventListener(this);
            this.sfConnection.setExceptionEventListener(this);
            this.sfConnection.setTimeOut(timeOut);
            this.sfConnection.setName("Sys$Default." + connFactory.getFactoryType() + "." + connFactory.getFactoryName());
            this.sfConnection.connect();
        }
        catch (Exception ex) {
            this.ctx.logError("Exception during SFMethodInvoker service starting. " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
        super.start();
    }

    public void onEvent(ClientException e) {
        this.ctx.logError(e.getMessage());
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("SalesForce connection state changed: " + e.getState().toString());
        try {
            if (e.getState() == ConnectionState.CONNECTED) {
                this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
            } else {
                this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), e.getMessage());
            }
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            super.doInit();
            this.pollingInterval = this.ctx.lookupNumericProperty(POLLING_INTERVAL);
            this.ctx.logInfo("SF Event Queue will be polled each " + this.pollingInterval + "ms.");
            this.connection = new FabricConnectionFactory().createConnection();
            this.connection.open();
            this.accessor = this.connection.createDataspaceAccessor(DataspaceType.QSPACE, "SFQueueStore");
        }
        catch (Exception ex) {
            this.ctx.logError("Unable to initialize SFPollEventQueue service. " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
            throw new ServiceFrameworkException(6065, ex.getMessage());
        }
    }

    public void destroy() {
        try {
            if (this.accessor != null) {
                this.accessor.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (FabricConnectionException ex) {
            this.ctx.logError("Exception in destroy(): " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    protected void doRepeatableServiceLogic() {
        try {
            this.ctx.logDebug("Start doRepeatableServiceLogic");
            ConnectionState state = this.sfConnection.getState();
            if (state != ConnectionState.CONNECTED) {
                this.ctx.logError("Cannot send message to SalesForce. Connection state is " + state);
                Thread.sleep(this.pollingInterval);
                return;
            }
            this.checkAndRemoveEvents();
            QueryResult queryResult = null;
            do {
                if ((queryResult = this.getQueryResult()) == null) {
                    return;
                }
                this.eventIds = this.processQueryEvents(queryResult);
                this.ctx.logDebug("EventIDs: " + this.eventIds);
                this.checkAndRemoveEvents();
            } while (queryResult.getRecords().size() > 0);
        }
        catch (Exception ex) {
            this.ctx.logError("doRepeatableServiceLogic exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        try {
            Thread.sleep(this.pollingInterval);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private QueryResult getQueryResult() throws SerializerException, IOException, ModuleException, SFTokenExpiredException {
        byte[] queryResponse = this.getStreamScapeRequestsQuery();
        QueryResult queryResult = null;
        try {
            queryResult = this.parseQueryResponse(queryResponse);
        }
        catch (SerializerException ex) {
            if (this.isInvalidAccessToken(queryResponse)) {
                this.sfConnection.requestAccessToken();
                queryResponse = this.getStreamScapeRequestsQuery();
                if (this.isInvalidAccessToken(queryResponse)) {
                    this.sfConnection.suspend();
                    throw new SFTokenExpiredException("SalesForce acces token is expires. Cannot get new access token.");
                }
                this.parseQueryResponse(this.getStreamScapeRequestsQuery());
            }
            throw ex;
        }
        return queryResult;
    }

    private byte[] getStreamScapeRequestsQuery() throws IOException, ModuleException {
        String uri = this.sfConnection.getRecourseDirectory() + "query/";
        HTTPClientResponse response = this.sfConnection.getHttpClient().Get(uri, this.formData);
        this.ctx.logInfo("query response: " + new String(response.getData()));
        return response.getData();
    }

    private QueryResult parseQueryResponse(byte[] response) throws SerializerException {
        return (QueryResult)this.jsonSerializer.deserialize("QueryResult", response);
    }

    private String processQueryEvents(QueryResult queryResult) {
        StringBuilder eventIdsStrBuild = new StringBuilder();
        for (HashMap<String, Object> map : queryResult.getRecords()) {
            String request = "";
            try {
                request = map.get("Request__c").toString();
                this.ctx.logDebug("Process request: " + request);
                String[] splitedRequest = request.split("(eventId=)|(&responseFormat=)|(&eventProperties=)|(&correlationId=)|(&eventGroupId=)|(&eventKey=)|(&data=)|(&requestFormat=)");
                String typeName = splitedRequest[1].split("[.]")[3];
                String action = splitedRequest[3].split("[=]")[1];
                DataEvent event = (DataEvent)EventDatagramFactory.getInstance().createEvent(splitedRequest[1]);
                event.setData(this.jsonSerializer.deserialize(typeName, splitedRequest[7]));
                event.setEventStringProperty("Action", action);
                event.setCorrelationId(splitedRequest[4]);
                event.setEventGroupId(SFActiveSyncManager.class.getSimpleName());
                event.setEventKey(action);
                List boundEventIds = this.connection.listBoundEventIds();
                if (!boundEventIds.contains(splitedRequest[1])) {
                    this.ctx.logDebug("Bound EventID " + splitedRequest[1] + "");
                    this.connection.bindProducerFor(splitedRequest[1]);
                } else {
                    this.ctx.logDebug("EventID " + splitedRequest[1] + " is already bounded");
                }
                this.connection.raiseEvent((ImmutableEventDatagram)event, EventScope.GLOBAL, 0L);
            }
            catch (Exception ex) {
                this.ctx.logError("Exception during processing request: " + request);
                this.ctx.logError("Exception: " + ex.getMessage());
                ex.printStackTrace();
            }
            eventIdsStrBuild.append(map.get("Id").toString() + ",");
        }
        return eventIdsStrBuild.toString();
    }

    private void checkAndRemoveEvents() throws IOException, ModuleException, SerializerException, SFTokenExpiredException {
        if (this.eventIds.length() > 0) {
            byte[] response = this.sendRemoveEventsRequest(this.eventIds);
            this.ctx.logDebug("Removed Response: " + new String(response));
            if (!new String(response).equals("\"Done\"")) {
                if (this.isInvalidAccessToken(response)) {
                    this.sfConnection.requestAccessToken();
                    response = this.sendRemoveEventsRequest(this.eventIds);
                    this.ctx.logDebug("Removed Response: " + new String(response));
                    if (!new String(response).equals("\"Done\"")) {
                        this.sfConnection.suspend();
                        throw new SFTokenExpiredException("SalesForce acces token is expires. Cannot get new access token.");
                    }
                    this.eventIds = "";
                }
            } else {
                this.eventIds = "";
            }
        }
    }

    private byte[] sendRemoveEventsRequest(String eventIds) throws IOException, ModuleException {
        String data = "{\"arg\" : \"" + eventIds.substring(0, eventIds.length() - 1) + "\"}";
        this.ctx.logDebug("Request to SF: " + data);
        return this.sfConnection.getHttpClient().Post("/services/apexrest/RemoveEvents", data, this.headers).getData();
    }

    private boolean isInvalidAccessToken(byte[] response) {
        try {
            byte[] prResp = Arrays.copyOfRange(response, 1, response.length - 1);
            ErrorResponse errResp = (ErrorResponse)this.jsonSerializer.deserialize("ErrorResponse", prResp);
            if (errResp.getErrorCode() != null && errResp.getErrorCode().equals("INVALID_SESSION_ID")) {
                return true;
            }
        }
        catch (SerializerException ex) {
            this.ctx.logError("checkForInvalidToken exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        return false;
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }
}

