/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.service;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sf.service.SFActiveSyncAuditorVersion;
import java.util.List;

public class SFActiveSyncAuditor
extends AbstractService
implements FabricEventListener {
    private JSONSerializer jsonSerializer = null;
    private FabricConnection connection = null;
    private DataspaceAccessor qspaceAccessor = null;
    private DataspaceAccessor tspaceAccessor = null;
    private final String exceptionEventID = "event.sf.trigger.eventQueueException";
    private final String exceptionTableID = "event.sf.trigger.eventTableException";
    private final String qspaceName = "SFQueueStore";
    private final String tspaceName = "SFTableStore";

    public int getMajorVersion() {
        return SFActiveSyncAuditorVersion.getMajorVersion();
    }

    public int getMinorVersion() {
        return SFActiveSyncAuditorVersion.getMinorVersion();
    }

    public int getMinorBuild() {
        return SFActiveSyncAuditorVersion.getBuild();
    }

    public String getVersion() {
        return SFActiveSyncAuditorVersion.getVersionString();
    }

    public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        this.ctx.logDebug("Recieved event: " + event.getEventId());
        try {
            DataEvent dataEvent = (DataEvent)event;
            this.ctx.logDebug(dataEvent.getEventStringProperty("Action"));
            this.ctx.logDebug(dataEvent.getData().toString());
            String typeName = dataEvent.getEventId().split("[.]")[3];
            this.processEvent(this.qspaceAccessor, dataEvent, typeName, "event.sf.trigger.eventQueueException");
            this.processEvent(this.tspaceAccessor, dataEvent, typeName, "event.sf.trigger.eventTableException");
        }
        catch (Exception ex) {
            this.ctx.logError("Exception in onEvent(): " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    public void start() throws ServiceFrameworkException {
        try {
            this.connection.createEventConsumer("SFActiveSyncAuditor.SFEventConsumer", (FabricEventListener)this, "event.sf.trigger.#", null, EventScope.GLOBAL, true);
        }
        catch (Exception ex) {
            this.ctx.logError("Exception in start(): " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    protected void doInit() throws ServiceFrameworkException {
        this.ctx.logInfo("SFActiveSyncAuditor initialization...");
        try {
            this.connection = new FabricConnectionFactory().createConnection();
            this.connection.open();
            this.qspaceAccessor = this.connection.createDataspaceAccessor(DataspaceType.QSPACE, "SFQueueStore");
            this.tspaceAccessor = this.connection.createDataspaceAccessor(DataspaceType.TSPACE, "SFTableStore");
            this.jsonSerializer = ((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder().setAliasManager((ObjectMediationAliasManager)RuntimeContext.getInstance().getSemanticAliasManager())).setName("SalesforceJSerializer")).setJsonNotation(JsonNotation.TYPE)).setJsonNotationLevel(new JsonNotationLevel[]{JsonNotationLevel.NONE})).build();
        }
        catch (Exception ex) {
            this.ctx.logError("Exception in doInit(): " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
            throw new ServiceFrameworkException(6065, ex.getMessage());
        }
    }

    public void destroy() {
        try {
            if (this.qspaceAccessor != null) {
                this.qspaceAccessor.close();
            }
            if (this.tspaceAccessor != null) {
                this.tspaceAccessor.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (FabricConnectionException ex) {
            this.ctx.logError("Exception in destroy(): " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    private void processEvent(DataspaceAccessor accessor, DataEvent dataEvent, String collectionName, String eventId) throws DataspaceComponentException, DatagramFactoryException, SDOException, SecurityViolationException, SerializerException, FabricConnectionException, FabricEventDispatcherException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        DataCollection collection = accessor.lookupCollection(collectionName);
        if (collection == null) {
            this.ctx.logInfo("Collection for event " + dataEvent.getEventId() + " is not presented. Raise event: " + eventId + ".");
            DataEvent exceptionEvent = (DataEvent)EventDatagramFactory.getInstance().createEvent(eventId);
            exceptionEvent.setEventStringProperty("SfEventId", dataEvent.getEventId());
            exceptionEvent.setEventStringProperty("Action", dataEvent.getEventStringProperty("Action"));
            exceptionEvent.setData((Object)this.jsonSerializer.serialize(dataEvent.getData()));
            exceptionEvent.setCorrelationId(dataEvent.getCorrelationId());
            exceptionEvent.setEventGroupId(SFActiveSyncAuditor.class.getSimpleName());
            exceptionEvent.setEventKey(dataEvent.getEventKey());
            List boundEventIds = this.connection.listBoundEventIds();
            if (!boundEventIds.contains(eventId)) {
                this.ctx.logDebug("Bound EventID " + eventId);
                this.connection.bindProducerFor(eventId);
            } else {
                this.ctx.logDebug("EventID " + eventId + " is already bounded");
            }
            this.connection.raiseEvent((ImmutableEventDatagram)exceptionEvent, EventScope.OBSERVABLE, 0L);
        }
    }
}

