/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection.soql;

import com.fasterxml.jackson.databind.JsonNode;
import com.streamscape.Trace;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sf.connection.soql.SOQLException;
import com.streamscape.sf.connection.soql.SOQLResultConverter;
import com.streamscape.sf.util.Utils;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.TokenType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SOQLResultToRowSetConverter
implements SOQLResultConverter<RowSet> {
    private String query;
    private final boolean extractColumnsFromQuery;
    private final Class<?> targetClass;
    private List<String> columnNames = new ArrayList<String>();
    private String objectName;
    private String nextRecordsUrl;
    private RowSet rowSet;

    public SOQLResultToRowSetConverter(String query) throws SOQLException {
        this(query, true, null);
    }

    public SOQLResultToRowSetConverter(String query, boolean extractColumnsFromQuery, Class<?> targetClass) throws SOQLException {
        this.query = query;
        this.extractColumnsFromQuery = extractColumnsFromQuery;
        this.targetClass = targetClass;
        this.parseQuery();
        if (!extractColumnsFromQuery) {
            this.columnNames.clear();
        }
    }

    public RowSet getRowSetResult() {
        return this.rowSet;
    }

    public String getNextRecordsUrl() {
        return this.nextRecordsUrl;
    }

    @Override
    public RowSet convert(byte[] result) throws SOQLException {
        JsonNode node;
        Trace.logInfo((Object)this, (String)"Parse response and fill RowSet.");
        try {
            node = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(result);
        }
        catch (IOException exception) {
            Trace.logException((Object)this, (Throwable)exception, (boolean)true);
            throw new SOQLException("Failed to parse json.", exception);
        }
        JsonNode records = node.get("records");
        if (records == null) {
            throw new SOQLException("Response does not contain 'records' field.");
        }
        if (!records.isArray()) {
            throw new SOQLException("Response 'records' is not an array.");
        }
        JsonNode capacity = node.get("totalSize");
        if (capacity == null) {
            throw new SOQLException("Response does not contain 'totalSize' field.");
        }
        if (!capacity.isNumber()) {
            throw new SOQLException("Response 'totalSize' is not an int field.");
        }
        JsonNode nextRecordsUrlNode = node.get("nextRecordsUrl");
        if (nextRecordsUrlNode != null) {
            this.nextRecordsUrl = nextRecordsUrlNode.asText();
            Trace.logInfo((Object)this, (String)("There is nextRecordsUrl field in response: " + this.nextRecordsUrl));
        } else {
            this.nextRecordsUrl = null;
        }
        if (this.targetClass != RowSet.class) {
            return null;
        }
        int totalSize = capacity.asInt();
        Trace.logInfo((Object)this, (String)("Result total size: " + totalSize));
        if (Utils.isCountRequest(this.query)) {
            RowMetaData rowMetaData = new RowMetaData();
            rowMetaData.addColumn("count", SQLType.INTEGER);
            this.rowSet = new RowSet(rowMetaData);
            this.rowSet.getMeta().setCapacity(1);
            try {
                Row row = new Row(this.rowSet.getRowMetaData());
                row.setColumn("count", (Object)totalSize);
                this.rowSet.addToRowSet(row);
            }
            catch (Exception ex) {
                Trace.logException((Object)this, (Throwable)ex, (boolean)true);
            }
            return this.rowSet;
        }
        RowMetaData rowMetaData = new RowMetaData();
        if (this.columnNames.size() == 0) {
            this.columnNames = this.extractColumnNamesFromRecords(records);
        }
        for (String columnName : this.columnNames) {
            rowMetaData.addColumn(columnName, SQLType.STRING);
        }
        this.rowSet = new RowSet(rowMetaData);
        this.rowSet.getMeta().setCapacity(capacity.asInt());
        Trace.logInfo((Object)this, (String)("Records Size: " + records.size()));
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            try {
                Row row = new Row(this.rowSet.getRowMetaData());
                JsonNode element = (JsonNode)iterator.next();
                if (element.isObject()) {
                    this.parseObject(row, element, this.objectName);
                    this.rowSet.addToRowSet(row);
                    continue;
                }
                Trace.logError((Object)this, (String)"Root 'records' element is not a json object.");
            }
            catch (Exception ex) {
                Trace.logError((Object)this, (String)("json parse error: " + ex.getMessage()));
                Trace.logException((Object)this, (Throwable)ex, (boolean)true);
            }
        }
        return this.rowSet;
    }

    public RowSet append(byte[] result) throws SOQLException {
        JsonNode node;
        Trace.logInfo((Object)this, (String)"Parse response and append to RowSet.");
        if (this.rowSet == null) {
            Trace.logError((Object)this, (String)"Result RowSet is null.");
            throw new SOQLException("Result RowSet is null.");
        }
        try {
            node = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(result);
        }
        catch (IOException exception) {
            Trace.logException((Object)this, (Throwable)exception, (boolean)true);
            throw new SOQLException("Failed to parse json.", exception);
        }
        JsonNode records = node.get("records");
        if (records == null) {
            throw new SOQLException("Response does not contain 'records' field.");
        }
        if (!records.isArray()) {
            throw new SOQLException("Response 'records' is not an array.");
        }
        JsonNode capacity = node.get("totalSize");
        if (capacity == null) {
            throw new SOQLException("Response does not contain 'totalSize' field.");
        }
        if (!capacity.isNumber()) {
            throw new SOQLException("Response 'totalSize' is not an int field.");
        }
        JsonNode nextRecordsUrlNode = node.get("nextRecordsUrl");
        if (nextRecordsUrlNode != null) {
            this.nextRecordsUrl = nextRecordsUrlNode.asText();
            Trace.logInfo((Object)this, (String)("There is nextRecordsUrl field in response: " + this.nextRecordsUrl));
        } else {
            this.nextRecordsUrl = null;
        }
        int totalSize = capacity.asInt();
        Trace.logInfo((Object)this, (String)("Result total size: " + totalSize));
        Trace.logInfo((Object)this, (String)("Records Size: " + records.size()));
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            try {
                Row row = new Row(this.rowSet.getRowMetaData());
                JsonNode element = (JsonNode)iterator.next();
                if (element.isObject()) {
                    this.parseObject(row, element, this.objectName);
                    this.rowSet.addToRowSet(row);
                    continue;
                }
                Trace.logError((Object)this, (String)"Root 'records' element is not a json object.");
            }
            catch (Exception ex) {
                Trace.logError((Object)this, (String)("json parse error: " + ex.getMessage()));
                Trace.logException((Object)this, (Throwable)ex, (boolean)true);
            }
        }
        return this.rowSet;
    }

    private List<String> extractColumnNamesFromRecords(JsonNode records) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            this.extractColumnNamesFromRecord((JsonNode)iterator.next(), result, this.objectName);
        }
        return new ArrayList<String>(result);
    }

    private void extractColumnNamesFromRecord(JsonNode record, Set<String> result, String parent) {
        Iterator iterator = record.fields();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (((String)entry.getKey()).equals("attributes")) continue;
                if (((JsonNode)entry.getValue()).isObject()) {
                    this.extractColumnNamesFromRecord((JsonNode)entry.getValue(), result, parent + "." + (String)entry.getKey());
                    continue;
                }
                result.add(parent + "." + (String)entry.getKey());
            }
            catch (Exception ex) {
                Trace.logDebug((Object)this, (String)("Parse entry error: " + ex.getMessage()));
                Trace.logError((Object)this, (String)("Parse entry error: " + ex.getMessage()));
                Trace.logException((Object)this, (Throwable)ex, (boolean)true);
            }
        }
    }

    private void parseObject(Row row, JsonNode node, String parent) {
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)iterator.next();
                Trace.logDebug((Object)this, (String)("Parse entry: " + (String)entry.getKey()));
                if (((String)entry.getKey()).equals("attributes")) {
                    Trace.logDebug((Object)this, (String)"Entry 'attributes' skipped.");
                    continue;
                }
                if (((JsonNode)entry.getValue()).isObject()) {
                    Trace.logDebug((Object)this, (String)("Entry '" + (String)entry.getKey() + "' is json object."));
                    this.parseObject(row, (JsonNode)entry.getValue(), parent + "." + (String)entry.getKey());
                    continue;
                }
                if (((JsonNode)entry.getValue()).isTextual() || ((JsonNode)entry.getValue()).isNumber()) {
                    Trace.logDebug((Object)this, (String)("Entry '" + (String)entry.getKey() + "' is json primitive."));
                    String value = ((JsonNode)entry.getValue()).asText();
                    Trace.logDebug((Object)this, (String)("Set Row column '" + parent + "." + (String)entry.getKey() + "' to ' " + value + "'."));
                    row.setColumn(parent + "." + (String)entry.getKey(), (Object)value);
                    continue;
                }
                if (((JsonNode)entry.getValue()).isNull()) {
                    Trace.logDebug((Object)this, (String)("Entry '" + (String)entry.getKey() + "' is json null. Skipped."));
                    continue;
                }
                if (((JsonNode)entry.getValue()).isArray()) {
                    Trace.logDebug((Object)this, (String)("Entry '" + (String)entry.getKey() + "' is json array. Skipped."));
                    continue;
                }
                Trace.logDebug((Object)this, (String)("Entry '" + (String)entry.getKey() + "' is " + ((JsonNode)entry.getValue()).getNodeType() + ". Skipped."));
            }
            catch (Exception ex) {
                Trace.logDebug((Object)this, (String)("Parse entry error: " + ex.getMessage()));
                Trace.logError((Object)this, (String)("Parse entry error: " + ex.getMessage()));
                Trace.logException((Object)this, (Throwable)ex, (boolean)true);
            }
        }
    }

    private void parseQuery() throws SOQLException {
        try {
            Lexer lexer = LexerFactory.createLexer((String)this.query);
            lexer.setSkipComments(true);
            lexer.readToken("select");
            lexer.skipSpaces();
            int position = lexer.getCurrentPosition();
            boolean tokenRead = false;
            while (!lexer.isAtEnd()) {
                lexer.readToken();
                if (lexer.isCurrentToken((TokenType)CommonTokenType.COMMA) || lexer.isCurrentToken("from")) {
                    if (!tokenRead) {
                        throw new Exception("Unexpected token " + lexer.getCurrentToken());
                    }
                    tokenRead = false;
                    this.columnNames.add(lexer.substring(position, lexer.getCurrentTokenPosition()).trim());
                    lexer.skipSpaces();
                    position = lexer.getCurrentPosition();
                    if (!lexer.isCurrentToken("from")) continue;
                    break;
                }
                if (lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_BRACKET)) {
                    while (!lexer.isAtEnd()) {
                        lexer.readToken();
                        if (!lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_BRACKET)) continue;
                    }
                    if (!lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_BRACKET)) {
                        throw new Exception("Unexpected end of query. Expected close bracket.");
                    }
                    tokenRead = true;
                    continue;
                }
                tokenRead = true;
            }
            if (lexer.isAtEnd() && !lexer.isCurrentToken("from")) {
                this.columnNames.add(lexer.substring(position, lexer.getCurrentTokenPosition()).trim());
            }
            if (lexer.isCurrentToken("from")) {
                this.objectName = lexer.readToken().getValue();
            }
        }
        catch (Exception exception) {
            throw new SOQLException("Failed to parse query. Cuase: " + exception.getMessage(), exception);
        }
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (this.columnNames.get(i).startsWith(this.objectName)) continue;
            this.columnNames.set(i, this.objectName + "." + this.columnNames.get(i));
        }
        Trace.logDebug((Object)this, (String)("Salesforce objectName: " + this.objectName + ", columnNames: " + this.columnNames));
    }
}

