/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.factory.connection.FactoryConnectionMFSession;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.connection.service.SFConnectionService;
import com.streamscape.sf.connection.service.SFFactoryConnectionDSLProvider;
import com.streamscape.sf.connection.soql.SOQLExecutor;
import com.streamscape.sf.connection.soql.SOQLResultToRowSetConverter;
import com.streamscape.slex.AbstractLexiconProcessor;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;

public class SFFactoryConnectionLexiconProcessor
extends AbstractLexiconProcessor<SFConnectionService> {
    public SFFactoryConnectionLexiconProcessor(RuntimeContext context, DSLComponent<SFConnectionService> component) {
        super(context.getLexiconManager(), component);
    }

    protected DSLProvider createBaseProvider(DSLComponent<SFConnectionService> component) {
        return new SFFactoryConnectionDSLProvider((SFConnectionService)((Object)component.getCallable()));
    }

    public SLResponse invoke(String operation, MFSession session, long timeout) throws Exception {
        try {
            return super.invoke(operation, session, timeout);
        }
        catch (UnsupportedRequestException exception) {
            return this.invokeSOQL(operation, session, timeout);
        }
    }

    private SLResponse invokeSOQL(String operation, MFSession session, long timeout) throws Exception {
        SFConnectionService service = (SFConnectionService)((FactoryConnectionMFSession)session).getComponent().getFactoryService();
        SFConnection connection = service.getConnection();
        try {
            SOQLExecutor soqlExecutor = connection.createSOQLExecutor();
            byte[] response = soqlExecutor.execute(operation);
            if (service.getResponseFormat() == null || service.getResponseFormat().equals("rowset")) {
                SOQLResultToRowSetConverter converter = new SOQLResultToRowSetConverter(operation, false, RowSet.class);
                RowSet rs = converter.convert(response);
                while (converter.getNextRecordsUrl() != null && !converter.getNextRecordsUrl().isEmpty()) {
                    response = soqlExecutor.executeURI(converter.getNextRecordsUrl());
                    rs = converter.append(response);
                }
                return new SLResponse(rs);
            }
            return new SLResponse(new String(response));
        }
        catch (Exception exception) {
            return new SLResponse(exception.getMessage(), false);
        }
    }
}

