/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection.soql;

import com.fasterxml.jackson.databind.JsonNode;
import com.streamscape.Trace;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.connection.soql.SOQLException;
import com.streamscape.sf.util.ErrorResponse;

public class SOQLExecutor {
    private SFConnection connection;

    public SOQLExecutor(SFConnection connection) {
        this.connection = connection;
    }

    public byte[] execute(String query) throws SOQLException, ClientException {
        if (query == null || query.isEmpty()) {
            throw new SOQLException("SOQL Query cannot be empty.");
        }
        if (this.isTypeofSoqlQuery(query)) {
            throw new SOQLException("TYPEOF SOQL Queries is not supported yet.");
        }
        HTTPRequest request = new HTTPRequest();
        request.setMethod("get");
        request.setUri(new String(this.connection.getRecourseDirectory() + "/query").replace("//", "/"));
        request.addQueryParameter("q", query);
        Trace.logDebug((Object)this, (String)("CALL: soql - " + query + ", uri - " + request.getUri()));
        HTTPResponse response = this.connection.execute(request);
        ErrorResponse errorResponse = SOQLExecutor.checkErrorResponse(new String(response.getData()));
        if (errorResponse != null) {
            throw new SOQLException("SF Error Response: " + errorResponse.toString());
        }
        return response.getData();
    }

    public byte[] executeURI(String uri) throws SOQLException, ClientException {
        if (uri == null || uri.isEmpty()) {
            throw new SOQLException("URI cannot be empty.");
        }
        HTTPRequest request = new HTTPRequest();
        request.setMethod("get");
        request.setUri(uri);
        Trace.logDebug((Object)this, (String)("CALL: uri - " + request.getUri()));
        HTTPResponse response = this.connection.execute(request);
        ErrorResponse errorResponse = SOQLExecutor.checkErrorResponse(new String(response.getData()));
        if (errorResponse != null) {
            throw new SOQLException("SF Error Response: " + errorResponse.toString());
        }
        return response.getData();
    }

    private boolean isTypeofSoqlQuery(String query) {
        return query.trim().toLowerCase().startsWith("select typeof");
    }

    public static ErrorResponse checkErrorResponse(String response) {
        try {
            JsonNode node = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(response);
            if (node.isArray() && node.size() != 0 && node.get(0).isObject()) {
                Trace.logDebug(SOQLExecutor.class, (String)"Error response has been received.");
                node = node.get(0);
                String message = node.has("message") ? node.get("message").asText() : "";
                String errCode = node.has("errorCode") ? node.get("errorCode").asText() : "";
                return new ErrorResponse(errCode != null ? errCode.trim() : "", message != null ? message.trim() : "");
            }
        }
        catch (Exception ex) {
            Trace.logDebug(SOQLExecutor.class, (String)("error: " + ex.getMessage()));
        }
        return null;
    }
}

