/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection.service;

import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sf.connection.service.SFConnectionService;
import com.streamscape.sf.util.SFInvokeResponse;
import java.util.ArrayList;
import java.util.List;

public class SFCrudExecutionStatement
implements ExecutionStatement {
    private String collectionName;
    private String operationName;
    private List<Object> params = new ArrayList<Object>();

    public SFCrudExecutionStatement(String collectionName, String operationName) {
        this.collectionName = collectionName;
        this.operationName = operationName;
    }

    public void addParam(Object param) {
        this.params.add(param);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("sf." + this.collectionName + "." + this.operationName + "(");
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.params.get(i));
        }
        builder.append(")");
        return builder.toString();
    }

    public List<Object> getExternalExpressions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object param : this.params) {
            if (param instanceof String) continue;
            result.add(param);
        }
        return result;
    }

    public Class<?> resolveType(ExternalExecutionContext externalExecutionContext) {
        return SFInvokeResponse.class;
    }

    public Object execute(ExternalExecutionContext executionContext, Class<?> targetClass) throws Exception {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (Object param : this.params) {
            paramValues.add(executionContext.getValue(param));
        }
        SFInvokeResponse response = null;
        if (this.operationName.equalsIgnoreCase("insert")) {
            response = ((SFConnectionService)((Object)executionContext.getCallable())).getConnection().createSobjectAccessor().create(paramValues.get(0), this.collectionName);
        } else if (this.operationName.equalsIgnoreCase("upsert")) {
            if (!(paramValues.get(0) instanceof String)) {
                throw new Exception("Invalid external id name specified for upsert operation. Should be of type string.");
            }
            if (!(paramValues.get(1) instanceof String)) {
                throw new Exception("Invalid external id specified for upsert operation. Should be of type string.");
            }
            response = ((SFConnectionService)((Object)executionContext.getCallable())).getConnection().createSobjectAccessor().upsert((String)paramValues.get(0), (String)paramValues.get(1), paramValues.get(2), this.collectionName);
        } else if (this.operationName.equalsIgnoreCase("update")) {
            response = ((SFConnectionService)((Object)executionContext.getCallable())).getConnection().createSobjectAccessor().update((String)paramValues.get(0), paramValues.get(1), this.collectionName);
        } else if (this.operationName.equalsIgnoreCase("delete")) {
            if (!(paramValues.get(0) instanceof String)) {
                throw new Exception("Invalid id specified for delete operation. Should be of type string.");
            }
            response = ((SFConnectionService)((Object)executionContext.getCallable())).getConnection().createSobjectAccessor().delete((String)paramValues.get(0), this.collectionName);
        }
        return response;
    }
}

