/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.NVPair;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SOQLQuery;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.connection.soql.SOQLException;
import com.streamscape.sf.connection.soql.SOQLExecutor;
import com.streamscape.sf.service.SFSOQLInvokerVersion;
import com.streamscape.sf.util.ErrorResponse;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class SFSOQLInvoker
extends AbstractService
implements StateNotificationEventListener,
ExceptionEventListener {
    private static final String CONNECTION_FACTORY = "connection.factory";
    private static final String STATIC_CALL = "StaticCall";
    private static final String SOQL_QUERY = "SOQLQuery";
    private static final String SF_VERSION = "SFVersion";
    private static final String namespace = "/sf/soql";
    private static final String uriBeforeVersion = "/services/data/v";
    private static final String uriAfterVersion = "/query/";
    private ClientFactory connFactory = null;
    private boolean staticCall = true;
    private String soqlQueryObject = "";
    private String soqlQuery = "";
    private String sfVersion = "";
    private String[] soqlQuerySelectValues = null;
    private String soqlQueryFromValue = "";
    private SFConnection sfConnection = null;
    private JSONSerializer jsonSerializer = null;
    private final String INVALID_ACCESS_TOKEN = "Access Token is invalid.";

    public RowSet staticSOQLCall() throws ServiceFrameworkException {
        this.ctx.logDebug("staticSOQLCall: " + this.soqlQuery);
        if (this.soqlQuerySelectValues == null || this.soqlQuerySelectValues.length == 0 || this.soqlQueryFromValue == null || this.soqlQueryFromValue.isEmpty()) {
            this.parseSoqlQueryRequest(this.soqlQuery);
        }
        return this.soqlCall(this.soqlQuery, this.soqlQueryFromValue, this.soqlQuerySelectValues);
    }

    public RowSet genericSOQLCall(SOQLQuery soql) throws ServiceFrameworkException {
        this.ctx.logDebug("genericSOQLCall: " + soql.getQuery());
        this.parseSoqlQueryRequest(soql.getQuery());
        return this.soqlCall(soql.getQuery(), this.soqlQueryFromValue, this.soqlQuerySelectValues);
    }

    private RowSet soqlCall(String soql, String soqlQueryFromValue, String[] soqlQuerySelectValues) throws ServiceFrameworkException {
        try {
            ErrorResponse errorResponse;
            if (soql == null || soql.isEmpty()) {
                throw new Exception("SOQL Query cannot be empty.");
            }
            if (this.isTypeofSoqlQuery(soql)) {
                throw new Exception("TYPEOF SOQL Queries is not supported yet.");
            }
            String uri = uriBeforeVersion + this.sfVersion + uriAfterVersion;
            NVPair[] formData = new NVPair[]{new NVPair("q", soql)};
            this.ctx.logInfo("CALL: soql - " + soql + ", uri - " + uri);
            HTTPClientResponse response = this.sfConnection.getHttpClient().Get(uri, formData);
            String responseData = new String(response.getData());
            this.ctx.logDebug(responseData);
            if (this.isInvalidTokenResponse(responseData.getBytes())) {
                this.ctx.logInfo("Trying to get a new access token.");
                this.sendTokenRenewNotification("Access token has expired. Requesting a new one...", ConnectionState.RECONNECTING);
                this.sfConnection.requestAccessToken();
                response = this.sfConnection.getHttpClient().Get(uri, formData);
                responseData = new String(response.getData());
                this.ctx.logDebug(responseData);
                if (this.isInvalidTokenResponse(responseData.getBytes())) {
                    this.sendTokenRenewNotification("Access token renew failed.", ConnectionState.RECONNECTING);
                    this.sfConnection.suspend();
                    responseData = "Access Token is invalid. Connection is suspended.";
                    this.ctx.logError(responseData);
                } else {
                    this.sendTokenRenewNotification("New access token retrieved successfully.", ConnectionState.CONNECTED);
                }
            }
            if ((errorResponse = this.checkResponse(responseData)) == null) {
                return this.parseResponse(responseData, soqlQueryFromValue, soqlQuerySelectValues);
            }
            throw new ServiceFrameworkException(6000, "SF Error Response: " + errorResponse.toString());
        }
        catch (Exception e) {
            this.ctx.logError("Exception in SOQLCall(): " + e.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
            throw new ServiceFrameworkException(6000, (Throwable)e);
        }
    }

    public int getMajorVersion() {
        return SFSOQLInvokerVersion.getMajorVersion();
    }

    public int getMinorVersion() {
        return SFSOQLInvokerVersion.getMinorVersion();
    }

    public int getMinorBuild() {
        return SFSOQLInvokerVersion.getBuild();
    }

    public String getVersion() {
        return SFSOQLInvokerVersion.getVersionString();
    }

    public void start() throws ServiceFrameworkException {
        try {
            this.connFactory = this.ctx.lookupClientFactoryProperty(CONNECTION_FACTORY);
            this.sfConnection = (SFConnection)this.connFactory.createConnection();
            this.sfConnection.setStateNotificationEventListener(this);
            this.sfConnection.setExceptionEventListener(this);
            this.sfConnection.connect();
        }
        catch (Exception e) {
            this.ctx.logError("Exception during SFSOQLInvoker service starting. " + e.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
            throw new ServiceFrameworkException(6065, (Throwable)e);
        }
    }

    protected void doInit() throws ServiceFrameworkException {
        this.ctx.logInfo("SFSOQLInvoker." + this.ctx.getName() + " initialization...");
        try {
            try {
                this.staticCall = this.ctx.lookupBooleanProperty(STATIC_CALL);
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("StaticCall property is not specified");
            }
            try {
                this.soqlQueryObject = this.ctx.lookupStringProperty(SOQL_QUERY);
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("SOQLQuery property is not specified");
            }
            try {
                if (this.soqlQueryObject != null && !this.soqlQueryObject.isEmpty()) {
                    this.soqlQuery = ((SOQLQuery)this.context.getRepositoryAccessor().lookupObject(new ReferenceContext(ReferenceContext.ROOT, namespace), this.soqlQueryObject)).getQuery();
                }
            }
            catch (Exception e) {
                this.ctx.logInfo("Cannot get SOQLQuery object: '" + this.soqlQueryObject + "'");
                throw new Exception("Cannot get SOQLQuery object: '" + this.soqlQueryObject + ".'");
            }
            try {
                this.sfVersion = this.ctx.lookupStringProperty(SF_VERSION);
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logError("SFVersion property is not specified");
                throw new Exception("SFVersion must be specified.");
            }
            if (this.staticCall) {
                if (this.soqlQueryObject == null || this.soqlQueryObject.isEmpty()) {
                    throw new Exception("SOQL Query Object must be specified if Static Call is used.");
                }
                if (this.soqlQuery == null || this.soqlQuery.isEmpty()) {
                    throw new Exception("SOQL Query must be specified if Static Call is used.");
                }
                if (this.isTypeofSoqlQuery(this.soqlQuery)) {
                    throw new Exception("TYPEOF SOQL Queries is not supported yet.");
                }
                this.parseSoqlQueryRequest(this.soqlQuery);
                this.checkSoqlQueryValues(this.soqlQueryFromValue, this.soqlQuerySelectValues);
            }
            String initResult = "SFSOQLInvoker." + this.ctx.getName() + " service initialized: staticCall - " + this.staticCall + ", soqlQueryObject - " + this.soqlQueryObject + ", soqlQuery - " + this.soqlQuery + ", sfVersion - " + this.sfVersion;
            if (this.staticCall) {
                initResult = initResult + ", fromValue - " + this.soqlQueryFromValue + ", selectValues - " + Arrays.toString(this.soqlQuerySelectValues);
            }
            this.ctx.logInfo(initResult);
            this.jsonSerializer = ((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder().setAliasManager((ObjectMediationAliasManager)RuntimeContext.getInstance().getSemanticAliasManager())).setName("SalesforceJSerializer")).setJsonNotation(JsonNotation.TYPE)).setJsonNotationLevel(new JsonNotationLevel[]{JsonNotationLevel.NONE})).build();
        }
        catch (Exception error) {
            this.ctx.logError("Unable to initialize SFSOQLInvoker service. " + error.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new ServiceFrameworkException(6065, error.getMessage());
        }
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("SalesForce connection state changed: " + e.getState().toString());
        try {
            if (e.getState() == ConnectionState.CONNECTED) {
                this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
            } else {
                this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), e.getMessage());
            }
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    public void onEvent(ClientException e) {
        this.ctx.logError(e.getMessage());
    }

    private boolean isTypeofSoqlQuery(String soqlQuery) {
        return soqlQuery.toLowerCase().startsWith("select typeof");
    }

    private boolean isCountRequest(String[] soqlQuerySelectValues) {
        return soqlQuerySelectValues != null && soqlQuerySelectValues.length == 1 && soqlQuerySelectValues[0].equalsIgnoreCase("count()");
    }

    private void parseSoqlQueryRequest(String soqlQuery) {
        this.soqlQueryFromValue = this.parseSoqlQueryFromValue(soqlQuery);
        this.soqlQuerySelectValues = this.parseSoqlQuerySelectValues(soqlQuery);
        if (this.isCountRequest(this.soqlQuerySelectValues)) {
            return;
        }
        for (int i = 0; i < this.soqlQuerySelectValues.length; ++i) {
            if (this.soqlQuerySelectValues[i].startsWith(this.soqlQueryFromValue)) continue;
            this.soqlQuerySelectValues[i] = this.soqlQueryFromValue + "." + this.soqlQuerySelectValues[i];
        }
    }

    private String[] parseSoqlQuerySelectValues(String soqlQuery) {
        String selectExpression = soqlQuery.substring("select ".length(), soqlQuery.toLowerCase().indexOf(" from "));
        selectExpression = selectExpression.replaceAll(" ", "");
        String[] selectValues = selectExpression.split(",");
        return selectValues;
    }

    private String parseSoqlQueryFromValue(String soqlQuery) {
        String fromSubValue = soqlQuery.substring(soqlQuery.toLowerCase().indexOf(" from ") + " from ".length()).trim();
        int firstSpaceIndex = fromSubValue.indexOf(" ");
        return firstSpaceIndex == -1 ? fromSubValue : fromSubValue.substring(0, firstSpaceIndex).trim();
    }

    private void checkSoqlQueryValues(String fromValue, String[] selectValues) throws Exception {
        if (fromValue == null || fromValue.isEmpty()) {
            throw new Exception("SOQLQuery parse error. Cannot get FROM value.");
        }
        if (selectValues == null || selectValues.length == 0) {
            throw new Exception("SOQLQuery parse error. Cannot get SELECT values.");
        }
    }

    private RowSet parseResponse(String responseData, String sfObjectName, String[] selectValues) throws Exception {
        this.ctx.logInfo("Parse response and fill RowSet.");
        this.ctx.logInfo("sfObjectName - " + sfObjectName + ", selectValues - " + Arrays.toString((Object[])selectValues));
        this.checkSoqlQueryValues(sfObjectName, (String[])selectValues);
        JsonNode node = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(responseData);
        JsonNode records = node.get("records");
        if (records == null) {
            throw new SOQLException("Response does not contain 'records' field.");
        }
        if (!records.isArray()) {
            throw new SOQLException("Response 'records' is not an array.");
        }
        JsonNode capacity = node.get("totalSize");
        if (capacity == null) {
            throw new SOQLException("Response does not contain 'totalSize' field.");
        }
        if (!capacity.isNumber()) {
            throw new SOQLException("Response 'totalSize' is not an int field.");
        }
        int totalSize = capacity.asInt();
        this.ctx.logInfo("Result total size: " + totalSize);
        if (this.isCountRequest((String[])selectValues)) {
            RowMetaData rowMetaData = new RowMetaData();
            rowMetaData.addColumn("count");
            RowSet rowSet = new RowSet(rowMetaData);
            rowSet.getMeta().setCapacity(1);
            Row row = new Row(rowSet.getRowMetaData());
            row.setColumn("count", (Object)totalSize);
            rowSet.addToRowSet(row);
            return rowSet;
        }
        RowMetaData rowMetaData = new RowMetaData();
        for (String selectValue : selectValues) {
            rowMetaData.addColumn(selectValue);
        }
        RowSet rowSet = new RowSet(rowMetaData);
        rowSet.getMeta().setCapacity(capacity.asInt());
        this.ctx.logInfo("Records Size: " + records.size());
        Iterator elements = records.iterator();
        while (elements.hasNext()) {
            try {
                Row row = new Row(rowSet.getRowMetaData());
                JsonNode element = (JsonNode)elements.next();
                if (element.isObject()) {
                    this.parseObject(row, element, sfObjectName);
                    rowSet.addToRowSet(row);
                    continue;
                }
                this.ctx.logError("Root 'records' element is not JSONObject.");
            }
            catch (Exception ex) {
                this.ctx.logError("JSONObject parse error: " + ex.getMessage());
                Trace.logError((Object)((Object)this), (String)("JSONObject parse error: " + ex.getMessage()));
                Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
            }
        }
        return rowSet;
    }

    private void parseObject(Row row, JsonNode jsonObject, String parent) {
        Iterator iterator = jsonObject.fields();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.ctx.logDebug("Parse entry: " + (String)entry.getKey());
                if (((String)entry.getKey()).equals("attributes")) {
                    this.ctx.logDebug("Entry 'attributes' skipped.");
                    continue;
                }
                if (((JsonNode)entry.getValue()).isObject()) {
                    this.ctx.logDebug("Entry '" + (String)entry.getKey() + "' is JSONObject.");
                    this.parseObject(row, (JsonNode)entry.getValue(), parent + "." + (String)entry.getKey());
                    continue;
                }
                if (((JsonNode)entry.getValue()).isTextual() || ((JsonNode)entry.getValue()).isNumber()) {
                    this.ctx.logDebug("Entry '" + (String)entry.getKey() + "' is JSONPrimitive.");
                    String value = ((JsonNode)entry.getValue()).asText();
                    this.ctx.logDebug("Set Row column '" + parent + "." + (String)entry.getKey() + "' to ' " + value + "'.");
                    row.setColumn(parent + "." + (String)entry.getKey(), (Object)value);
                    continue;
                }
                if (((JsonNode)entry.getValue()).isNull()) {
                    this.ctx.logDebug("Entry '" + (String)entry.getKey() + "' is JSONNull. Skipped.");
                    continue;
                }
                if (((JsonNode)entry.getValue()).isArray()) {
                    this.ctx.logDebug("Entry '" + (String)entry.getKey() + "' is JSONArray. Skipped.");
                    continue;
                }
                this.ctx.logDebug("Entry '" + (String)entry.getKey() + "' is unknown.");
            }
            catch (Exception ex) {
                this.ctx.logError("Parse entry error: " + ex.getMessage());
                Trace.logError((Object)((Object)this), (String)("Parse entry error: " + ex.getMessage()));
                Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
            }
        }
    }

    private ErrorResponse checkResponse(String response) {
        this.ctx.logDebug("Check Response...");
        try {
            JsonNode node = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(response);
            if (node.isArray() && node.size() != 0 && node.get(0).isObject()) {
                Trace.logDebug(SOQLExecutor.class, (String)"Error response has been received.");
                node = node.get(0);
                String message = node.has("message") ? node.get("message").asText() : "";
                String errCode = node.has("errorCode") ? node.get("errorCode").asText() : "";
                return new ErrorResponse(errCode != null ? errCode.trim() : "", message != null ? message.trim() : "");
            }
            this.ctx.logDebug("It is not error response.");
        }
        catch (Exception ex) {
            this.ctx.logDebug("error: " + ex.getMessage());
        }
        return null;
    }

    private boolean isInvalidTokenResponse(byte[] response) {
        ErrorResponse errResp;
        byte[] prResp = Arrays.copyOfRange(response, 1, response.length - 1);
        try {
            errResp = (ErrorResponse)this.jsonSerializer.deserialize("ErrorResponse", prResp);
        }
        catch (Exception e) {
            this.ctx.logDebug(new String(response));
            this.ctx.logDebug(new String(prResp));
            this.ctx.logDebug("isInvalidTokenResponse serialization failed");
            return false;
        }
        if (errResp.getErrorCode() != null && errResp.getErrorCode().equals("INVALID_SESSION_ID")) {
            this.ctx.logError("Access Token is invalid.");
            return true;
        }
        return false;
    }

    private void sendTokenRenewNotification(String message, ConnectionState state) {
        try {
            ConnectionStateChangeAdvisory e = new ConnectionStateChangeAdvisory();
            e.setConnectionName(this.sfConnection.getName());
            e.setMessage(message);
            e.setState(state);
            e.setEventKey("Token");
            e.setConnectionUrl(this.sfConnection != null ? this.sfConnection.getUrl() : "");
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)false);
        }
    }
}

