/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.ShowRuntimeContextOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sf.connection.service.SFConnectionService;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.Iterator;

public class SFFactoryConnectionDSLProvider
extends AbstractDSLProvider<SFConnectionService> {
    private static final String NAME = "SFFactoryConnectionDSLProvider";

    SFFactoryConnectionDSLProvider(SFConnectionService callable) {
        super(NAME, (SLCallable)callable);
        this.registerOperation((Operation)new SetSFResponseFormatOperation());
        this.registerOperation((Operation)new GetSFResponseFormatOperation());
        this.registerOperation((Operation)new SFListCollectionsOperation());
        this.registerOperation((Operation)new SFDescribeCollectionsOperation());
        this.registerOperation((Operation)new ShowRuntimeContextOperation());
        this.activate((SLCallable)callable);
    }

    protected RuntimeContext getRuntimeContext() {
        return RuntimeContext.getInstance();
    }

    protected String getTagsFilePrefix() {
        return "SalesforceConnection";
    }

    static class SFDescribeCollectionsOperation
    extends AbstractSFFactoryConnectionOperation {
        public static final String NAME = "describe collection";

        public SFDescribeCollectionsOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME).addActionParameter((SyntaxParameter)new IdentifierParameter("CollectionName"));
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR ID").addParameter((SyntaxParameter)new IdentifierParameter("ID"))).setRequired(false));
            this.syntax.addModifier((AbstractModifier)new Modifier("AS JSON").setRequired(false));
            this.syntax.setDescription("Describes Salesforce collection object.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement.getParameter("CollectionName").getValue(), statement.existsParameter("ID") ? statement.getParameter("ID").getValue() : null, statement.existsModifier("AS JSON"));
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            Definition definition = (Definition)statement;
            String collectionJson = ((SFConnectionService)this.callable).getConnection().createSobjectAccessor().describeObject(definition.collectionName, definition.id);
            ObjectMapper mapper = JSONSerializerFactory.getInstance().getDefaultEmptyMapper();
            JsonNode tree = mapper.readTree(collectionJson);
            if (definition.asJSON) {
                String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
                return new SLResponse(json);
            }
            RowSet rowSet = new RowSet(new RowMetaData().addColumn("Name", String.class).addColumn("Type", String.class).addColumn("Nullable", Boolean.TYPE).addColumn("User-Defined", Boolean.TYPE));
            JsonNode fieldsNode = tree.get("fields");
            Iterator fieldsIterator = fieldsNode.elements();
            while (fieldsIterator.hasNext()) {
                JsonNode field = (JsonNode)fieldsIterator.next();
                JsonNode name = field.get("name");
                JsonNode type = field.get("type");
                JsonNode nillable = field.get("nillable");
                rowSet.addToRowSet(new Object[]{name != null ? name.asText() : "", type != null ? type.asText() : "", nillable != null ? nillable.asBoolean() : false, name != null && name.asText().endsWith("__c")});
            }
            return new SLResponse(rowSet);
        }

        static class Definition
        extends AbstractSLStatement {
            String collectionName;
            String id;
            private boolean asJSON;

            protected Definition(String collectionName, String id, boolean asJSON) {
                super(SFDescribeCollectionsOperation.NAME);
                this.collectionName = collectionName;
                this.id = id;
                this.asJSON = asJSON;
            }
        }
    }

    static class SFListCollectionsOperation
    extends AbstractSFFactoryConnectionOperation {
        public static final String NAME = "list collections";

        public SFListCollectionsOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.setDescription("List Salesforce objects.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            RowSet result = new RowSet(SFListCollectionsOperation.createResultDescriptor());
            for (String name : ((SFConnectionService)this.callable).getConnection().createSobjectAccessor().listSobjectNames()) {
                result.addToRowSet(new Object[]{name});
            }
            return new SLResponse(result);
        }

        static RowMetaData createResultDescriptor() {
            RowMetaData result = new RowMetaData(10);
            SFListCollectionsOperation.addColumn((RowMetaData)result, (String)"Collection Name");
            return result;
        }

        static class Definition
        extends AbstractSLStatement {
            protected Definition() {
                super(SFListCollectionsOperation.NAME);
            }
        }
    }

    static class GetSFResponseFormatOperation
    extends AbstractSFFactoryConnectionOperation {
        public static final String NAME = "get response format";

        public GetSFResponseFormatOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("GET RESPONSE FORMAT");
            this.syntax.setDescription("Gets response format of SOQL queries.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return new SLResponse(((SFConnectionService)this.callable).getResponseFormat());
        }

        static class Definition
        extends AbstractSLStatement {
            protected Definition() {
                super(GetSFResponseFormatOperation.NAME);
            }
        }
    }

    static class SetSFResponseFormatOperation
    extends AbstractSFFactoryConnectionOperation {
        public static final String NAME = "set response format";

        public SetSFResponseFormatOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("SET RESPONSE FORMAT");
            this.syntax.addModifier((AbstractModifier)new ChoiceModifier("ResponseFormat").addPossibleValues(new String[]{"json", "rowset"}).setSyntaxHint(SyntaxHint.SPACE));
            this.syntax.setDescription("Sets response format of SOQL queries.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement.getModifier("ResponseFormat").getToken());
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ((SFConnectionService)this.callable).setResponseFormat(((Definition)statement).responseFormat);
            return new SLResponse();
        }

        static class Definition
        extends AbstractSLStatement {
            private String responseFormat;

            protected Definition(String responseFormat) {
                super(SetSFResponseFormatOperation.NAME);
                this.responseFormat = responseFormat;
            }
        }
    }

    static abstract class AbstractSFFactoryConnectionOperation
    extends AbstractDSLOperation<SFConnectionService> {
        AbstractSFFactoryConnectionOperation() {
        }

        protected void createDSLSyntax(String name) {
            super.createDSLSyntax(name);
            this.syntax.addTag("salesforce");
        }

        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            try {
                return this.onInvoke(statement, session, timeout);
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage());
            }
        }

        protected abstract SLResponse onInvoke(SLStatement var1, MFSession var2, long var3) throws Exception;
    }
}

