/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection;

import com.fasterxml.jackson.databind.JsonNode;
import com.streamscape.Trace;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.connection.SobjectAccessorException;
import com.streamscape.sf.util.SFInvokeResponse;
import com.streamscape.sf.util.SFMapObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SobjectAccessor {
    private SFConnection connection;
    private JSONSerializer jsonSerializer;
    private HashMap<String, Vector<String>> exclusionListCL = new HashMap();
    private String[] sharedExclusionList = new String[]{"LastModifiedDate", "LastActivityDate", "SystemModstamp", "LastModifiedById", "MasterRecordId", "CreatedById", "CreatedDate", "IsDeleted", "JigsawCompanyId"};

    public SobjectAccessor(SFConnection connection) {
        this.connection = connection;
        this.jsonSerializer = RuntimeContext.getInstance().getJSONSerializerFactory().getDefaultSerializer();
    }

    public SFInvokeResponse create(Object object, String sfObjName) throws ClientException, SobjectAccessorException {
        return this.create(this.serializerToSFMap(object), sfObjName);
    }

    public SFInvokeResponse create(SFMapObject mapObject, String sfObjName) throws ClientException, SobjectAccessorException {
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug((Object)this, (String)("Icomming object: " + mapObject));
        }
        mapObject.getMap().remove("Id");
        this.applyExclusionList(mapObject.getMap(), "sf" + sfObjName);
        byte[] serialized = this.serializeToSFcompatibleJSONobj(mapObject);
        HTTPRequest request = new HTTPRequest();
        request.addHeader("Content-Type", "application/json");
        request.setUri((this.connection.getRecourseDirectory() + "/sobjects/").replace("//", "/") + sfObjName + "/");
        request.setData(serialized);
        request.setMethod("POST");
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug((Object)this, (String)("create URL: " + request.getUri()));
            Trace.logDebug((Object)this, (String)new String(serialized));
        }
        HTTPResponse response = this.connection.execute(request);
        Trace.logInfo((Object)this, (String)("create response (" + response.getStatusCode() + "): " + (response.getData() != null ? new String(response.getData()) : null)));
        return new SFInvokeResponse(response.getStatusCode(), response.getData() != null ? new String(response.getData()) : null);
    }

    public SFInvokeResponse update(String id, Object object, String sfObjName) throws SobjectAccessorException, ClientException {
        SFMapObject map = this.serializerToSFMap(object);
        map.getMap().put("Id", id);
        return this.update(map, sfObjName);
    }

    public SFInvokeResponse update(Object object, String sfObjName) throws SobjectAccessorException, ClientException {
        SFMapObject map = this.serializerToSFMap(object);
        return this.update(map, sfObjName);
    }

    public SFInvokeResponse update(SFMapObject mapObject, String sfObjName) throws SobjectAccessorException, ClientException {
        String id = mapObject.getMap().get("Id");
        if (id == null || id.isEmpty()) {
            return new SFInvokeResponse("Id is not specified. Cannot update " + sfObjName + " without Id.");
        }
        mapObject.getMap().remove("Id");
        this.applyExclusionList(mapObject.getMap(), "sf" + sfObjName);
        byte[] serialized = this.serializeToSFcompatibleJSONobj(mapObject);
        HTTPRequest request = new HTTPRequest();
        request.addHeader("Content-Type", "application/json");
        request.setUri((this.connection.getRecourseDirectory() + "/sobjects/").replace("//", "/") + sfObjName + "/" + id);
        request.setData(serialized);
        request.setMethod("PATCH");
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug((Object)this, (String)("upsert URL: " + request.getUri()));
            Trace.logDebug((Object)this, (String)new String(serialized));
        }
        HTTPResponse response = this.connection.execute(request);
        Trace.logInfo((Object)this, (String)("update response (" + response.getStatusCode() + "): " + (response.getData() != null ? new String(response.getData()) : null)));
        return new SFInvokeResponse(response.getStatusCode(), response.getData() != null ? new String(response.getData()) : null);
    }

    public SFInvokeResponse upsert(String externaIdName, String externalId, Object object, String sfObjName) throws SobjectAccessorException, ClientException {
        SFMapObject map = this.serializerToSFMap(object);
        map.getMap().put(externaIdName, externalId);
        return this.upsert(externaIdName, map, sfObjName);
    }

    public SFInvokeResponse upsert(String externaIdName, Object object, String sfObjName) throws SobjectAccessorException, ClientException {
        SFMapObject map = this.serializerToSFMap(object);
        return this.upsert(externaIdName, map, sfObjName);
    }

    public SFInvokeResponse upsert(String externaIdName, SFMapObject mapObject, String sfObjName) throws SobjectAccessorException, ClientException {
        String externalId = mapObject.getMap().remove(externaIdName);
        if (externalId == null || externalId.isEmpty()) {
            return new SFInvokeResponse("ExternalId '" + externaIdName + "' is not specified. Cannot upsert " + sfObjName + " without Id.");
        }
        mapObject.getMap().remove("Id");
        this.applyExclusionList(mapObject.getMap(), "sf" + sfObjName);
        byte[] serialized = this.serializeToSFcompatibleJSONobj(mapObject);
        HTTPRequest request = new HTTPRequest();
        request.addHeader("Content-Type", "application/json");
        request.setUri((this.connection.getRecourseDirectory() + "/sobjects/").replace("//", "/") + sfObjName + "/" + externaIdName + "/" + externalId);
        request.setData(serialized);
        request.setMethod("PATCH");
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug((Object)this, (String)("upsert URL: " + request.getUri()));
            Trace.logDebug((Object)this, (String)new String(serialized));
        }
        HTTPResponse response = this.connection.execute(request);
        Trace.logInfo((Object)this, (String)("upsert response (" + response.getStatusCode() + "): " + (response.getData() != null ? new String(response.getData()) : null)));
        return new SFInvokeResponse(response.getStatusCode(), response.getData() != null ? new String(response.getData()) : null);
    }

    public SFInvokeResponse delete(String id, String sfObjName) throws ClientException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Id", id);
        return this.delete(new SFMapObject(map), sfObjName);
    }

    public SFInvokeResponse delete(SFMapObject mapObject, String sfObjName) throws ClientException {
        String id = mapObject.getMap().get("Id");
        if (id == null || id.isEmpty()) {
            return new SFInvokeResponse("Id is not specified. Cannot delete " + sfObjName + " without Id.");
        }
        HTTPRequest request = new HTTPRequest();
        request.addHeader("Content-Type", "application/json");
        request.setUri((this.connection.getRecourseDirectory() + "/sobjects/").replace("//", "/") + sfObjName + "/" + id);
        request.setMethod("DELETE");
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug((Object)this, (String)("delete URL: " + request.getUri()));
        }
        HTTPResponse response = this.connection.execute(request);
        Trace.logInfo((Object)this, (String)("delete response (" + response.getStatusCode() + "): " + (response.getData() != null ? new String(response.getData()) : null)));
        return new SFInvokeResponse(response.getStatusCode(), response.getData() != null ? new String(response.getData()) : null);
    }

    private SFMapObject serializerToSFMap(Object object) throws SobjectAccessorException {
        try {
            return new SFMapObject(object);
        }
        catch (Exception exception) {
            throw new SobjectAccessorException("Failed to serialize object. Cause: " + exception.getMessage());
        }
    }

    private byte[] serializeToSFcompatibleJSONobj(SFMapObject mapObject) throws SobjectAccessorException {
        byte[] serialized;
        try {
            serialized = this.jsonSerializer.serialize("SFMapObject", (Object)mapObject).getBytes();
        }
        catch (Exception exception) {
            throw new SobjectAccessorException("Failed to serialize SFMapObject. Cause: " + exception.getMessage());
        }
        return this.makeSFcompatibleJSONobj("SFMapObject", "map", serialized);
    }

    private byte[] makeSFcompatibleJSONobj(String objName, String fieldName, byte[] input) {
        return Arrays.copyOfRange(input, objName.length() + fieldName.length() + 8, input.length - 2);
    }

    private HashMap<String, String> applyExclusionList(HashMap<String, String> hashMap, String simpleClassName) {
        Vector<String> fieldsCU;
        if (hashMap.get("OwnerId") == null || hashMap.get("OwnerId").isEmpty()) {
            hashMap.remove("OwnerId");
        }
        for (String entry : this.sharedExclusionList) {
            hashMap.remove(entry);
        }
        if (this.exclusionListCL != null && (fieldsCU = this.exclusionListCL.get(simpleClassName)) != null) {
            for (String entry : fieldsCU) {
                hashMap.remove(entry);
            }
        }
        return hashMap;
    }

    private String listSobjects() throws ClientException, SobjectAccessorException {
        HTTPRequest request = new HTTPRequest();
        request.setUri((this.connection.getRecourseDirectory() + "/sobjects/").replace("//", "/"));
        request.setMethod("get");
        HTTPResponse response = this.connection.execute(request);
        if (response.getStatusCode() != 200) {
            throw new SobjectAccessorException("Salesforce response is not OK. Status: " + response.getStatusCode() + ", data: " + (response.getData() != null ? new String(response.getData()) : null));
        }
        if (response.getData() == null) {
            throw new SobjectAccessorException("Salesforce response is null.");
        }
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug((Object)this, (String)("Salesforce response: " + new String(response.getData())));
        }
        return new String(response.getData());
    }

    private Iterator<JsonNode> getSobjectsIterator() throws ClientException, SobjectAccessorException {
        String json = this.listSobjects();
        try {
            JsonNode node = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(json);
            if (!node.isObject()) {
                throw new SobjectAccessorException("Salesforce response is not json object.");
            }
            if (!node.has("sobjects")) {
                throw new SobjectAccessorException("Salesforce response doesn't contain sobjects.");
            }
            if ((node = node.get("sobjects")) == null || !node.isArray()) {
                throw new SobjectAccessorException("Salesforce sobjects is not array.");
            }
            return node.iterator();
        }
        catch (IOException exception) {
            Trace.logError((Object)this, (String)("Salesforce response: " + json));
            throw new SobjectAccessorException("Failed to parse salesforce response. Cause: " + exception.getMessage());
        }
    }

    public List<String> listSobjectNames() throws ClientException, SobjectAccessorException {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<JsonNode> i = this.getSobjectsIterator();
        while (i.hasNext()) {
            JsonNode sobject = i.next();
            if (!sobject.isObject()) {
                throw new SobjectAccessorException("Salesforce sobjects array contains not object members.");
            }
            if (!sobject.has("name")) {
                Trace.logError((Object)this, (String)"Salesforce sobjects array object doesn't contain name field.");
                continue;
            }
            String name = sobject.get("name").asText();
            if (name == null) continue;
            result.add(name);
        }
        return result;
    }

    public String describeObject(String objectName) throws ClientException, SobjectAccessorException {
        return this.describeObject(objectName, null);
    }

    public String describeObject(String objectName, String id) throws ClientException, SobjectAccessorException {
        Iterator<JsonNode> i = this.getSobjectsIterator();
        while (i.hasNext()) {
            String url;
            String urlName;
            JsonNode sobject = i.next();
            if (!sobject.isObject()) {
                throw new SobjectAccessorException("Salesforce sobjects array contains not object members.");
            }
            if (!sobject.has("name")) {
                Trace.logError((Object)this, (String)"Salesforce sobjects array object doesn't contain name field.");
                continue;
            }
            String name = sobject.get("name").asText();
            if (!objectName.equals(name)) continue;
            JsonNode urls = sobject.get("urls");
            String string = urlName = id != null ? "rowTemplate" : "describe";
            if (urls != null && urls.isObject() && urls.get(urlName) != null && (url = urls.get(urlName).asText()) != null) {
                if (id != null) {
                    url = url.replace("{ID}", id);
                }
                HTTPRequest request = new HTTPRequest();
                request.setUri(url);
                request.setMethod("get");
                HTTPResponse response = this.connection.execute(request);
                if (response.getStatusCode() != 200) {
                    throw new SobjectAccessorException("Salesforce response is not OK. Status: " + response.getStatusCode() + ", data: " + (response.getData() != null ? new String(response.getData()) : null));
                }
                if (response.getData() == null) {
                    throw new SobjectAccessorException("Salesforce response is null.");
                }
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logDebug((Object)this, (String)("Salesforce response: " + new String(response.getData())));
                }
                return new String(response.getData());
            }
            throw new SobjectAccessorException("Describe url not found for collection '" + objectName + "'.");
        }
        throw new SobjectAccessorException("Collection '" + objectName + "' doesn't exist.");
    }
}

