/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.sf.connection.SFConnection;

public class SFConnectionObserver
implements Runnable {
    private SFConnection connection = null;
    private long connectionCheckInterval = 0L;
    private int reconnectRetries = 0;
    private FabricThread<?> executor = null;
    private volatile boolean runnable = false;
    private volatile boolean forceStateCheck = false;
    private int reconnectCounter = 0;

    public SFConnectionObserver(SFConnection connection, ClientFactory factory) {
        this.connection = connection;
        this.connectionCheckInterval = factory.getCheckInterval();
        this.reconnectRetries = factory.getReconnectRetries();
        this.executor = FabricThreadManager.getInstance().createThread("SVC:SF.Connection:Observer", "SF connection observer.", (Runnable)this);
    }

    public boolean isActive() {
        return this.runnable;
    }

    public void start() {
        this.runnable = true;
        this.executor.start();
    }

    public synchronized void stop() {
        this.runnable = false;
        this.executor.interrupt();
    }

    public void forceStateCheck() {
        this.forceStateCheck = true;
        this.executor.interrupt();
    }

    @Override
    public void run() {
        while (this.runnable) {
            try {
                this.doExecute();
            }
            catch (InterruptedException ex) {
                if (this.forceStateCheck && this.runnable) {
                    this.forceStateCheck = false;
                    continue;
                }
                this.stop();
            }
        }
        this.connection.disconnect();
        this.executor.stop();
    }

    public void doExecute() throws InterruptedException {
        if (this.reconnectRetries > 0 && this.reconnectRetries == this.reconnectCounter) {
            Trace.logInfo((Object)this, (String)("Number of reconnect retries exceeded. Closing connection '" + this.connection.getName() + "'."));
            this.stop();
            return;
        }
        if (this.connection.getState() == ConnectionState.RECONNECTING) {
            Trace.logInfo((Object)this, (String)("Attempting to re-establish connection '" + this.connection.getName() + "'.."));
            ++this.reconnectCounter;
            this.connection.resume();
        } else if (this.connection.getState() == ConnectionState.CONNECTED) {
            this.reconnectCounter = 0;
            Trace.logDebug((Object)this, (String)"Connection observer query execution OK.");
        }
        Thread.sleep(this.connectionCheckInterval);
    }
}

