/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.HTTPRequestExecutor;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.http.ProtocolNotSuppException;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.sef.factory.connection.UsableClientConnection;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.sf.connection.SFConnectionObserver;
import com.streamscape.sf.connection.SobjectAccessor;
import com.streamscape.sf.connection.service.SFConnectionService;
import com.streamscape.sf.connection.soql.SOQLExecutor;
import com.streamscape.sf.util.ErrorResponse;
import com.streamscape.sf.util.SFAuthenticationResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class SFConnection
extends AbstractClientConnection
implements UsableClientConnection {
    private String tokenRequestUrl = "";
    private String username = "";
    private String password = "";
    private String securityToken = "";
    private String client_id = "";
    private String client_secret = "";
    private String instanceURL = "";
    private String accessToken = "";
    private String recourseDirectory = "";
    private String id = "";
    private SFConnectionObserver observer = null;
    private HTTPClient httpClient = null;
    private int timeOut = -1;
    protected JSONSerializer jsonSerializer = null;
    private final String INVALID_ACCESS_TOKEN = "Access Token is invalid.";

    public void init(ClientFactory factory) throws ClientException {
        this.factory = factory;
        this.username = factory.getDefaultUser();
        this.password = factory.getDefaultPassword();
        this.timeOut = factory.getConnectionTimeout();
        this.tokenRequestUrl = factory.getProperty("tokenRequestUrl");
        this.securityToken = factory.getProperty("securityToken");
        this.client_id = factory.getProperty("Client_ID");
        this.client_secret = factory.getProperty("Client_Secret");
        this.recourseDirectory = factory.getProperty("recourseDirectory");
    }

    public void connect() throws ClientException {
        if (this.factory.isReliable() && this.observer == null) {
            Trace.logInfo((Object)((Object)this), (String)"Starting reliable connection observer thread");
            this.observer = new SFConnectionObserver(this, this.factory);
            this.observer.start();
        }
        Trace.logInfo((Object)((Object)this), (String)"Get SalesForce access token");
        this.setState(ConnectionState.CONNECTING);
        try {
            this.requestAccessToken();
        }
        catch (Exception error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            this.setState(ConnectionState.RECONNECTING);
            this.raiseException((Exception)new ClientException(1011, "Cannot connect to SalesForce. Exception: " + error.getMessage()));
        }
    }

    public void disconnect() {
        this.setState(ConnectionState.CLOSING);
        if (this.factory.isReliable() && this.observer != null && this.observer.isActive()) {
            Trace.logInfo((Object)((Object)this), (String)"Stopping reliable connection observer thread");
            this.observer.stop();
            return;
        }
        this.setState(ConnectionState.CLOSED);
    }

    public void resume() {
        Trace.logInfo((Object)((Object)this), (String)"Try to get SalesFroce access token");
        try {
            this.requestAccessToken();
        }
        catch (Exception error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            this.setState(ConnectionState.RECONNECTING);
            this.raiseException((Exception)new ClientException(1011, "Cannot resume connection to SalesForce. Exception: " + error.getMessage()));
        }
    }

    public void suspend() {
        Trace.logInfo((Object)((Object)this), (String)"Suspend SalesFroce connection");
        this.setState(ConnectionState.RECONNECTING);
    }

    public synchronized void requestAccessToken() throws IOException, ModuleException, SerializerException {
        URL url = new URL(this.tokenRequestUrl);
        HTTPClient client = new HTTPClient(url);
        client.setAllowUserInteraction(false);
        if (this.timeOut >= 0) {
            client.setTimeout((long)(this.timeOut * 1000));
        }
        NVPair[] headers = new NVPair[]{new NVPair("grant_type", "password"), new NVPair("client_id", this.client_id), new NVPair("client_secret", this.client_secret), new NVPair("username", this.username), new NVPair("password", this.securityToken != null ? this.password + this.securityToken : this.password)};
        Trace.logDebug((Object)((Object)this), (String)("client_id: " + this.client_id));
        Trace.logDebug((Object)((Object)this), (String)("client_secret: " + this.client_secret));
        Trace.logDebug((Object)((Object)this), (String)("username: " + this.username));
        Trace.logDebug((Object)((Object)this), (String)("securityToken: " + this.securityToken));
        HTTPClientResponse resp = client.Post(url.getFile(), headers);
        Trace.logDebug((Object)((Object)this), (String)("SF connect response: " + new String(resp.getData())));
        this.jsonSerializer = ((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder().setAliasManager((ObjectMediationAliasManager)RuntimeContext.getInstance().getSemanticAliasManager())).setName("SalesforceJSerializer")).setJsonNotation(JsonNotation.TYPE)).setJsonNotationLevel(new JsonNotationLevel[]{JsonNotationLevel.NONE})).build();
        SFAuthenticationResponse authResp = (SFAuthenticationResponse)this.jsonSerializer.deserialize(SFAuthenticationResponse.class.getSimpleName(), resp.getData());
        this.instanceURL = authResp.getInstanceUrl();
        this.accessToken = authResp.getAccessToken();
        this.id = this.parseId(authResp.getId());
        Trace.logDebug((Object)((Object)this), (String)("instanceURL: " + this.instanceURL));
        Trace.logDebug((Object)((Object)this), (String)("accessToken: " + this.accessToken));
        if (this.accessToken == null || this.accessToken.isEmpty()) {
            this.raiseException((Exception)new ClientException(1011, "Unable to obtain Access Token from http End-Point \"" + this.tokenRequestUrl + "\", Response message: " + new String(resp.getData())));
            this.setState(ConnectionState.RECONNECTING);
        } else if (this.instanceURL == null || this.instanceURL.isEmpty()) {
            this.raiseException((Exception)new ClientException(1011, "Unable to obtain instance URL from http End-Point \"" + this.tokenRequestUrl + "\", Response message: " + new String(resp.getData())));
            this.setState(ConnectionState.RECONNECTING);
        } else {
            Trace.logInfo((Object)((Object)this), (String)"SalesForce access token has been received");
            this.initializeHTTPClient(this.instanceURL, this.accessToken);
            this.setState(ConnectionState.CONNECTED);
        }
    }

    private void initializeHTTPClient(String instanceUrl, String accessToken) throws MalformedURLException, ProtocolNotSuppException {
        Class[] modules;
        URL url = new URL(instanceUrl);
        this.httpClient = new HTTPClient(url);
        this.httpClient.setAllowUserInteraction(false);
        NVPair[] headers = new NVPair[]{new NVPair("Authorization", "Bearer " + accessToken)};
        this.httpClient.setDefaultHeaders(headers);
        for (Class module : modules = this.httpClient.getModules()) {
            this.httpClient.removeModule(module);
        }
        if (this.timeOut >= 0) {
            this.httpClient.setTimeout((long)(this.timeOut * 1000));
        }
    }

    public int ping() throws ClientException {
        return 0;
    }

    public void raiseException(Exception exception) {
        if (this.getExceptionEventListener() != null) {
            this.getExceptionEventListener().onEvent(exception instanceof ClientException ? (ClientException)exception : new ClientException(1031, (Throwable)exception));
        }
    }

    public ClientFactory getFactory() {
        return this.factory;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public String getUrl() {
        return this.tokenRequestUrl;
    }

    public String getInstanceURL() {
        return this.instanceURL;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRecourseDirectory() {
        return this.recourseDirectory;
    }

    public String getRecourseDirectoryWithVersion() {
        String sfVersion = this.getFactory().getProperty("sfVersion");
        if (sfVersion != null) {
            return this.recourseDirectory + "/" + sfVersion;
        }
        return this.recourseDirectory;
    }

    public String getId() {
        return this.id;
    }

    public HTTPClient getHttpClient() {
        return this.httpClient;
    }

    private String parseId(String id) {
        int pos = id.lastIndexOf("/");
        return pos != -1 && pos < id.length() - 1 ? id.substring(pos + 1) : id;
    }

    public FactoryConnectionService createConnectionService() {
        return new SFConnectionService(this);
    }

    public SOQLExecutor createSOQLExecutor() {
        return new SOQLExecutor(this);
    }

    public SobjectAccessor createSobjectAccessor() {
        return new SobjectAccessor(this);
    }

    public HTTPResponse execute(HTTPRequest request) throws ClientException {
        if (this.httpClient == null) {
            throw new ClientException(1011, "Connection not opened.");
        }
        try {
            HTTPResponse response = new HTTPRequestExecutor(this.httpClient).execute(request);
            if (this.isInvalidTokenResponse(response.getData())) {
                Trace.logInfo((Object)((Object)this), (String)"Trying to get a new access token.");
                this.sendTokenRenewNotification("Access token has expired. Requesting a new one...", ConnectionState.RECONNECTING);
                this.requestAccessToken();
                response = new HTTPRequestExecutor(this.httpClient).execute(request);
                if (this.isInvalidTokenResponse(response.getData())) {
                    this.sendTokenRenewNotification("Access token renew failed.", ConnectionState.RECONNECTING);
                    this.suspend();
                } else {
                    this.sendTokenRenewNotification("New access token retrieved successfully.", ConnectionState.CONNECTED);
                }
            }
            return response;
        }
        catch (Exception exception) {
            throw new ClientException(1031, "Failed to execute http request. Cause: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean isInvalidTokenResponse(byte[] response) {
        ErrorResponse errResp;
        byte[] prResp = response;
        if (prResp.length > 1 && new String(prResp, 0, 1).charAt(0) == '[') {
            prResp = Arrays.copyOfRange(response, 1, response.length - 1);
        }
        try {
            errResp = (ErrorResponse)this.jsonSerializer.deserialize("ErrorResponse", prResp);
        }
        catch (Exception e) {
            Trace.logDebug((Object)((Object)this), (String)new String(response));
            Trace.logDebug((Object)((Object)this), (String)new String(prResp));
            return false;
        }
        if (errResp.getErrorCode() != null && errResp.getErrorCode().equals("INVALID_SESSION_ID")) {
            Trace.logError((Object)((Object)this), (String)"Access Token is invalid.");
            return true;
        }
        return false;
    }

    private void sendTokenRenewNotification(String message, ConnectionState state) {
        ConnectionStateChangeAdvisory e = new ConnectionStateChangeAdvisory();
        e.setConnectionName(this.getName());
        e.setMessage(message);
        e.setState(state);
        e.setEventKey("Token");
        e.setConnectionUrl(this.getUrl());
        this.getStateNotificationEventListener().onEvent(e);
    }
}

