/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.service;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.utils.Base64;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.service.SFMethodInvokerVersion;
import com.streamscape.sf.util.ErrorResponse;
import com.streamscape.sf.util.HTTPRestRequest;
import com.streamscape.sf.util.SFInvokeResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class SFMethodInvoker
extends AbstractService
implements StateNotificationEventListener,
ExceptionEventListener {
    private static final String CONNECTION_FACTORY = "connection.factory";
    private SFConnection sfConnection = null;
    private ClientFactory connectionFactory = null;
    private JSONSerializer jsonSerializer = null;
    private HTTPRestRequest.HTTPVerb httpVerb = null;
    private String uri = null;
    private HTTPRestRequest.ContentType contentType = null;
    private HTTPRestRequest.RequestType requestType = null;
    private String sematicType = null;
    private String httpRequestPayloadEncoding = "UTF-8";
    private final String eInvalidAccessToken = "Access Token is invalid.";

    public String invoke(HTTPRestRequest request) {
        try {
            if (request == null) {
                this.ctx.logError("HTTPRestRequest object is null");
                return "HTTPRestRequest object is null";
            }
            ConnectionState state = this.sfConnection.getState();
            if (state != ConnectionState.CONNECTED) {
                this.ctx.logError("Cannot send message to SalesForce. Connection state is " + state);
                return "Cannot send message to SalesForce. Connection state is " + state;
            }
            if (this.sfConnection.getHttpClient() == null) {
                this.ctx.logError("HTTPClient is not initialized");
                return "HTTPClient is not initialized";
            }
            this.applySettings(request);
            this.ctx.logInfo("Invoke Sematic Type: " + request.getSematicType());
            this.ctx.logDebug("Invoke: " + (Object)((Object)request.getHttpVerb()) + ", " + request.getURI() + ", " + (Object)((Object)request.getContentType()) + ", " + (Object)((Object)request.getRequestType()) + ", " + request.getSematicType());
            String response = this.sendRequest(request);
            if (this.isInvalidTokenResponse(response.getBytes())) {
                this.ctx.logInfo("Trying to get a new access token.");
                this.sendTokenRenewNotification("Access token has expired. Requesting a new one...", ConnectionState.RECONNECTING);
                this.sfConnection.requestAccessToken();
                response = this.sendRequest(request);
                if (this.isInvalidTokenResponse(response.getBytes())) {
                    this.sendTokenRenewNotification("Access token renew failed.", ConnectionState.RECONNECTING);
                    this.sfConnection.suspend();
                    response = "Access Token is invalid. Connection is suspended.";
                } else {
                    this.sendTokenRenewNotification("New access token retrieved successfully.", ConnectionState.CONNECTED);
                }
            }
            return response;
        }
        catch (SerializerException e) {
            this.ctx.logError("SerializerException in invoke(): " + e.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
            return "SerializerException in invoke(): " + e.getMessage();
        }
        catch (IOException e) {
            this.ctx.logError("IOException in invoke(): " + e.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
            return "IOException in invoke(): " + e.getMessage();
        }
        catch (ModuleException e) {
            this.ctx.logError("ModuleException in invoke(): " + e.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
            return "ModuleException in invoke(): " + e.getMessage();
        }
    }

    public SFInvokeResponse invokeBS(HTTPRestRequest request) {
        try {
            if (request == null) {
                this.ctx.logError("HTTPRestRequest object is null");
                return new SFInvokeResponse(-1, "HTTPRestRequest object is null");
            }
            ConnectionState state = this.sfConnection.getState();
            if (state != ConnectionState.CONNECTED) {
                this.ctx.logError("Cannot send message to SalesForce. Connection state is " + state);
                return new SFInvokeResponse(-1, "Cannot send message to SalesForce. Connection state is " + state);
            }
            if (this.sfConnection.getHttpClient() == null) {
                this.ctx.logError("HTTPClient is not initialized");
                return new SFInvokeResponse(-1, "HTTPClient is not initialized");
            }
            this.applySettings(request);
            this.ctx.logInfo("Invoke Sematic Type: " + request.getSematicType());
            this.ctx.logDebug("Invoke: " + (Object)((Object)request.getHttpVerb()) + ", " + request.getURI() + ", " + (Object)((Object)request.getContentType()) + ", " + (Object)((Object)request.getRequestType()) + ", " + request.getSematicType());
            SFInvokeResponse response = this.sendRequestBS(request);
            if (response.getMessage().equals("Access Token is invalid.")) {
                this.ctx.logInfo("Trying to get a new access token.");
                this.sendTokenRenewNotification("Access token has expired. Requesting a new one...", ConnectionState.RECONNECTING);
                this.sfConnection.requestAccessToken();
                response = this.sendRequestBS(request);
                if (response.getMessage().equals("Access Token is invalid.")) {
                    this.sendTokenRenewNotification("Access token renew failed.", ConnectionState.RECONNECTING);
                    this.sfConnection.suspend();
                    response.setMessage("Access Token is invalid. Connection is suspended.");
                } else {
                    this.sendTokenRenewNotification("New access token retrieved successfully.", ConnectionState.CONNECTED);
                }
            }
            return response;
        }
        catch (Exception e) {
            this.ctx.logError("Exception in invoke(): " + e.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)e, (boolean)true);
            return new SFInvokeResponse(-1, e.getMessage());
        }
    }

    public int getMinorBuild() {
        return SFMethodInvokerVersion.getBuild();
    }

    public int getMajorVersion() {
        return SFMethodInvokerVersion.getMajorVersion();
    }

    public int getMinorVersion() {
        return SFMethodInvokerVersion.getMinorVersion();
    }

    public String getVersion() {
        return SFMethodInvokerVersion.getVersionString();
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("SalesForce connection state changed: " + e.getState().toString());
        try {
            if (e.getState() == ConnectionState.CONNECTED) {
                this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
            } else {
                this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), e.getMessage());
            }
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
        }
    }

    private void sendTokenRenewNotification(String message, ConnectionState state) {
        try {
            ConnectionStateChangeAdvisory e = new ConnectionStateChangeAdvisory();
            e.setConnectionName(this.sfConnection.getName());
            e.setMessage(message);
            e.setState(state);
            e.setEventKey("Token");
            e.setConnectionUrl(this.sfConnection != null ? this.sfConnection.getUrl() : "");
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)false);
        }
    }

    public void onEvent(ClientException e) {
        this.ctx.logError(e.getMessage());
        try {
            this.ctx.raiseException((ExceptionEventDatagram)e);
        }
        catch (Exception exception) {
            this.ctx.logError("Failed to raise exception. Cause: " + exception.getMessage());
        }
    }

    public void start() throws ServiceFrameworkException {
        try {
            JSONSerializer.JsonSerializerBuilderImpl builder = JSONSerializer.builder();
            builder.setJsonNotation(JsonNotation.TYPE);
            this.jsonSerializer = builder.build();
            this.ctx.logInfo("SFMethodInvoker starting...");
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION_FACTORY);
            this.sfConnection = (SFConnection)this.connectionFactory.createConnection();
            this.sfConnection.setStateNotificationEventListener(this);
            this.sfConnection.setExceptionEventListener(this);
            this.sfConnection.setName("Sys$Default." + this.connectionFactory.getFactoryType() + "." + this.connectionFactory.getFactoryName());
            this.sfConnection.connect();
        }
        catch (Exception error) {
            this.ctx.logError("Exception during SFMethodInvoker service starting. " + error.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
        }
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.ctx.logInfo("SFMethodInvoker initialization...");
            try {
                this.httpVerb = HTTPRestRequest.HTTPVerb.valueOf(this.ctx.lookupStringProperty("HTTPVerb"));
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("HTTPVerb property is not specified");
            }
            catch (IllegalArgumentException e) {
                this.ctx.logError("HTTPVerb property is incorrect. Ignored.");
            }
            try {
                this.uri = this.ctx.lookupStringProperty("URI");
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("URI property is not specified");
            }
            try {
                this.contentType = HTTPRestRequest.ContentType.valueOf(this.ctx.lookupStringProperty("ContentType"));
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("ContentType property is not specified or incorrect");
            }
            catch (IllegalArgumentException e) {
                this.ctx.logError("ContentType property is incorrect. Ignored.");
            }
            try {
                this.requestType = HTTPRestRequest.RequestType.valueOf(this.ctx.lookupStringProperty("RequestType"));
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("RequestType property is not specified or incorrect");
            }
            catch (IllegalArgumentException e) {
                this.ctx.logError("RequestType property is incorrect. Ignored.");
            }
            try {
                this.sematicType = this.ctx.lookupStringProperty("SematicType");
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("SematicType property is not specified or incorrect");
            }
            try {
                this.httpRequestPayloadEncoding = this.ctx.lookupStringProperty("http.request.payload.encoding");
            }
            catch (ServiceConfigurationException e) {
                this.ctx.logInfo("HTTP request payload encoding is not specified. Using default: " + this.httpRequestPayloadEncoding);
            }
        }
        catch (Exception error) {
            this.ctx.logError("Unable to initialize SFMethodInvoker service. " + error.getMessage());
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new ServiceFrameworkException(6065, error.getMessage());
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.connectionFactory != null) {
            try {
                this.connectionFactory.destroyAll();
            }
            catch (Exception exception) {
                this.ctx.logError("Failed to destroy connection factory '" + this.connectionFactory.toString() + "'. Cauae: " + exception.getMessage());
            }
        }
    }

    private String sendRequest(HTTPRestRequest request) throws IOException, ModuleException, SerializerException {
        if (request.getRequestType() == HTTPRestRequest.RequestType.HTTPQuery) {
            String result = this.queryRequestType(request);
            this.ctx.logInfo("Result: " + result);
            return result;
        }
        if (request.getRequestType() == HTTPRestRequest.RequestType.HTTPContent) {
            String result = this.contentRequstType(request);
            this.ctx.logInfo("Result: " + result);
            return result;
        }
        return "Unknown request type: " + (Object)((Object)request.getRequestType());
    }

    private SFInvokeResponse sendRequestBS(HTTPRestRequest request) throws IOException, ModuleException, SerializerException {
        if (request.getRequestType() == HTTPRestRequest.RequestType.HTTPQuery) {
            String result = this.queryRequestType(request);
            this.ctx.logInfo("Result: " + result);
            return this.parseSFInvokeResponse(result.getBytes());
        }
        if (request.getRequestType() == HTTPRestRequest.RequestType.HTTPContent) {
            String result = this.contentRequstType(request);
            this.ctx.logInfo("Result: " + result);
            return this.parseSFInvokeResponse(result.getBytes());
        }
        return new SFInvokeResponse(-1, "Unknown request type: " + (Object)((Object)request.getRequestType()));
    }

    private String queryRequestType(HTTPRestRequest request) throws IOException, ModuleException {
        if (request.getContentType() == HTTPRestRequest.ContentType.String) {
            if (request.getSematicType().equals("string")) {
                this.ctx.logDebug("Request content: " + request.getRequestContent().toString());
                return this.queryHttpCall(request, request.getURI() + "?" + request.getRequestContent());
            }
            if (request.getSematicType().equals("map")) {
                String query = "";
                this.ctx.logDebug("Request content: " + request.getRequestContent().toString());
                Map map = (Map)request.getRequestContent();
                for (String key : map.keySet()) {
                    query = query + key + "=" + map.get(key).toString() + "&";
                }
                return this.queryHttpCall(request, request.getURI() + "?" + String.valueOf(query.toCharArray(), 0, query.length() - 1));
            }
            if (request.getSematicType().equals("byte_array")) {
                String encodedContent = request.getRequestContent().toString();
                this.ctx.logDebug("Encoded content: " + encodedContent);
                byte[] result = Base64.decode((String)encodedContent);
                String decodedContent = new String(result);
                this.ctx.logDebug("Decoded content: " + decodedContent);
                return this.queryHttpCall(request, request.getURI() + "?" + decodedContent);
            }
            return "Only string, map and byte_array semantic types are allowed by HTTPQuery request type. Semantic type: " + request.getSematicType();
        }
        return "Only String content type is allowed by HTTPQuery request type. Content type: " + (Object)((Object)request.getContentType());
    }

    private String contentRequstType(HTTPRestRequest request) throws IOException, ModuleException, SerializerException {
        Object requestContent = request.getRequestContent();
        if (request.getSematicType().equals("byte_array")) {
            String encodedContent = request.getRequestContent().toString();
            requestContent = Base64.decode((String)encodedContent);
            this.ctx.logDebug("Encoded content: " + encodedContent);
            this.ctx.logDebug("Decoded content: " + new String((byte[])requestContent));
        }
        if (request.getContentType() == HTTPRestRequest.ContentType.JSON) {
            requestContent = this.jsonSerializer.serialize(request.getSematicType(), requestContent).getBytes(this.httpRequestPayloadEncoding);
        } else if (request.getContentType() == HTTPRestRequest.ContentType.XML) {
            if (!(requestContent instanceof String)) {
                XSerializerFactory xmlSerializerFactory = this.context.getXSerializerFactory();
                XSerializer xmlSerializer = xmlSerializerFactory.getDefaultSerializer();
                requestContent = xmlSerializer.serialize(request.getSematicType(), requestContent);
            }
            requestContent = ((String)requestContent).getBytes(this.httpRequestPayloadEncoding);
        } else if (request.getContentType() == HTTPRestRequest.ContentType.String) {
            requestContent = requestContent.toString().getBytes();
        } else {
            return "Unknown content type: " + (Object)((Object)request.getContentType());
        }
        return this.contentHttpCall(request, (byte[])requestContent, this.getAdditionalHeaders(request.getContentType()));
    }

    private String queryHttpCall(HTTPRestRequest request, String file) throws IOException, ModuleException {
        HTTPClientResponse resp = null;
        this.ctx.logDebug("file: " + file);
        if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.GET) {
            resp = this.sfConnection.getHttpClient().Get(file);
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.POST) {
            resp = this.sfConnection.getHttpClient().Post(file);
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.PUT) {
            resp = this.sfConnection.getHttpClient().Put(file, "");
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.PATCH) {
            resp = this.sfConnection.getHttpClient().Patch(file, "");
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.DELETE) {
            resp = this.sfConnection.getHttpClient().Delete(file);
        } else {
            return "Unknown http verb: " + (Object)((Object)request.getHttpVerb());
        }
        return new String(resp.getData());
    }

    private String contentHttpCall(HTTPRestRequest request, byte[] data, NVPair[] additionalHeaders) throws IOException, ModuleException {
        String file = request.getURI();
        HTTPClientResponse resp = null;
        this.ctx.logDebug("file: " + file);
        this.ctx.logDebug("data: " + new String(data, this.httpRequestPayloadEncoding));
        if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.GET) {
            this.ctx.logDebug("Skip content for HTTP Get");
            resp = this.sfConnection.getHttpClient().Get(file, "", additionalHeaders);
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.POST) {
            resp = this.sfConnection.getHttpClient().Post(file, data, additionalHeaders);
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.PUT) {
            resp = this.sfConnection.getHttpClient().Put(file, data, additionalHeaders);
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.PATCH) {
            resp = this.sfConnection.getHttpClient().Patch(file, data, additionalHeaders);
        } else if (request.getHttpVerb() == HTTPRestRequest.HTTPVerb.DELETE) {
            this.ctx.logDebug("Skip content for HTTP Delete");
            resp = this.sfConnection.getHttpClient().Delete(file, additionalHeaders);
        } else {
            return "Unknown http verb: " + (Object)((Object)request.getHttpVerb());
        }
        return new String(resp.getData());
    }

    private NVPair[] getAdditionalHeaders(HTTPRestRequest.ContentType contentType) {
        if (contentType == HTTPRestRequest.ContentType.JSON) {
            NVPair[] additionalHeaders = new NVPair[]{new NVPair("Content-Type", "application/json")};
            return additionalHeaders;
        }
        if (contentType == HTTPRestRequest.ContentType.XML) {
            NVPair[] additionalHeaders = new NVPair[]{new NVPair("Content-Type", "application/xml")};
            return additionalHeaders;
        }
        NVPair[] additionalHeaders = new NVPair[]{};
        return additionalHeaders;
    }

    private void applySettings(HTTPRestRequest request) {
        if (this.httpVerb != null) {
            request.setHttpVerb(this.httpVerb);
        }
        if (this.uri != null && !this.uri.isEmpty()) {
            request.setURI(this.uri);
        }
        if (this.contentType != null) {
            request.setContentType(this.contentType);
        }
        if (this.requestType != null) {
            request.setRequestType(this.requestType);
        }
        if (this.sematicType != null && !this.sematicType.isEmpty()) {
            request.setSematicType(this.sematicType);
        }
    }

    private SFInvokeResponse parseSFInvokeResponse(byte[] response) {
        try {
            return (SFInvokeResponse)this.jsonSerializer.deserialize("SFInvokeResponse", response);
        }
        catch (SerializerException e) {
            this.ctx.logDebug("Cannot deserialize response to SFInvokeResponse. Check for invalid token.");
            try {
                if (this.isInvalidTokenResponse(response)) {
                    return new SFInvokeResponse(-1, "Access Token is invalid.");
                }
                return new SFInvokeResponse(-1, new String(response));
            }
            catch (Exception e2) {
                this.ctx.logError("Cannot deserialize response: " + new String(response));
                this.ctx.logDebug("Exception message: " + e2.getMessage());
                return new SFInvokeResponse(-1, "Cannot deserialize response: " + new String(response));
            }
        }
    }

    private boolean isInvalidTokenResponse(byte[] response) {
        ErrorResponse errResp;
        byte[] prResp = Arrays.copyOfRange(response, 1, response.length - 1);
        try {
            errResp = (ErrorResponse)this.jsonSerializer.deserialize("ErrorResponse", prResp);
        }
        catch (Exception e) {
            this.ctx.logDebug(new String(response));
            this.ctx.logDebug(new String(prResp));
            this.ctx.logError("isInvalidTokenResponse serialization failed");
            return false;
        }
        if (errResp.getErrorCode() != null && errResp.getErrorCode().equals("INVALID_SESSION_ID")) {
            this.ctx.logError("Access Token is invalid.");
            return true;
        }
        return false;
    }
}

