/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.connection.service;

import com.streamscape.sef.factory.connection.external.AbstractExternalParser;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalParserContext;
import com.streamscape.sf.connection.service.SFCrudExecutionStatement;
import com.streamscape.sf.connection.service.SFSOQLExecutionStatement;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.parser.ParserException;
import com.streamscape.tools.parser.ParserExceptionBuilder;

public class SFExternalParser
extends AbstractExternalParser {
    public ExecutionStatement onParse() throws ParserException {
        SFSOQLExecutionStatement statement;
        try {
            this.lexer.readToken();
            if (this.lexer.isCurrentToken("sf")) {
                statement = this.parseSfCrudOperations(this.externalParserContext);
                this.lexer.readToken((TokenType)CommonTokenType.CLOSE_BRACKET);
            } else {
                statement = new SFSOQLExecutionStatement();
                this.parsePartsCompoundQuery(statement);
            }
        }
        catch (LexerException exception) {
            throw ParserExceptionBuilder.parserException((Lexer)this.lexer, (String)exception.getMessage());
        }
        this.externalParserContext.setPosition(this.lexer.getCurrentTokenPosition());
        return statement;
    }

    protected boolean supportsStatementParameters() {
        return false;
    }

    private ExecutionStatement parseSfCrudOperations(ExternalParserContext<?> externalParserContext) throws LexerException, ParserException {
        this.lexer.readToken((TokenType)CommonTokenType.DOT);
        this.lexer.readToken((TokenType)CommonTokenType.LITERAL);
        String collectionName = this.lexer.getCurrentToken().getValue();
        this.lexer.readToken((TokenType)CommonTokenType.DOT);
        this.lexer.readToken((TokenType)CommonTokenType.LITERAL);
        String operationName = this.lexer.getCurrentToken().getValue();
        this.lexer.readToken((TokenType)CommonTokenType.OPEN_BRACKET);
        this.lexer.readToken();
        SFCrudExecutionStatement statement = new SFCrudExecutionStatement(collectionName, operationName);
        if (operationName.equalsIgnoreCase("insert")) {
            statement.addParam(this.readExternalStatement());
        } else if (operationName.equalsIgnoreCase("update") || operationName.equalsIgnoreCase("upsert")) {
            statement.addParam(this.readExternalStatement());
            this.lexer.readToken((TokenType)CommonTokenType.COMMA);
            statement.addParam(this.readExternalStatement());
        } else if (operationName.equalsIgnoreCase("upsert")) {
            statement.addParam(this.readExternalStatement());
            this.lexer.readToken((TokenType)CommonTokenType.COMMA);
            statement.addParam(this.readExternalStatement());
            this.lexer.readToken((TokenType)CommonTokenType.COMMA);
            statement.addParam(this.readExternalStatement());
        } else if (operationName.equalsIgnoreCase("delete")) {
            statement.addParam(this.readExternalStatement());
        } else {
            throw ParserExceptionBuilder.parserException((Lexer)this.lexer, (String)("Invalid CRUD sf operation '" + operationName + "'."));
        }
        this.lexer.readToken((TokenType)CommonTokenType.CLOSE_BRACKET);
        return statement;
    }
}

