/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.service;

import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.http.ProtocolNotSuppException;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ClientFactoryConfigurationException;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.sf.connection.SFConnection;
import com.streamscape.sf.util.ErrorResponse;
import com.streamscape.sf.util.QueryResult;
import com.streamscape.sf.util.SFInvokeResponse;
import com.streamscape.sf.util.SFMapObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;

public class SFSobjectAccessorUtils
implements StateNotificationEventListener {
    private static final String CONNECTION_FACTORY = "connection.factory";
    private ServiceContext ctx = null;
    private SFConnection sfConnection = null;
    private JSONSerializer jsonSerializer = null;
    private HTTPClient httpClient = null;
    private HashMap<String, String> externalIdFields = new HashMap();
    private String[] sharedExclusionList = new String[]{"LastModifiedDate", "LastActivityDate", "SystemModstamp", "LastModifiedById", "MasterRecordId", "CreatedById", "CreatedDate", "IsDeleted", "JigsawCompanyId"};
    private HashMap<String, Vector<String>> exclusionListSCO = new HashMap();
    private HashMap<String, Vector<String>> exclusionListCL = new HashMap();
    private String sfObjectName = null;

    public SFSobjectAccessorUtils(ServiceContext ctx, RuntimeContext context, HashMap<String, Vector<String>> exclusionListCL, String sfObjectName) throws MalformedURLException, ProtocolNotSuppException, ServiceConfigurationException, ClientFactoryConfigurationException, ClientException {
        this.ctx = ctx;
        this.sfObjectName = sfObjectName;
        ClientFactory connFactory = ctx.lookupClientFactoryProperty(CONNECTION_FACTORY);
        this.sfConnection = (SFConnection)connFactory.createConnection();
        this.sfConnection.setStateNotificationEventListener(this);
        this.sfConnection.connect();
        JSONSerializer.JsonSerializerBuilderImpl builder = JSONSerializer.builder();
        builder.setJsonNotation(JsonNotation.TYPE);
        this.jsonSerializer = builder.build();
        this.httpClient = this.initializeHTTPClient(this.sfConnection.getInstanceURL(), this.sfConnection.getAccessToken());
        String externalIds = ctx.lookupStringProperty("externalIdField");
        ctx.logDebug("External IDs property: " + externalIds);
        this.externalIdFields = this.fillExternalIdFields(externalIds);
        ctx.logDebug("External IDs: " + this.externalIdFields);
        String exclusionListStr = ctx.lookupStringProperty("exclusionList");
        ctx.logDebug("Exclusion List property: " + exclusionListStr);
        this.exclusionListSCO = this.fillExclusionListSCO(exclusionListStr);
        ctx.logDebug("Exclusion List: " + this.exclusionListSCO);
        this.exclusionListCL = exclusionListCL;
    }

    public <T> SFInvokeResponse create(Object obj, String sfObjName) throws IOException, ModuleException, SerializerException, IllegalArgumentException, IllegalAccessException {
        SFMapObject mapObject = new SFMapObject(obj);
        return this.create(mapObject, sfObjName);
    }

    public SFInvokeResponse create(SFMapObject mapObject, String sfObjName) throws SerializerException, IOException, ModuleException {
        this.ctx.logDebug("Icomming object: " + mapObject);
        mapObject.getMap().remove("Id");
        mapObject.setMap(this.applyExclusionList(mapObject.getMap(), "sf" + sfObjName));
        byte[] serialized = this.jsonSerializer.serialize("SFMapObject", (Object)mapObject).getBytes();
        byte[] sfCompatible = this.makeSFcompatibleJSONobj("SFMapObject", "map", serialized);
        NVPair[] contTypeHeader = new NVPair[]{new NVPair("Content-Type", "application/json")};
        String uri = this.sfConnection.getRecourseDirectory() + "sobjects/" + sfObjName + "/";
        this.ctx.logDebug("create URL: " + this.httpClient.getHost() + uri);
        this.ctx.logDebug(new String(sfCompatible));
        HTTPClientResponse resp = this.httpClient.Post(uri, sfCompatible, contTypeHeader);
        this.ctx.logInfo("create response (" + String.valueOf(resp.getStatusCode()) + "): " + new String(resp.getData()));
        this.checkResponseForInvalidToken(resp.getData());
        return new SFInvokeResponse(resp.getStatusCode(), new String(resp.getData()));
    }

    public <T> SFInvokeResponse update(Object obj, String sfObjName) throws Exception {
        SFMapObject mapObject = new SFMapObject(obj);
        return this.update(mapObject, sfObjName);
    }

    public SFInvokeResponse update(SFMapObject mapObject, String sfObjName) throws Exception {
        this.ctx.logDebug("Icomming object: " + mapObject);
        String id = mapObject.getMap().get("Id");
        if (id == null || id.isEmpty()) {
            return new SFInvokeResponse("Id is not specified. Cannot update " + sfObjName + " without Id");
        }
        mapObject.getMap().remove("Id");
        mapObject.setMap(this.applyExclusionList(mapObject.getMap(), "sf" + sfObjName));
        byte[] serialized = this.jsonSerializer.serialize("SFMapObject", (Object)mapObject).getBytes();
        byte[] sfCompatible = this.makeSFcompatibleJSONobj("SFMapObject", "map", serialized);
        NVPair[] contTypeHeader = new NVPair[]{new NVPair("Content-Type", "application/json")};
        String uri = this.sfConnection.getRecourseDirectory() + "sobjects/" + sfObjName + "/" + id;
        this.ctx.logDebug("updateAccount URL: " + this.httpClient.getHost() + uri);
        this.ctx.logDebug(new String(sfCompatible));
        HTTPClientResponse resp = this.httpClient.Patch(uri, sfCompatible, contTypeHeader);
        this.ctx.logInfo("update response (" + String.valueOf(resp.getStatusCode()) + "): " + new String(resp.getData()));
        this.checkResponseForInvalidToken(resp.getData());
        return new SFInvokeResponse(resp.getStatusCode(), new String(resp.getData()));
    }

    public <T> SFInvokeResponse upsert(Object obj, String sfObjName) throws IllegalArgumentException, IllegalAccessException, SerializerException, IOException, ModuleException {
        SFMapObject mapObject = new SFMapObject(obj);
        return this.upsert(mapObject, sfObjName);
    }

    public SFInvokeResponse upsert(SFMapObject mapObject, String sfObjName) throws SerializerException, IOException, ModuleException {
        this.ctx.logDebug("Icomming object: " + mapObject);
        String externalIdField = this.externalIdFields.get("sf" + sfObjName);
        if (externalIdField == null || externalIdField.isEmpty()) {
            this.ctx.logError("External Id field is not specified in sco");
            return new SFInvokeResponse("External Id field is not specified in sco");
        }
        String externalIdValue = mapObject.getMap().get(externalIdField);
        if (externalIdValue == null || externalIdValue.isEmpty()) {
            this.ctx.logError("External Id field " + externalIdField + " is empty or is not presented in " + sfObjName);
            return new SFInvokeResponse("External Id field " + externalIdField + " is empty or is not presented in " + sfObjName);
        }
        mapObject.getMap().remove("Id");
        mapObject.setMap(this.applyExclusionList(mapObject.getMap(), "sf" + sfObjName));
        mapObject.setMap(this.removeExternalIdField(mapObject.getMap(), externalIdField));
        byte[] serialized = this.jsonSerializer.serialize("SFMapObject", (Object)mapObject).getBytes();
        byte[] sfCompatible = this.makeSFcompatibleJSONobj("SFMapObject", "map", serialized);
        NVPair[] contTypeHeader = new NVPair[]{new NVPair("Content-Type", "application/json")};
        String uri = this.sfConnection.getRecourseDirectory() + "sobjects/" + sfObjName + "/" + externalIdField + "/" + externalIdValue;
        this.ctx.logDebug("upsert URL: " + this.httpClient.getHost() + uri);
        this.ctx.logDebug(new String(sfCompatible));
        HTTPClientResponse resp = this.httpClient.Patch(uri, sfCompatible, contTypeHeader);
        this.ctx.logInfo("upsert response (" + String.valueOf(resp.getStatusCode()) + "): " + new String(resp.getData()));
        this.checkResponseForInvalidToken(resp.getData());
        String response = resp.getData().length == 0 ? "{\"" + externalIdField + "\":\"" + externalIdValue + "\",\"success\":true}" : new String(resp.getData());
        return new SFInvokeResponse(resp.getStatusCode(), response);
    }

    public <T> SFInvokeResponse delete(Object obj, String sfObjName) throws Exception {
        SFMapObject mapObject = new SFMapObject(obj);
        return this.delete(mapObject, sfObjName);
    }

    public SFInvokeResponse delete(String sfObjName, String id) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Id", id);
        return this.delete(new SFMapObject(map), sfObjName);
    }

    public SFInvokeResponse delete(SFMapObject mapObject, String sfObjName) throws Exception {
        this.ctx.logDebug("Icomming object: " + mapObject);
        String id = mapObject.getMap().get("Id");
        if (id == null || id.isEmpty()) {
            return new SFInvokeResponse("Id is not specified. Cannot delete " + sfObjName + " without Id");
        }
        mapObject.getMap().remove("Id");
        NVPair[] contTypeHeader = new NVPair[]{new NVPair("Content-Type", "application/json")};
        String uri = this.sfConnection.getRecourseDirectory() + "sobjects/" + sfObjName + "/" + id;
        this.ctx.logDebug("delete URL: " + this.httpClient.getHost() + uri);
        HTTPClientResponse resp = this.httpClient.Delete(uri, contTypeHeader);
        this.ctx.logInfo("delete response (" + String.valueOf(resp.getStatusCode()) + "): " + new String(resp.getData()));
        this.checkResponseForInvalidToken(resp.getData());
        return new SFInvokeResponse(resp.getStatusCode(), new String(resp.getData()));
    }

    public <T> T lookup(String sfObjName, String id) throws SerializerException, IOException, ModuleException {
        String uri = this.sfConnection.getRecourseDirectory() + "sobjects/" + sfObjName + "/" + id;
        this.ctx.logDebug("getInfo URL: " + this.httpClient.getHost() + uri);
        HTTPClientResponse resp = this.httpClient.Get(uri);
        this.ctx.logDebug("getInfo response: " + new String(resp.getData()));
        this.checkResponseForInvalidToken(resp.getData());
        Object t = this.jsonSerializer.deserialize("sf" + sfObjName, resp.getData());
        return (T)t;
    }

    public Vector<String> query(String sfObjName, String selectField, String field, String value) throws SerializerException, IOException, ModuleException {
        HashMap<String, String> conditionValues = new HashMap<String, String>();
        conditionValues.put(field, value);
        String[] selectFields = new String[]{selectField};
        ArrayList<HashMap<String, String>> resultQuery = this.query(sfObjName, selectFields, conditionValues, null);
        Vector<String> result = new Vector<String>();
        for (HashMap<String, String> map : resultQuery) {
            result.add(map.get(selectField));
        }
        return result;
    }

    public ArrayList<HashMap<String, String>> query(String sfObjName, String[] selectFields, HashMap<String, String> conditionValues, Operation op) throws IOException, ModuleException, SerializerException {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        String selectStr = "";
        for (String str : selectFields) {
            if (!selectStr.isEmpty()) {
                selectStr = selectStr + ", ";
            }
            selectStr = selectStr + str;
        }
        String whereStr = "";
        for (String key : conditionValues.keySet()) {
            if (conditionValues.get(key) == null) continue;
            if (!whereStr.isEmpty()) {
                whereStr = whereStr + " " + op.name() + " ";
            }
            whereStr = whereStr + key + " = '" + conditionValues.get(key) + "'";
        }
        String request = "SELECT " + selectStr + " FROM " + sfObjName + " WHERE " + whereStr;
        this.ctx.logDebug("query request: " + request);
        NVPair[] formData = new NVPair[]{new NVPair("q", request)};
        String uri = this.sfConnection.getRecourseDirectory() + "query/";
        this.ctx.logDebug("query URI: " + uri);
        HTTPClientResponse resp = this.httpClient.Get(uri, formData);
        this.ctx.logDebug("query response: " + new String(resp.getData()));
        this.checkResponseForInvalidToken(resp.getData());
        QueryResult queryResult = (QueryResult)this.jsonSerializer.deserialize("QueryResult", resp.getData());
        ArrayList<HashMap<String, Object>> array = queryResult.getRecords();
        for (HashMap<String, Object> map : array) {
            HashMap<String, String> resMap = new HashMap<String, String>();
            for (String field : selectFields) {
                resMap.put(field, map.get(field).toString());
            }
            result.add(resMap);
        }
        return result;
    }

    public SFConnection getSfConnection() {
        return this.sfConnection;
    }

    public void setSfConnection(SFConnection sfConnection) {
        this.sfConnection = sfConnection;
    }

    public JSONSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public void setJsonSerializer(JSONSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public HTTPClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HTTPClient httpClient) {
        this.httpClient = httpClient;
    }

    public HTTPClient initializeHTTPClient(String instanceUrl, String accessToken) throws MalformedURLException, ProtocolNotSuppException {
        Class[] modules;
        this.ctx.logDebug("initialize HTTPClient: " + instanceUrl);
        URL url = new URL(instanceUrl);
        HTTPClient httpClient = new HTTPClient(url);
        NVPair[] headers = new NVPair[]{new NVPair("Authorization", "Bearer " + accessToken)};
        httpClient.setDefaultHeaders(headers);
        for (Class module : modules = httpClient.getModules()) {
            httpClient.removeModule(module);
        }
        return httpClient;
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("SalesForce connection state changed: " + e.getState().toString());
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch exception: " + ex.getMessage());
        }
    }

    private HashMap<String, Vector<String>> fillExclusionListSCO(String exclusionListStr) {
        String[] propArr;
        HashMap<String, Vector<String>> exclusionListSCO = new HashMap<String, Vector<String>>();
        if (exclusionListStr == null || exclusionListStr.isEmpty()) {
            return exclusionListSCO;
        }
        Pattern pSColon = Pattern.compile(";");
        Pattern pColon = Pattern.compile(":");
        for (String str : propArr = pSColon.split(exclusionListStr)) {
            if (str == null || str.isEmpty() || str.equals(":")) {
                this.ctx.logDebug("Exclusion List record is empty. Skipped.");
                continue;
            }
            String[] valuesArr = pColon.split(str);
            if (valuesArr.length == 0 || valuesArr[0] == null || valuesArr[0].isEmpty()) {
                this.ctx.logError("Exclusion List error: " + str + ": Type Name can not be blank. Skipped.");
                continue;
            }
            String typeName = null;
            String fieldName = null;
            if (valuesArr.length == 1) {
                typeName = "sf" + this.sfObjectName;
                fieldName = valuesArr[0].trim();
            } else {
                if (valuesArr.length < 2 || valuesArr[1] == null || valuesArr[1].isEmpty()) {
                    this.ctx.logError("ExclusionList error: " + str + ": FieldName can not be blank. Skipped.");
                    continue;
                }
                typeName = valuesArr[0].trim();
                fieldName = valuesArr[1].trim();
            }
            Vector<String> fields = exclusionListSCO.get(typeName);
            if (fields == null) {
                fields = new Vector();
                exclusionListSCO.put(typeName, fields);
            }
            fields.add(fieldName);
        }
        this.ctx.logDebug("Exclusion List Result:" + exclusionListSCO);
        return exclusionListSCO;
    }

    private HashMap<String, String> fillExternalIdFields(String externalIdStr) {
        String[] propArr;
        HashMap<String, String> externalIdFields = new HashMap<String, String>();
        if (externalIdStr == null || externalIdStr.isEmpty()) {
            return externalIdFields;
        }
        Pattern pSColon = Pattern.compile(";");
        Pattern pColon = Pattern.compile(":");
        for (String str : propArr = pSColon.split(externalIdStr)) {
            if (str == null || str.isEmpty() || str.equals(":")) {
                this.ctx.logDebug("External Id record is empty. Skipped.");
                continue;
            }
            String[] valuesArr = pColon.split(str);
            if (valuesArr.length == 0 || valuesArr[0] == null || valuesArr[0].isEmpty()) {
                this.ctx.logError("External ID error: " + str + ": Type Name can not be blank. Skipped.");
                continue;
            }
            if (valuesArr.length == 1) {
                String fieldName = valuesArr[0].trim();
                externalIdFields.put("sf" + this.sfObjectName, fieldName);
                continue;
            }
            String className = valuesArr[0].trim();
            if (valuesArr.length < 2 || valuesArr[1] == null || valuesArr[1].isEmpty()) {
                this.ctx.logError("External ID error: " + str + ": Field Name can not be blank. Skipped.");
                continue;
            }
            String fieldName = valuesArr[1].trim();
            externalIdFields.put(className, fieldName);
        }
        this.ctx.logDebug("External ID Result:" + externalIdFields);
        return externalIdFields;
    }

    private byte[] makeSFcompatibleJSONobj(String objName, String fieldName, byte[] input) {
        return Arrays.copyOfRange(input, objName.length() + fieldName.length() + 8, input.length - 2);
    }

    private HashMap<String, String> applyExclusionList(HashMap<String, String> hashMap, String simpleClassName) {
        Vector<String> fieldsCU;
        if (hashMap.get("OwnerId") == null || hashMap.get("OwnerId").isEmpty()) {
            hashMap.remove("OwnerId");
        }
        for (String entry : this.sharedExclusionList) {
            hashMap.remove(entry);
        }
        if (this.exclusionListCL != null && (fieldsCU = this.exclusionListCL.get(simpleClassName)) != null) {
            for (String entry : fieldsCU) {
                hashMap.remove(entry);
            }
        }
        this.ctx.logDebug("Apply exclusionListSCO for " + simpleClassName + "...");
        Vector<String> fieldsSCO = this.exclusionListSCO.get(simpleClassName);
        if (fieldsSCO != null) {
            for (String field : fieldsSCO) {
                this.ctx.logDebug("Remove" + field);
                hashMap.remove(field);
            }
        }
        this.ctx.logDebug("Result: " + hashMap);
        return hashMap;
    }

    private HashMap<String, String> removeExternalIdField(HashMap<String, String> hashMap, String externalIdField) {
        hashMap.remove(externalIdField);
        return hashMap;
    }

    private String getSobjectId(String sfObjName, HashMap<String, String> map) throws Exception {
        String[] selectFields = new String[]{"Id"};
        HashMap<String, String> conditionValues = map;
        ArrayList<HashMap<String, String>> result = this.query(sfObjName, selectFields, conditionValues, Operation.AND);
        if (result.size() == 0) {
            throw new Exception("Sobject " + sfObjName + " does not exist(" + map + ")");
        }
        if (result.size() > 1) {
            throw new Exception("Search for " + sfObjName + " is ambiguous(" + map + ")");
        }
        return result.get(0).get("Id");
    }

    private void checkResponseForInvalidToken(byte[] response) {
        try {
            byte[] prResp = Arrays.copyOfRange(response, 1, response.length - 1);
            ErrorResponse errResp = (ErrorResponse)this.jsonSerializer.deserialize("ErrorResponse", prResp);
            if (errResp.getErrorCode() != null && errResp.getErrorCode().equals("INVALID_SESSION_ID")) {
                this.ctx.logError("Access Token is invalid. Connection is suspended");
                this.sfConnection.suspend();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Operation {
        AND,
        OR;

    }
}

