/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sf.service;

import com.streamscape.Trace;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.sf.service.SFSobjectAccessorUtils;
import com.streamscape.sf.service.SFSobjectAccessorVersion;
import com.streamscape.sf.util.SFInvokeResponse;

public class SFSobjectAccessor
extends AbstractService {
    private SFSobjectAccessorUtils accUtl = null;
    private String objectName = "";

    public SFInvokeResponse create(Object sObj) {
        try {
            this.ctx.logInfo("create sObject: " + this.objectName);
            return this.accUtl.create(sObj, this.objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ctx.logError("create sObject: " + this.objectName + " - FAILED");
            this.ctx.logError(e.getMessage());
            return new SFInvokeResponse(e.getMessage());
        }
    }

    public SFInvokeResponse update(Object sObj) {
        try {
            this.ctx.logInfo("update sObject: " + this.objectName);
            return this.accUtl.update(sObj, this.objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ctx.logError("update sObject: " + this.objectName + " - FAILED");
            this.ctx.logError(e.getMessage());
            return new SFInvokeResponse(e.getMessage());
        }
    }

    public SFInvokeResponse upsert(Object sObj) {
        try {
            this.ctx.logInfo("upsert sObject: " + this.objectName);
            return this.accUtl.upsert(sObj, this.objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ctx.logError("upsert sObject: " + this.objectName + " - FAILED");
            this.ctx.logError(e.getMessage());
            return new SFInvokeResponse(e.getMessage());
        }
    }

    public SFInvokeResponse delete(Object sObj) {
        try {
            this.ctx.logInfo("delete sObject: " + this.objectName);
            return this.accUtl.delete(sObj, this.objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ctx.logError("delete sObject: " + this.objectName + " - FAILED");
            this.ctx.logError(e.getMessage());
            return new SFInvokeResponse(e.getMessage());
        }
    }

    public int getMajorVersion() {
        return SFSobjectAccessorVersion.getMajorVersion();
    }

    public int getMinorVersion() {
        return SFSobjectAccessorVersion.getMinorVersion();
    }

    public int getMinorBuild() {
        return SFSobjectAccessorVersion.getBuild();
    }

    public String getVersion() {
        return SFSobjectAccessorVersion.getVersionString();
    }

    protected void doInit() throws ServiceFrameworkException {
        this.ctx.logInfo("SFSobjectAccessor initialization...");
        try {
            this.objectName = this.ctx.lookupStringProperty("objectName");
            this.ctx.logDebug("Object name is " + this.objectName);
            this.accUtl = new SFSobjectAccessorUtils(this.ctx, this.context, null, this.objectName);
        }
        catch (ServiceConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            Trace.logException((Object)((Object)this), (Throwable)ex, (boolean)true);
            throw new RuntimeException(ex);
        }
    }
}

