/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.pershing.service.pnbr;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.pershing.connection.PershingConnection;
import com.streamscape.pershing.service.pnbr.Version;
import com.streamscape.pershing.service.pnbr.generated.InvokationException;
import com.streamscape.pershing.service.pnbr.generated.Pnbr;
import com.streamscape.pershing.service.pnbr.generated.PnbrDocPort;
import com.streamscape.pershing.service.pnbr.generated.types.AccountBalanceOutput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountBookkeepingOutput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountInfoBKInput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountInfoBalInput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountInfoMLInput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountInfoPosInput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountInfoTrdInput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountPositionOutput;
import com.streamscape.pershing.service.pnbr.generated.types.AccountTradeOutput;
import com.streamscape.pershing.service.pnbr.generated.types.DetailInput;
import com.streamscape.pershing.service.pnbr.generated.types.DetailOutput;
import com.streamscape.pershing.service.pnbr.generated.types.FundAvailInquiryInput;
import com.streamscape.pershing.service.pnbr.generated.types.FundAvailInquiryOutput;
import com.streamscape.pershing.service.pnbr.generated.types.MoneylineOutput;
import com.streamscape.pershing.service.pnbr.generated.types.RTMInput;
import com.streamscape.pershing.service.pnbr.generated.types.RTMOutput;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.SoapFaultException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNBRService
extends AbstractService
implements ExceptionEventListener,
StateNotificationEventListener {
    public static final String CONNECTION_FACTORY = "client.factory";
    public static final String SERVICE_URI = "pershing.service.uri";
    String serviceUri = null;
    PnbrDocPort port = null;
    ClientConnection pershingConnection = null;
    String implementationVersion = "1";

    public AccountBalanceOutput accountBalance(AccountInfoBalInput input) throws Exception {
        try {
            AccountBalanceOutput output = this.port.accountBalance(this.implementationVersion, input);
            return output;
        }
        catch (InvokationException exception) {
            throw this.handleSoapFault(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public AccountBookkeepingOutput accountBookkeeping(AccountInfoBKInput input) throws Exception {
        try {
            return this.port.accountBookkeeping(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public AccountPositionOutput accountPosition(AccountInfoPosInput input) throws Exception {
        try {
            return this.port.accountPosition(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public AccountTradeOutput accountTrade(AccountInfoTrdInput input) throws Exception {
        try {
            return this.port.accountTrade(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public DetailOutput balanceDetail(DetailInput input) throws Exception {
        try {
            return this.port.balanceDetail(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public FundAvailInquiryOutput fundAvailableInquiry(FundAvailInquiryInput input) throws Exception {
        try {
            return this.port.fundAvailableInquiry(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public MoneylineOutput prevDayBalance(AccountInfoMLInput input) throws Exception {
        try {
            return this.port.prevDayBalance(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public RTMOutput rtmService(RTMInput input) throws Exception {
        try {
            return this.port.rtmService(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public int getBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.serviceUri = this.ctx.lookupStringProperty(SERVICE_URI);
            ClientFactory factory = this.ctx.lookupClientFactoryProperty(CONNECTION_FACTORY);
            PershingConnection connection = (PershingConnection)factory.createConnection();
            connection.setExceptionEventListener(this);
            connection.connect();
            connection.setStateNotificationEventListener(this);
            connection.setExceptionEventListener(this);
            if (this.ctx.getLogger() != null) {
                connection.setServiceLogger(this.ctx.getLogger());
            }
            Pnbr pnbr = connection.getPnbr();
            this.port = pnbr.getPnbrSoapDocPort();
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", connection.getUrl() + this.serviceUri);
            this.ctx.logInfo("Connection to Pershing PNBR service inititalized.");
        }
        catch (Exception error) {
            throw new ServiceFrameworkException(6064, error.getMessage());
        }
    }

    private Exception handleSoapFault(InvokationException ex) {
        this.ctx.logError("Web service request failed. " + ex.getFaultInfo().getFaultCause() + " : " + ex.getFaultInfo().getFaultMessage());
        SoapFaultException exception = new SoapFaultException(ex.getFaultInfo().getFaultCause(), ex.getFaultInfo().getFaultMessage());
        try {
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)("Unable to raise exception. " + error.getMessage()));
        }
        return ex;
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"PNBRService", (boolean)false);
        sco.setServiceClassName(PNBRService.class.getName());
        sco.setServiceDescription("Acts as a proxy for pershing PNBR web service.");
        sco.setServiceDisplayName("Position and Balance Service");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SemanticType input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountBalanceInput");
        SemanticType output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountBalanceOutput");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "accountBalance", "accountBalance");
        handler.bindRequestObject("event.pershing.web.pnbr.accountBalance.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.accountBalance.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountBookkeepingInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountBookkeepingOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "accountBookkeeping", "accountBookkeeping");
        handler.bindRequestObject("event.pershing.web.pnbr.accountBookkeeping.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.accountBookkeeping.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountPositionInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountPositionOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "accountPosition", "accountPosition");
        handler.bindRequestObject("event.pershing.web.pnbr.accountPosition.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.accountPosition.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountTradeInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prAccountTradeOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "accountTrade", "accountTrade");
        handler.bindRequestObject("event.pershing.web.pnbr.accountTrade.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.accountTrade.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prBalanceDetailInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prBalanceDetailOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "balanceDetail", "balanceDetail");
        handler.bindRequestObject("event.pershing.web.pnbr.balanceDetail.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.balanceDetail.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prFundAvailableInquiryInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prFundAvailableInquiryOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "fundAvailableInquiry", "fundAvailableInquiry");
        handler.bindRequestObject("event.pershing.web.pnbr.fundAvailableInquiry.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.fundAvailableInquiry.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prPrevDayBalanceInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prPrevDayBalanceOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "prevDayBalance", "prevDayBalance");
        handler.bindRequestObject("event.pershing.web.pnbr.prevDayBalance.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.prevDayBalance.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prRtmServiceInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prRtmServiceOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "rtmService", "rtmService");
        handler.bindRequestObject("event.pershing.web.pnbr.rtmService.input", input);
        handler.bindResponseObject("event.pershing.web.pnbr.rtmService.output", output);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION_FACTORY, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("Pershing Connection Factory");
        prop.setDescription("Specifies Pershing connection factory.");
        prop.setValue((Object)new ClientFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty(SERVICE_URI, ServicePropertyType.STRING, null);
        prop.setLabel("Pershing PNBR Service URI");
        prop.setDescription("Specifies URI of the PNBR service.");
        prop.setValue("/soap/pnbr/1/service");
        sco.addProperty(prop);
        sco.addException("exception.ws.SoapFault");
        sco.addException("exception.ws.SoapRequest");
        return sco;
    }

    public static void main(String[] args) {
        try {
            RuntimeContext.getInstance();
            XSerializer serializer = RuntimeContext.getInstance().getXSerializer();
            PNBRService.generateSco(serializer, PNBRService.class, "PNBRService");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected static void generateSco(XSerializer serializer, Class<?> clazz, String name) throws Exception {
        if (Service.class.isAssignableFrom(clazz)) {
            try {
                Method method = clazz.getDeclaredMethod("generateSco", new Class[0]);
                ServiceConfigurationObject sco = (ServiceConfigurationObject)method.invoke(null, new Object[0]);
                FileIOUtils.putFile((String)new File(".").getAbsolutePath(), (String)(name + "." + "prototype" + ".sco"), (byte[])serializer.serialize((Object)sco));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void onEvent(ClientException e) {
        this.ctx.logError("Client Connection exception : " + e.getMessage());
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Client connection state changed: " + e.getState().toString());
        if (e.getState() != ConnectionState.CONNECTED) {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Database connection state changed to " + e.getState().toString());
        } else {
            this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
        }
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch error in raiseAdvisory(): " + ex.getMessage() + " Client Error: " + e.getMessage());
        }
    }
}

