/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.pershing.service.order.processing;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.pershing.connection.PershingConnection;
import com.streamscape.pershing.service.order.processing.Version;
import com.streamscape.pershing.service.order.processing.generated.InvokationException;
import com.streamscape.pershing.service.order.processing.generated.Orderprocessing;
import com.streamscape.pershing.service.order.processing.generated.OrderprocessingDocPort;
import com.streamscape.pershing.service.order.processing.generated.types.CancelEOOutput;
import com.streamscape.pershing.service.order.processing.generated.types.CancelEOV2Input;
import com.streamscape.pershing.service.order.processing.generated.types.CancelMFOutput;
import com.streamscape.pershing.service.order.processing.generated.types.CancelMFV2Input;
import com.streamscape.pershing.service.order.processing.generated.types.CancelReplaceEOOutput;
import com.streamscape.pershing.service.order.processing.generated.types.CancelReplaceEOV2Input;
import com.streamscape.pershing.service.order.processing.generated.types.FundAvailInquiryInput;
import com.streamscape.pershing.service.order.processing.generated.types.FundAvailInquiryOutput;
import com.streamscape.pershing.service.order.processing.generated.types.NewEOOutput;
import com.streamscape.pershing.service.order.processing.generated.types.NewEORebalanceInput;
import com.streamscape.pershing.service.order.processing.generated.types.NewEORebalanceOutput;
import com.streamscape.pershing.service.order.processing.generated.types.NewEOV2Input;
import com.streamscape.pershing.service.order.processing.generated.types.NewMFOutput;
import com.streamscape.pershing.service.order.processing.generated.types.NewMFRebalanceInput;
import com.streamscape.pershing.service.order.processing.generated.types.NewMFRebalanceOutput;
import com.streamscape.pershing.service.order.processing.generated.types.NewMFV2Input;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.SoapFaultException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderProcessingService
extends AbstractService
implements ExceptionEventListener,
StateNotificationEventListener {
    public static final String CONNECTION_FACTORY = "client.factory";
    public static final String SERVICE_URI = "pershing.service.uri";
    String serviceUri = null;
    OrderprocessingDocPort port = null;
    ClientConnection pershingConnection = null;
    String implementationVersion = "1";

    public CancelEOOutput cancelEquityOption(CancelEOV2Input input) throws Exception {
        try {
            return this.port.cancelEquityOption(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw this.handleSoapFault(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public CancelMFOutput cancelMutualFund(CancelMFV2Input input) throws Exception {
        try {
            return this.port.cancelMutualFund(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public CancelReplaceEOOutput cancelReplaceEquityOption(CancelReplaceEOV2Input input) throws Exception {
        try {
            return this.port.cancelReplaceEquityOption(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public FundAvailInquiryOutput fundAvailableInquiry(FundAvailInquiryInput input) throws Exception {
        try {
            return this.port.fundAvailableInquiry(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public NewEORebalanceOutput newEORebalance(NewEORebalanceInput input) throws Exception {
        try {
            return this.port.newEORebalance(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public NewEOOutput newEquityOption(NewEOV2Input input) throws Exception {
        try {
            return this.port.newEquityOption(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public NewMFRebalanceOutput newMFRebalance(NewMFRebalanceInput input) throws Exception {
        try {
            return this.port.newMFRebalance(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public NewMFOutput newMutualFund(NewMFV2Input input) throws Exception {
        try {
            return this.port.newMutualFund(this.implementationVersion, input);
        }
        catch (InvokationException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SOAPFaultException exception) {
            this.ctx.logDebug("toString: " + exception.toString());
            this.ctx.logDebug("getMessage: " + exception.getMessage());
            this.ctx.logDebug("getFault.toString: " + exception.getFault().toString());
            this.ctx.logDebug("getFault.getBaseURI: " + exception.getFault().getBaseURI());
            this.ctx.logDebug("getFault.getEncodingStyle: " + exception.getFault().getEncodingStyle());
            this.ctx.logDebug("getFault.getFaultActor: " + exception.getFault().getFaultActor());
            this.ctx.logDebug("getFault.getFaultCode: " + exception.getFault().getFaultCode());
            try {
                this.ctx.logDebug("getFault.getLocalName: " + exception.getFault().getLocalName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getNamespaceURI: " + exception.getFault().getNamespaceURI());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getNodeName: " + exception.getFault().getNodeName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getNodeType: " + exception.getFault().getNodeType());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getNodeValue: " + exception.getFault().getNodeValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getPrefix: " + exception.getFault().getPrefix());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getTagName: " + exception.getFault().getTagName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getTextContent: " + exception.getFault().getTextContent());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.ctx.logDebug("getFault.getValue: " + exception.getFault().getValue());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SoapFaultException(exception.getFault().getFaultCode(), exception.getFault().getFaultString());
        }
    }

    public int getBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    protected void doInit() throws ServiceFrameworkException {
        try {
            this.serviceUri = this.ctx.lookupStringProperty(SERVICE_URI);
            ClientFactory factory = this.ctx.lookupClientFactoryProperty(CONNECTION_FACTORY);
            PershingConnection connection = (PershingConnection)factory.createConnection();
            connection.setExceptionEventListener(this);
            connection.connect();
            connection.setStateNotificationEventListener(this);
            connection.setExceptionEventListener(this);
            if (this.ctx.getLogger() != null) {
                connection.setServiceLogger(this.ctx.getLogger());
            }
            Orderprocessing orderProcessing = connection.getOrderProcessing();
            this.port = orderProcessing.getOrderprocessingSoapDocPort();
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", connection.getUrl() + this.serviceUri);
            this.ctx.logInfo("Connection to Pershing Order Processing service inititalized.");
        }
        catch (Exception error) {
            throw new ServiceFrameworkException(6064, error.getMessage());
        }
    }

    private Exception handleSoapFault(InvokationException ex) {
        this.ctx.logError("Web service request failed. " + ex.getFaultInfo().getFaultCause() + " : " + ex.getFaultInfo().getFaultMessage());
        SoapFaultException exception = new SoapFaultException(ex.getFaultInfo().getFaultCause(), ex.getFaultInfo().getFaultMessage());
        try {
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)("Unable to raise exception. " + error.getMessage()));
        }
        return ex;
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"OrderProcessingService", (boolean)false);
        sco.setServiceClassName(OrderProcessingService.class.getName());
        sco.setServiceDescription("Acts as a proxy for pershing Order Processing web service.");
        sco.setServiceDisplayName("Order Processing Service");
        sco.setInvokeMode(InvokeMode.ASYNC);
        SemanticType input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prCancelEquityOptionInput");
        SemanticType output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prCancelEquityOptionOutput");
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "cancelEquityOption", "cancelEquityOption");
        handler.bindRequestObject("event.pershing.web.orderProc.cancelEquityOption.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.cancelEquityOption.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prCancelMutualFundInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prCancelMutualFundOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "cancelMutualFund", "cancelMutualFund");
        handler.bindRequestObject("event.pershing.web.orderProc.cancelMutualFund.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.cancelMutualFund.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prCancelReplaceEquityOptionInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prCancelReplaceEquityOptionOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "cancelReplaceEquityOption", "cancelReplaceEquityOption");
        handler.bindRequestObject("event.pershing.web.orderProc.cancelReplaceEquityOption.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.cancelReplaceEquityOption.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewEORebalanceInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewEORebalanceOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "newEORebalance", "newEORebalance");
        handler.bindRequestObject("event.pershing.web.orderProc.newEORebalance.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.newEORebalance.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewEquityOptionInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewEquityOptionOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "newEquityOption", "newEquityOption");
        handler.bindRequestObject("event.pershing.web.orderProc.newEquityOption.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.newEquityOption.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prFundAvailableInquiryInput_v2");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prFundAvailableInquiryOutput_v2");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "fundAvailableInquiry", "fundAvailableInquiry");
        handler.bindRequestObject("event.pershing.web.orderProc.fundAvailableInquiry.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.fundAvailableInquiry.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewMFRebalanceInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewMFRebalanceOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "newMFRebalance", "newMFRebalance");
        handler.bindRequestObject("event.pershing.web.orderProc.newMFRebalance.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.newMFRebalance.output", output);
        sco.addEventHandler(handler);
        input = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewMutualFundInput");
        output = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType("prNewMutualFundOutput");
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "newMutualFund", "newMutualFund");
        handler.bindRequestObject("event.pershing.web.orderProc.newMutualFund.input", input);
        handler.bindResponseObject("event.pershing.web.orderProc.newMutualFund.output", output);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION_FACTORY, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("Pershing Connection Factory");
        prop.setDescription("Specifies Pershing connection factory.");
        prop.setValue((Object)new ClientFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty(SERVICE_URI, ServicePropertyType.STRING, null);
        prop.setLabel("Pershing Order Processing Service URI");
        prop.setDescription("Specifies URI of the Order Processing service.");
        prop.setValue("/soap/orderprocessing/1/service");
        sco.addProperty(prop);
        sco.addException("exception.ws.SoapFault");
        sco.addException("exception.ws.SoapRequest");
        return sco;
    }

    public static void main(String[] args) {
        try {
            RuntimeContext.getInstance();
            XSerializer serializer = RuntimeContext.getInstance().getXSerializer();
            OrderProcessingService.generateSco(serializer, OrderProcessingService.class, "OrderProcessingService");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected static void generateSco(XSerializer serializer, Class<?> clazz, String name) throws Exception {
        if (Service.class.isAssignableFrom(clazz)) {
            try {
                Method method = clazz.getDeclaredMethod("generateSco", new Class[0]);
                ServiceConfigurationObject sco = (ServiceConfigurationObject)method.invoke(null, new Object[0]);
                FileIOUtils.putFile((String)new File(".").getAbsolutePath(), (String)(name + "." + "prototype" + ".sco"), (byte[])serializer.serialize((Object)sco));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void onEvent(ClientException e) {
        this.ctx.logError("Client Connection exception : " + e.getMessage());
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Client connection state changed: " + e.getState().toString());
        if (e.getState() != ConnectionState.CONNECTED) {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Database connection state changed to " + e.getState().toString());
        } else {
            this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
        }
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch error in raiseAdvisory(): " + ex.getMessage() + " Client Error: " + e.getMessage());
        }
    }
}

