/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.pershing.connection;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.utils.Base64Encoder;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.pershing.service.order.processing.generated.Orderprocessing;
import com.streamscape.pershing.service.pnbr.generated.Pnbr;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.w3c.dom.Node;

public class PershingConnection
extends AbstractClientConnection {
    private static final String EXC_C14N_ALGORITHM = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String userId = "";
    private String url = "";
    private String corrId = "";
    private String keyName = "";
    private String keyStoreFile = "";
    private String privateKeyAlias = "";
    private String keyStorePass = "";
    private boolean logRequest = false;
    private boolean logResponse = false;
    private boolean logFault = false;
    private Pnbr pnbr = null;
    private Orderprocessing orderProcessing = null;

    public void init(ClientFactory clientFactory) throws ClientException {
        this.userId = clientFactory.getDefaultUser();
        this.url = clientFactory.getUrl();
        this.corrId = clientFactory.getProperty("corrId");
        this.keyName = clientFactory.getProperty("keyName");
        this.keyStoreFile = clientFactory.getProperty("keyStoreFile");
        this.keyStorePass = clientFactory.getProperty("keyStorePass");
        this.privateKeyAlias = clientFactory.getProperty("privateKeyAlias");
        if (clientFactory.getProperties().containsKey("logRequest")) {
            this.logRequest = Boolean.valueOf(clientFactory.getProperty("logRequest"));
        }
        if (clientFactory.getProperties().containsKey("logResponse")) {
            this.logResponse = Boolean.valueOf(clientFactory.getProperty("logResponse"));
        }
        if (clientFactory.getProperties().containsKey("logFault")) {
            this.logFault = Boolean.valueOf(clientFactory.getProperty("logFault"));
        }
    }

    public Pnbr getPnbr() {
        return this.pnbr;
    }

    public Orderprocessing getOrderProcessing() {
        return this.orderProcessing;
    }

    public int ping() throws ClientException {
        try {
            URL pershingUrl = new URL(this.url);
            HTTPClient client = new HTTPClient(pershingUrl);
            HTTPClientResponse response = client.Get("");
            if (response.getStatusCode() == 200) {
                return 0;
            }
            return -1;
        }
        catch (Exception error) {
            throw new ClientException(1011, "Unable to ping connection. Exception: " + error.getMessage());
        }
    }

    public ClientFactory getFactory() {
        return this.factory;
    }

    public void connect() throws ClientException {
        this.setState(ConnectionState.CONNECTING);
        try {
            HeaderHandlerResolver headerHandlerResolver = new HeaderHandlerResolver();
            this.pnbr = new Pnbr();
            this.pnbr.setHandlerResolver(headerHandlerResolver);
            this.orderProcessing = new Orderprocessing();
            this.orderProcessing.setHandlerResolver(headerHandlerResolver);
            this.setState(ConnectionState.CONNECTED);
        }
        catch (Throwable error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            this.setState(ConnectionState.CLOSED);
            this.raiseException((Exception)new ClientException(1011, "Cannot open connection. Exception: " + error.getMessage()));
        }
    }

    public void disconnect() throws ClientException {
        this.setState(ConnectionState.CLOSED);
    }

    public void raiseException(Exception e) {
        if (this.getExceptionEventListener() != null) {
            this.getExceptionEventListener().onEvent(e instanceof ClientException ? (ClientException)e : new ClientException(1031, (Throwable)e));
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCorrNo() {
        return this.corrId;
    }

    public void setCorrId(String corrId) {
        this.corrId = corrId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public void setFactory(ClientFactory factory) {
        this.factory = factory;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addSecurityHeader(SOAPHeader header) throws SOAPException {
        this.logDebug("Add security header to the outbound SOAP call.");
        String userString = "USER=" + this.userId + ";CORR=" + this.corrId + ";TIMESTAMP=" + PershingConnection.generateTimeStamp();
        SOAPElement security = header.addChildElement("Security", "wsse", "http://schemas.xmlsoap.org/ws/2002/04/secext");
        SOAPElement signature = security.addChildElement("Signature", "ds", "http://www.w3.org/2000/09/xmldsig#");
        SOAPElement signedInfo = signature.addChildElement("SignedInfo", "ds");
        SOAPElement canonMethod = signedInfo.addChildElement("CanonicalizationMethod", "ds");
        canonMethod.addAttribute(new QName("Algorithm"), EXC_C14N_ALGORITHM);
        SOAPElement signMethod = signedInfo.addChildElement("SignatureMethod", "ds");
        signMethod.addAttribute(new QName("Algorithm"), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        SOAPElement reference = signedInfo.addChildElement("Reference", "ds");
        reference.addAttribute(new QName("URI"), "#secinfo");
        SOAPElement digestMethod = reference.addChildElement("DigestMethod", "ds");
        digestMethod.addAttribute(new QName("Algorithm"), "http://www.w3.org/2000/09/xmldsig#sha1");
        SOAPElement digestValue = reference.addChildElement("DigestValue", "ds");
        digestValue.addTextNode(this.createDigest("sha1", userString));
        SOAPElement transforms = reference.addChildElement("Transforms", "ds");
        SOAPElement transform = transforms.addChildElement("Transform", "ds");
        transform.addAttribute(new QName("Algorithm"), "http://www.w3.org/TR/1999/REC-xpath-19991116");
        SOAPElement xpath = transform.addChildElement("XPath", "ds");
        xpath.addTextNode("//*[@id='secinfo']/child::*/text()");
        String canonValue = this.canonicalize(signedInfo);
        SOAPElement signatureValue = signature.addChildElement("SignatureValue", "ds");
        signatureValue.addTextNode(this.createSignature("rsa-sha1", canonValue));
        SOAPElement keyInfo = signature.addChildElement("KeyInfo", "ds");
        SOAPElement keyNameNode = keyInfo.addChildElement("KeyName", "ds");
        keyNameNode.addTextNode(this.keyName);
        SOAPElement userNameToken = security.addChildElement("UsernameToken", "t", "http://schemas.xmlsoap.org/ws/2002/04/secext");
        userNameToken.addAttribute(new QName("id"), "secinfo");
        SOAPElement userInfo = userNameToken.addChildElement("UserInfo", "t");
        userInfo.addTextNode(userString);
    }

    public static String generateTimeStamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        return sdf.format(new Date());
    }

    private String createSignature(String signAlgorithmInd, String signedInfoStr) {
        try {
            String keyAlgorithm = "";
            String providerName = "";
            String signAlgorithm = "";
            if (signAlgorithmInd.equalsIgnoreCase("rsa-sha1")) {
                signAlgorithm = "SHA1withRSA";
                keyAlgorithm = "RSA";
                providerName = "SunJSSE";
            } else if (signAlgorithmInd.equalsIgnoreCase("rsa-md5")) {
                signAlgorithm = "MD5withRSA";
                keyAlgorithm = "RSA";
                providerName = "SunJSSE";
            }
            KeyStore keyStore = PershingConnection.loadKeyStore(new File(this.keyStoreFile), this.keyStorePass);
            PrivateKey key = PershingConnection.getPrivateKey(this.privateKeyAlias, this.keyStorePass, keyStore);
            String b64 = new Base64Encoder().encode(key.getEncoded()).trim();
            String test = b64.replaceAll("\\s+", "");
            byte[] encKey = new Base64Encoder().decode(test);
            PKCS8EncodedKeySpec prvKeySpec = new PKCS8EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm, providerName);
            PrivateKey privKey = keyFactory.generatePrivate(prvKeySpec);
            Signature sig = Signature.getInstance(signAlgorithm, providerName);
            sig.initSign(privKey);
            sig.update(signedInfoStr.getBytes());
            byte[] realSig = sig.sign();
            String signVal = new Base64Encoder().encode(realSig);
            return signVal.replaceAll("\\s", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String createDigest(String algorithm, String toDigest) {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance(algorithm, "SUN");
            msgDigest.update(toDigest.getBytes());
            return new Base64Encoder().encode(msgDigest.digest());
        }
        catch (Exception e) {
            this.logError("Error in createDigest: " + e.getMessage());
            return null;
        }
    }

    private static KeyStore loadKeyStore(File keystoreFile, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (null == keystoreFile) {
            throw new IllegalArgumentException("Key store file cannot be null");
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(new FileInputStream(keystoreFile), password.toCharArray());
        return keyStore;
    }

    public static PrivateKey getPrivateKey(String alias, String password, KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
    }

    private String canonicalize(SOAPElement element) {
        String retStr = null;
        try {
            Init.init();
            Canonicalizer c14n = Canonicalizer.getInstance(EXC_C14N_ALGORITHM);
            byte[] outputBytes = c14n.canonicalizeSubtree((Node)element);
            if (outputBytes != null) {
                retStr = new String(outputBytes);
            } else {
                System.err.println("Canonicalized output is null");
            }
            retStr = retStr.replaceFirst("<ds:SignedInfo\\s*[^>]*>", "<ds:SignedInfo>");
        }
        catch (Exception e) {
            System.err.println("Error canonicalizing SignedInfo block");
        }
        return retStr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HeaderHandlerResolver
    implements HandlerResolver {
        HeaderHandlerResolver() {
        }

        public List<Handler> getHandlerChain(PortInfo portInfo) {
            ArrayList<Handler> handlerChain = new ArrayList<Handler>();
            HeaderHandler hh = new HeaderHandler();
            handlerChain.add((Handler)hh);
            return handlerChain;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HeaderHandler
    implements SOAPHandler<SOAPMessageContext> {
        HeaderHandler() {
        }

        public boolean handleMessage(SOAPMessageContext smc) {
            Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outboundProperty.booleanValue()) {
                try {
                    SOAPEnvelope envelope = smc.getMessage().getSOAPPart().getEnvelope();
                    SOAPHeader header = envelope.getHeader();
                    if (header == null) {
                        PershingConnection.this.logDebug("Add header to the outbound SOAP call.");
                        header = envelope.addHeader();
                    }
                    PershingConnection.this.addSecurityHeader(header);
                    if (PershingConnection.this.logRequest) {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        smc.getMessage().writeTo((OutputStream)output);
                        PershingConnection.this.logDebug("SOAP REQUEST: \n" + new String(output.toByteArray()) + "\n");
                    }
                }
                catch (Exception e) {
                    System.out.println("Unable to add security header to the outbound SOAP call to Pershing web service. " + e.getMessage());
                    e.printStackTrace(System.out);
                }
            } else if (PershingConnection.this.logResponse) {
                try {
                    Node outputObject = smc.getMessage().getSOAPBody().getFirstChild().getFirstChild();
                    outputObject.getAttributes().removeNamedItem("xmlns");
                    Field f1 = ClassUtils.getClassField(outputObject.getClass(), (String)"elementQName");
                    f1.setAccessible(true);
                    QName currentValue = (QName)f1.get(outputObject);
                    if (currentValue != null) {
                        f1.set(outputObject, new QName(currentValue.getLocalPart()));
                    }
                    f1 = ClassUtils.getClassField(outputObject.getClass(), (String)"namespaceURI");
                    f1.setAccessible(true);
                    f1.set(outputObject, null);
                }
                catch (Exception ex) {
                    PershingConnection.this.logError("Unable to update SOAP response to be compatible with JAXB bindings.");
                }
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    smc.getMessage().writeTo((OutputStream)output);
                    PershingConnection.this.logDebug("SOAP RESPONSE: \n" + new String(output.toByteArray()) + "\n");
                }
                catch (Exception e) {
                    PershingConnection.this.logError("Unable to print out SOAP response. " + e.getMessage());
                }
            }
            return outboundProperty;
        }

        public boolean handleFault(SOAPMessageContext smc) {
            if (PershingConnection.this.logFault) {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    smc.getMessage().writeTo((OutputStream)output);
                    PershingConnection.this.logError("SOAP FAULT: \n" + new String(output.toByteArray()) + "\n");
                }
                catch (Exception e) {
                    System.out.println("Unable to print out SOAP fault. " + e.getMessage());
                }
            }
            return false;
        }

        public void close(MessageContext context) {
        }

        public Set<QName> getHeaders() {
            return null;
        }
    }
}

