/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser.external;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.MongoCompleter;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallParser;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallSequence;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.sef.factory.connection.external.ExternalParserContext;
import com.streamscape.tools.parser.ParserCompletionException;
import com.streamscape.tools.parser.ParserException;

public class MongoExternalParser
implements ExternalParser {
    private MongoFactoryConnectionService service;
    private boolean isCompleteMode;

    public MongoExternalParser(MongoFactoryConnectionService service) {
        this.service = service;
    }

    public ExecutionStatement parse(String script, ExternalParserContext<?> externalParserContext) throws ParserException {
        MongoCallParser parser = new MongoCallParser(this.service);
        parser.setExternalParserContext(externalParserContext);
        parser.setParseDBPrefix(true);
        if (this.isCompleteMode) {
            parser.setExternalParserContext(externalParserContext);
            throw new ParserCompletionException(new MongoCompleter(parser).complete(script, "", this.service, null));
        }
        MongoCallSequence callStatement = parser.parse(script);
        return new MongoExecutionStatement(callStatement);
    }

    public void setCompleteMode(boolean completeMode) {
        this.isCompleteMode = completeMode;
    }
}

