/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCall;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoDatabaseWrapper;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoGetCollectionCall;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MongoCallSequence {
    private List<MongoCall> callSequence = new ArrayList<MongoCall>();
    private MongoDatabaseWrapper wrapper = null;

    public void addCall(MongoCall call) {
        this.callSequence.add(call);
    }

    public List<MongoCall> getCalls() {
        return this.callSequence;
    }

    public MongoCall getLastCall() {
        return this.callSequence.size() > 0 ? this.callSequence.get(this.callSequence.size() - 1) : null;
    }

    public boolean isEmpty() {
        return this.callSequence.isEmpty();
    }

    public Class<?> resolveResultClass(ExternalResolveTypeContext externalResolveTypeContext) {
        MongoCall call;
        Class clazz = MongoDatabaseWrapper.class;
        Iterator<MongoCall> iterator = this.callSequence.iterator();
        while (iterator.hasNext() && (clazz = (call = iterator.next()).resolveResultClass(clazz, externalResolveTypeContext)) != null) {
        }
        return clazz;
    }

    public Object execute(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        this.wrapper = new MongoDatabaseWrapper(service.getConnection().getDatabase(), service.getConnection());
        Object object = this.wrapper;
        for (MongoCall call : this.callSequence) {
            object = call.execute(service, object, executionContext);
        }
        return object;
    }

    public void toString(StringBuilder builder) {
        boolean first = true;
        for (MongoCall call : this.callSequence) {
            if (!first) {
                builder.append(".");
            }
            call.toString(builder);
            first = false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public Class<?> getResultObjectClass() {
        if (this.callSequence.size() > 0 && this.callSequence.get(0) instanceof MongoGetCollectionCall) {
            MongoGetCollectionCall call = (MongoGetCollectionCall)this.callSequence.get(0);
            if (call.getMongoCollection() != null) {
                return call.getMongoCollection().getResultObjectClass();
            }
        } else if (this.wrapper != null) {
            return this.wrapper.getResultObjectClass();
        }
        return null;
    }
}

