/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl;

import com.mongodb.MongoException;
import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.nosql.mongo.client.MongoClientConnection;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.client.Version;
import com.streamscape.lib.nosql.mongo.dsl.MongoCompleter;
import com.streamscape.lib.nosql.mongo.dsl.MongoJsonParser;
import com.streamscape.lib.nosql.mongo.dsl.MongoSLResponseBuilder;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallParser;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallSequence;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.xsd.EdlGenerator;
import com.streamscape.omf.xsd.Parser;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.ShowRuntimeContextOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoFromXsdXmlOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.CreateSdoFromJsonOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.factory.connection.AbstractGetFetchSizeOperation;
import com.streamscape.sef.factory.connection.AbstractSetFetchSizeOperation;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.GetDataObjectNotationOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.SetDataObjectNotationOperation;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.parser.AbstractParserException;
import com.streamscape.tools.parser.ParserException;
import com.streamscape.tools.parser.ParserPositionalException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bson.Document;

class MongoFactoryConnectionDSLProvider
extends AbstractDSLProvider<MongoFactoryConnectionService> {
    private static final String NAME = "MongoFactoryConnectionDSLProvider";

    MongoFactoryConnectionDSLProvider(MongoFactoryConnectionService callable) {
        super(NAME, (SLCallable)callable);
        this.registerOperation((Operation)new MongoFactoryConnectionListCollectionsOperation());
        this.registerOperation((Operation)new MongoFactoryConnectionDbOperation());
        this.registerOperation((Operation)new MongoFactoryConnectionCreateSdoFromCollectionOperation());
        this.registerOperation((Operation)new MongoFactoryConnectionDescribeServerOperation());
        this.registerOperation((Operation)new MongoFactoryConnectionShowVersionOperation());
        this.registerOperation((Operation)new MongoFactoryConnectionSetFetchSizeOperation());
        this.registerOperation((Operation)new MongoFactoryConnectionGetFetchSizeOperation());
        this.registerOperation((Operation)new SetDataObjectNotationOperation());
        this.registerOperation((Operation)new GetDataObjectNotationOperation());
        this.registerOperation((Operation)new ShowRuntimeContextOperation());
        this.activate((SLCallable)callable);
    }

    protected RuntimeContext getRuntimeContext() {
        return RuntimeContext.getInstance();
    }

    protected String getTagsFilePrefix() {
        return "MongoConnection";
    }

    private static class ExternalExecutionContextForFetchSize
    implements ExternalExecutionContext {
        private SLSessionData slSessionData;

        public ExternalExecutionContextForFetchSize(SLSessionData slSessionData) {
            this.slSessionData = slSessionData;
        }

        public Class<?> resolveType(Object value) {
            return null;
        }

        public Object getCallable() {
            return null;
        }

        public Object getValue(Object value) {
            return null;
        }

        public ClassLoader getClassLoader() {
            return RuntimeContext.getInstance().getSystemClassLoaderChain();
        }

        public int getFetchSize() {
            return this.slSessionData.getFetchSize();
        }

        public SLSessionData getSLSessionData() {
            return this.slSessionData;
        }
    }

    private static class MongoQueryCompleter
    extends MongoCompleter {
        private MongoQueryCompleter() {
        }

        @Override
        public DSLCompletion complete(String script, String processedScript, MongoFactoryConnectionService callable, MFSession session) {
            if ((script = script.trim()).length() == 0) {
                return new DSLCompletion().setCompletion((Suggestion)new TokenSuggestion("("));
            }
            if (script.charAt(0) != '(') {
                return null;
            }
            return super.complete(script.substring(1), processedScript, callable, session);
        }
    }

    static class MongoFactoryConnectionCreateSdoFromCollectionOperation
    extends AbstractMongoFactoryConnectionOperation {
        public static final String NAME = "create sdo from collection";

        public MongoFactoryConnectionCreateSdoFromCollectionOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.addActionParameter((SyntaxParameter)new IdentifierParameter("CollectionName").setExcludedDelimiters("."));
            this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("query").setName("QueryModifier")).addParameter((SyntaxParameter)new ExpressionParameter("query", '(', ')').setCompleter((ScriptCompleter)new MongoQueryCompleter()))).setRequired(false));
            CreateSdoFromJsonOperation.appendSaveBuildModifier((DSLStatementSyntax)this.syntax);
            CreateSdoFromJsonOperation.appendSimpleTypeAsStringModifier((DSLStatementSyntax)this.syntax);
            CreateSdoFromJsonOperation.appendWithDefaultsModifier((DSLStatementSyntax)this.syntax);
            CreateSdoFromJsonOperation.appendTypesModifier((DSLStatementSyntax)this.syntax);
            CreateSdoFromJsonOperation.appendAliasesModifier((DSLStatementSyntax)this.syntax);
            AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.addAfterBodyModifiers((DSLStatementSyntax)this.syntax);
            this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false));
            this.syntax.setDescription("Creates EDL statements for SDO objects based on provided specified mongo collection.");
            this.syntax.setSyntaxDescription("Parameters:\n   <CollectionName>              - Collection name.\n   <query>                       - Query to select element. If not specified, a first found element will be used.\n" + CreateSdoFromJsonOperation.getSaveBuildModifierDescription() + CreateSdoFromJsonOperation.getSimpleTypeAsStringModifierDescription() + CreateSdoFromJsonOperation.getWithDefaultsModifierDescription() + CreateSdoFromJsonOperation.getTypesModifierDescription() + CreateSdoFromJsonOperation.getAliasesModifierDescription() + AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.getAfterBodyModifiersDescription());
            this.syntax.setExamples("create sdo from collection employees query(employees.find({name : 'John'}))\nsave @ 'c:\\output.edl'\nbuild\ntypes('//age' int, '//name' string, '//date' date)\nnamespace sample.namespace\nreplace archive sample.jar\nreplace package sample");
            this.syntax.addTag(OperationTag.edl);
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement);
        }

        @Override
        public SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            Definition definition = (Definition)statement;
            if (definition.statement.existsModifier("WITH WAIT")) {
                try (AbstractDSLOperation.AsyncFeedbackInvoker feedbackInvoker = new AbstractDSLOperation.AsyncFeedbackInvoker((AbstractDSLOperation)this, session);){
                    SLResponse sLResponse = this.doInvoke(definition, (AbstractDSLOperation.FeedbackInvoker)feedbackInvoker);
                    return sLResponse;
                }
            }
            FabricThreadManager.getInstance().createThread("FSYS:SLANG.SdoOperation", "Performs some operation with SDO.", () -> {
                Utils.sleep((long)500L);
                try (AbstractDSLOperation.AsyncFeedbackInvoker feedbackInvoker = new AbstractDSLOperation.AsyncFeedbackInvoker((AbstractDSLOperation)this, session);){
                    this.doInvoke(definition, (AbstractDSLOperation.FeedbackInvoker)feedbackInvoker);
                    this.raiseSLMessage(null, session);
                }
                catch (Throwable exception) {
                    this.processError(exception, session);
                }
            }).start();
            return new PseudoSLResponse();
        }

        protected void processError(Throwable exception, MFSession session) {
            try {
                this.raiseSLMessageError(Utils.formatException((Throwable)exception, (String)"\n       "), session);
                this.raiseSLMessage(null, session);
            }
            catch (Throwable error) {
                Trace.logException((Object)((Object)this), (Throwable)exception, (boolean)true);
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            }
        }

        protected SLResponse doInvoke(Definition definition, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
            DSLStatement statement = definition.statement;
            Map document = null;
            String collectionName = statement.getParameter("CollectionName").getValue();
            try {
                if (statement.getParameter("query").isPresent()) {
                    MongoCallParser parser = new MongoCallParser((MongoFactoryConnectionService)this.callable);
                    parser.setParseDBPrefix(false);
                    MongoCallSequence calls = parser.parse(statement.getParameter("query").getValue());
                    Object result = calls.execute((MongoFactoryConnectionService)this.callable, new ExternalExecutionContextForFetchSize(feedbackInvoker.getMFSession().getSLSessionData()));
                    if (result instanceof Iterable) {
                        Iterator i = ((Iterable)result).iterator();
                        if (i.hasNext()) {
                            document = (Map)i.next();
                        }
                    } else if (result instanceof Map) {
                        document = (Map)result;
                    } else {
                        throw new Exception("Invalid query. Should return iterator or document, but returns " + (result != null ? result.getClass().getName() : "null"));
                    }
                    if (document == null) {
                        throw new Exception("Specified query does not return elements.");
                    }
                } else {
                    document = (Map)((MongoFactoryConnectionService)this.callable).getConnection().getCollection(collectionName).find().first();
                    if (document == null) {
                        throw new Exception("Specified collection does not contain elements.");
                    }
                }
            }
            catch (MongoException exception) {
                return new MongoSLResponseBuilder((MongoFactoryConnectionService)this.callable).build(exception);
            }
            feedbackInvoker.addFeedback("\nGenerating EDL...");
            String json = ((MongoFactoryConnectionService)this.callable).getConnection().getCodec().toJson(document, false);
            EdlGenerator generator = AbstractCreateSdoFromXsdXmlOperation.createEdlGenerator((AbstractDSLOperation)this, (DSLStatement)statement, (Parser)new MongoJsonParser());
            HashMap<String, String> typesMap = generator.getTypesMap();
            if (typesMap == null) {
                typesMap = new HashMap<String, String>();
                generator.setTypesMap(typesMap);
            }
            if (!typesMap.containsKey("//")) {
                typesMap.put("//", collectionName);
            }
            Map edls = generator.generateEdl((InputStream)new ByteArrayInputStream(json.getBytes()));
            feedbackInvoker.addOK();
            return AbstractCreateSdoFromXsdXmlOperation.buildAndSaveEdls((DSLStatement)statement, (Map)edls, (AbstractDSLOperation.FeedbackInvoker)feedbackInvoker);
        }

        static class Definition
        extends AbstractSLStatement {
            DSLStatement statement;

            protected Definition(DSLStatement statement) {
                super(MongoFactoryConnectionCreateSdoFromCollectionOperation.NAME);
                this.statement = statement;
            }
        }
    }

    static class MongoFactoryConnectionDbOperation
    extends AbstractMongoFactoryConnectionOperation {
        public static final String NAME = "db.";

        public MongoFactoryConnectionDbOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.getAction().setNoSpacesAfter();
            this.syntax.addActionParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("CollectionFunctionsPipe").setCompleter((ScriptCompleter)new MongoCompleter())).setEndDelimiterToCommandEnd());
            this.syntax.setNoSpacesAfter();
            this.syntax.setCompactSyntax("db[.<collectionName>].<method(<argument>...)[.method(<argument>...)...]");
            this.syntax.setDescription("Executes Mongo DB function.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement.getParameter("CollectionFunctionsPipe").getValue(), statement);
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            MongoCallParser parser = new MongoCallParser((MongoFactoryConnectionService)this.callable);
            parser.setParseDBPrefix(false);
            try {
                MongoCallSequence calls = parser.parse(((Definition)statement).script);
                Object result = calls.execute((MongoFactoryConnectionService)this.callable, new ExternalExecutionContextForFetchSize(session.getSLSessionData()));
                return new MongoSLResponseBuilder((MongoFactoryConnectionService)this.callable).build(result, session.getSLSessionData());
            }
            catch (ParserException exception) {
                if (exception.getLineNumber() > 0) {
                    String original = ((Definition)statement).statement.getOriginalStatement();
                    int position = BufferUtils.getAbsolutePosition((String)((Definition)statement).script, (int)exception.getLineNumber(), (int)(exception.getPositionInLine() - 1));
                    BufferUtils.setLineAndPositions((ParserPositionalException)exception, (String)original, (int)(position += original.indexOf(((Definition)statement).script)));
                }
                throw exception;
            }
            catch (MongoException exception) {
                return new MongoSLResponseBuilder((MongoFactoryConnectionService)this.callable).build(exception);
            }
        }

        static class Definition
        extends AbstractSLStatement {
            String script;
            DSLStatement statement;

            protected Definition(String script, DSLStatement statement) {
                super(MongoFactoryConnectionDbOperation.NAME);
                this.script = script;
                this.statement = statement;
            }
        }
    }

    static class MongoFactoryConnectionGetFetchSizeOperation
    extends AbstractGetFetchSizeOperation<MongoFactoryConnectionService> {
        MongoFactoryConnectionGetFetchSizeOperation() {
        }
    }

    static class MongoFactoryConnectionSetFetchSizeOperation
    extends AbstractSetFetchSizeOperation<MongoFactoryConnectionService> {
        MongoFactoryConnectionSetFetchSizeOperation() {
        }
    }

    static class MongoFactoryConnectionShowVersionOperation
    extends AbstractMongoFactoryConnectionOperation {
        public static final String NAME = "show version";

        public MongoFactoryConnectionShowVersionOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("SHOW VERSION");
            this.syntax.setDescription("Shows mongo client and mongo java driver versions.");
            this.syntax.addTag(OperationTag.session);
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return new SLResponse(Version.getVersionString());
        }

        public static class Definition
        extends AbstractSLStatement {
            public Definition() {
                super(MongoFactoryConnectionShowVersionOperation.NAME);
            }
        }
    }

    static class MongoFactoryConnectionDescribeServerOperation
    extends AbstractMongoFactoryConnectionOperation {
        public static final String NAME = "describe server";

        public MongoFactoryConnectionDescribeServerOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("DESCRIBE SERVER");
            this.syntax.setDescription("Describes server.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            MongoClientConnection connection = ((MongoFactoryConnectionService)this.callable).getConnection();
            RowSet result = new RowSet(MongoFactoryConnectionDescribeServerOperation.createResultDescriptor());
            try {
                Document buildInfo = connection.getBuildInfo();
                result.addToRowSet(new Object[]{"Connection State", connection.getState().toString()});
                result.addToRowSet(new Object[]{"Server Version", buildInfo.getString("version")});
                result.addToRowSet(new Object[]{"URL", connection.getUrl()});
                result.addToRowSet(new Object[]{"Database Name", connection.getDatabase().getName()});
                result.addToRowSet(new Object[]{"Server System Info", buildInfo.getString("sysInfo")});
                result.addToRowSet(new Object[]{"Server Debug", buildInfo.getBoolean("debug")});
            }
            catch (Exception exception) {
                result.addToRowSet(new Object[]{"Connection State", connection.getState().toString()});
                result.addToRowSet(new Object[]{"Exception", exception.toString()});
                result.addToRowSet(new Object[]{"URL", connection.getUrl()});
            }
            return new SLResponse(result);
        }

        static RowMetaData createResultDescriptor() {
            RowMetaData result = new RowMetaData(10);
            MongoFactoryConnectionDescribeServerOperation.addColumn((RowMetaData)result, (String)"Property");
            MongoFactoryConnectionDescribeServerOperation.addColumn((RowMetaData)result, (String)"Value");
            return result;
        }

        static class Definition
        extends AbstractSLStatement {
            protected Definition() {
                super(MongoFactoryConnectionDescribeServerOperation.NAME);
            }
        }
    }

    static class MongoFactoryConnectionListCollectionsOperation
    extends AbstractMongoFactoryConnectionOperation {
        public static final String NAME = "list collections";

        public MongoFactoryConnectionListCollectionsOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("LIST COLLECTIONS");
            this.syntax.setDescription("Returns list of collections.");
        }

        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        @Override
        protected SLResponse onInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            RowSet result = new RowSet(MongoFactoryConnectionListCollectionsOperation.createResultDescriptor());
            for (String name : ((MongoFactoryConnectionService)this.callable).getConnection().listCollections()) {
                result.addToRowSet(new Object[]{name});
            }
            return new SLResponse(result);
        }

        static RowMetaData createResultDescriptor() {
            RowMetaData result = new RowMetaData(10);
            MongoFactoryConnectionListCollectionsOperation.addColumn((RowMetaData)result, (String)"Collection Name");
            return result;
        }

        static class Definition
        extends AbstractSLStatement {
            protected Definition() {
                super(MongoFactoryConnectionListCollectionsOperation.NAME);
            }
        }
    }

    static abstract class AbstractMongoFactoryConnectionOperation
    extends AbstractDSLOperation<MongoFactoryConnectionService> {
        AbstractMongoFactoryConnectionOperation() {
        }

        protected void createDSLSyntax(String name) {
            super.createDSLSyntax(name);
            this.syntax.addTag("mongodb");
        }

        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            try {
                return this.onInvoke(statement, session, timeout);
            }
            catch (Exception exception) {
                if (exception instanceof AbstractParserException) {
                    throw exception;
                }
                throw new Exception(exception.getMessage());
            }
        }

        protected abstract SLResponse onInvoke(SLStatement var1, MFSession var2, long var3) throws Exception;

        protected void doRaiseSLMessage(SLMessage message) {
            AbstractOperation.raiseSLMessage((SLMessage)message);
        }
    }
}

