/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.client.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.streamscape.Trace;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.lib.nosql.mongo.client.serialization.JsonExtendedConverter;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodec;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodecException;
import com.streamscape.lib.nosql.mongo.client.serialization.jackson.DocumentCodecCustomized;
import com.streamscape.lib.nosql.mongo.client.serialization.jackson.DocumentJsonGenerator;
import com.streamscape.lib.nosql.mongo.client.serialization.jackson.DocumentJsonParser;
import com.streamscape.lib.nosql.mongo.dsl.parser.JsonArgumentHolder;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoMethodExternalArgument;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonDateTimeSerializers;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.runtime.RuntimeContext;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;

public class MongoSdoCodecBasedOnJackson
implements MongoSdoCodec<Document> {
    private CodecRegistry codecRegistry;

    public MongoSdoCodecBasedOnJackson(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public Document toDocument(Object object) throws MongoSdoCodecException {
        Object result = this.toDocumentOrPrimitiveObject(object);
        if (!(result instanceof Document)) {
            throw new MongoSdoCodecException("Failed to convert object '" + object + "' to JSON document.");
        }
        return (Document)result;
    }

    @Override
    public Bson toBson(Object object) throws MongoSdoCodecException {
        if (object instanceof Bson) {
            return (Bson)object;
        }
        if (object instanceof String) {
            return BsonDocument.parse((String)object);
        }
        return BsonDocumentWrapper.asBsonDocument(this.toDocument(object), this.codecRegistry);
    }

    @Override
    public Object toDocumentOrPrimitiveObject(Object object) throws MongoSdoCodecException {
        if (object == null) {
            return null;
        }
        if (object instanceof Document) {
            return object;
        }
        if (JsonArgumentHolder.isJsonValue(object)) {
            try {
                Document document = Document.parse((String)object);
                return MongoSdoCodecBasedOnJackson.replaceAllJsonExtendedElements(document);
            }
            catch (Exception exception) {
                throw new MongoSdoCodecException("Could not parse given String to save into a JSON document.", exception);
            }
        }
        if (JsonArgumentHolder.isSimpleObject(object) || object instanceof java.util.Date || object instanceof TimestampData) {
            return object;
        }
        try {
            DocumentJsonGenerator generator = new DocumentJsonGenerator();
            this.getSerializer().serialize(object, (JsonGenerator)generator);
            return generator.getDocument();
        }
        catch (Exception exception) {
            throw new MongoSdoCodecException("Could not serialize given object to json.", exception);
        }
    }

    @Override
    public <TT> TT fromDocument(Object document, Class<TT> clazz) throws MongoSdoCodecException {
        try {
            document = MongoSdoCodecBasedOnJackson.replaceAllJsonExtendedElements(document);
            DocumentJsonParser parser = new DocumentJsonParser((Document)document);
            return (TT)this.getSerializer().deserialize(clazz, (JsonParser)parser);
        }
        catch (Exception exception) {
            throw new MongoSdoCodecException("Could not deserialize result object from json.", exception);
        }
    }

    @Override
    public Class<Document> getDocumentClass() {
        return Document.class;
    }

    @Override
    public Map newDocument() {
        return new Document();
    }

    @Override
    public <TT> TT fromJson(String json, Class<TT> clazz) throws MongoSdoCodecException {
        return this.fromDocument(Document.parse(json), clazz);
    }

    @Override
    public String toJson(Object object) throws MongoSdoCodecException {
        return this.toJson(object, false);
    }

    @Override
    public String toJson(Object object, boolean prettyPrint) throws MongoSdoCodecException {
        object = this.toDocument(object);
        object = this.replaceJsonBsonPrimitives(object);
        return ((Document)object).toJson(new JsonWriterSettings(prettyPrint), new DocumentCodecCustomized(this.codecRegistry, null));
    }

    private JSONSerializer getSerializer() {
        return JSONSerializerForBsonSerializationHolder.serializer;
    }

    private Document replaceJsonBsonPrimitives(Object element) {
        return (Document)element;
    }

    public static Object replaceAllJsonExtendedElements(Object element) {
        block4: {
            block3: {
                if (!(element instanceof Map)) break block3;
                Object newElement = MongoSdoCodecBasedOnJackson.replaceJsonExtended(element);
                if (newElement != element) {
                    return newElement;
                }
                Iterator iterator = ((Map)element).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry oentry;
                    Map.Entry entry = oentry = iterator.next();
                    entry.setValue(MongoSdoCodecBasedOnJackson.replaceAllJsonExtendedElements(entry.getValue()));
                }
                break block4;
            }
            if (!(element instanceof List)) break block4;
            List array = (List)element;
            for (int i = 0; i < array.size(); ++i) {
                array.set(i, MongoSdoCodecBasedOnJackson.replaceAllJsonExtendedElements(array.get(i)));
            }
        }
        return element;
    }

    public static Object replaceJsonExtended(Object object) {
        Object element;
        if (!(object instanceof Map)) {
            return object;
        }
        Map map = (Map)object;
        if (map.size() == 1 && (element = map.get("$numberLong")) != null) {
            return new JsonExtendedConverterLong().convert(element);
        }
        if (map.size() == 1 && (element = map.get("$date")) != null) {
            return new JsonExtendedConverterDate().convert(element);
        }
        if (map.size() == 1 && (element = map.get("$oid")) != null) {
            return new JsonExtendedConverterOid().convert(element);
        }
        if (map.size() == 2 && (element = map.get("$binary")) != null && map.get("$type") != null) {
            return new JsonExtendedConverterBinary().convert(element);
        }
        return object;
    }

    public static class MongoAsItIsDeserializer<T>
    extends StdScalarDeserializer<T> {
        protected MongoAsItIsDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Object object = jp.getEmbeddedObject();
            if (object != null && object.getClass() != this._valueClass && object.getClass() == java.util.Date.class) {
                if (this._valueClass == Date.class) {
                    object = new Date(((java.util.Date)object).getTime());
                } else if (this._valueClass == Timestamp.class) {
                    object = new Timestamp(((java.util.Date)object).getTime());
                }
            }
            return (T)object;
        }
    }

    public static class MongoAsItIsSerializer<T>
    extends StdScalarSerializer<T> {
        protected MongoAsItIsSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value);
        }
    }

    public static class JsonExtendedConverterLong
    implements JsonExtendedConverter {
        @Override
        public Object convert(Object element) {
            if (element instanceof Number) {
                element = ((Number)element).longValue();
            } else if (element instanceof String) {
                element = Long.valueOf((String)element);
            } else if (element instanceof MongoMethodExternalArgument) {
                ((MongoMethodExternalArgument)element).setConverter(this);
            }
            return element;
        }
    }

    public static class JsonExtendedConverterBinary
    implements JsonExtendedConverter {
        @Override
        public Object convert(Object element) {
            if (element instanceof byte[]) {
                return element;
            }
            if (element instanceof String) {
                element = DatatypeConverter.parseBase64Binary((String)((String)element));
            } else if (element instanceof MongoMethodExternalArgument) {
                ((MongoMethodExternalArgument)element).setConverter(this);
            }
            return element;
        }
    }

    public static class JsonExtendedConverterDate
    implements JsonExtendedConverter {
        @Override
        public Object convert(Object element) {
            if (element instanceof Number) {
                element = new java.util.Date(((Number)element).longValue());
            } else if (element instanceof String) {
                element = new java.util.Date(Long.valueOf((String)element));
            } else if (element instanceof MongoMethodExternalArgument) {
                ((MongoMethodExternalArgument)element).setConverter(this);
            }
            return element;
        }
    }

    public static class JsonExtendedConverterOid
    implements JsonExtendedConverter {
        @Override
        public Object convert(Object element) {
            if (element instanceof String) {
                element = new ObjectId((String)element);
            } else if (element instanceof MongoMethodExternalArgument) {
                ((MongoMethodExternalArgument)element).setConverter(this);
            }
            return element;
        }
    }

    private static class JSONSerializerForBsonSerializationHolder {
        static JSONSerializer serializer;

        private JSONSerializerForBsonSerializationHolder() {
        }

        static {
            try {
                serializer = RuntimeContext.getInstance().getJSONSerializerFactory().createSerializerDefaultBuilderLazy("MongoSerialzierForDocumentSerialization").apply(b -> {
                    b.setJsonNotation(JsonNotation.TOP_ELEMENT);
                    b.setJsonNotationLevel(new JsonNotationLevel[]{JsonNotationLevel.POLYMORPHIC_OBJECTS, JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS});
                    SimpleModule module = new SimpleModule();
                    module.addSerializer(java.util.Date.class, new MongoAsItIsSerializer<java.util.Date>(java.util.Date.class));
                    module.addDeserializer(java.util.Date.class, new MongoAsItIsDeserializer<java.util.Date>(java.util.Date.class));
                    module.addSerializer(Date.class, new MongoAsItIsSerializer<Date>(Date.class));
                    module.addDeserializer(Date.class, new MongoAsItIsDeserializer<Date>(Date.class));
                    module.addSerializer(Timestamp.class, new MongoAsItIsSerializer<Timestamp>(Timestamp.class));
                    module.addDeserializer(Timestamp.class, new MongoAsItIsDeserializer<Timestamp>(Timestamp.class));
                    module.addSerializer(Time.class, (JsonSerializer)new JsonDateTimeSerializers.DefaultSqlTimeSerializer());
                    module.addDeserializer(Time.class, (JsonDeserializer)new JsonDateTimeSerializers.DefaultSqlTimeDeserializer());
                    b.addModule(module);
                    b.mapperConfiguration(mapper -> mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES));
                }).build();
            }
            catch (Exception exception) {
                Trace.logError(MongoSdoCodecBasedOnJackson.class, (String)"Failed to initialize MongoSerialzierForDocumentSerialization");
                throw exception;
            }
        }
    }
}

