/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.client.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.streamscape.Trace;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonDateTimeSerializers;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.runtime.RuntimeContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class MongoExtendedJacksonSerializer {
    public static JSONSerializer getSerializer() {
        return Holder.serializer;
    }

    public static class MongoExtendedJsonOidDeserializer
    extends StdScalarDeserializer<String> {
        protected MongoExtendedJsonOidDeserializer() {
            super(String.class);
        }

        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                if (jp.nextToken() != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("$oid") || jp.nextToken() != JsonToken.VALUE_STRING) {
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo oid format. Should be in format {'$oid' : '<value>'}.");
                }
                String result = jp.getText();
                jp.nextToken();
                return result;
            }
            return jp.getText();
        }
    }

    public static class MongoExtendedJsonOidSerializer
    extends StdScalarSerializer<String> {
        protected MongoExtendedJsonOidSerializer() {
            super(String.class);
        }

        public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value);
        }
    }

    public static class MongoExtendedJsonBigDecimalDeserializer
    extends StdScalarDeserializer<BigDecimal> {
        protected MongoExtendedJsonBigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        public BigDecimal deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() != JsonToken.VALUE_STRING && jp.getCurrentToken() != JsonToken.VALUE_NUMBER_FLOAT) {
                ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo big integer format. Should be string or float.");
            }
            return new BigDecimal(jp.getValueAsString());
        }
    }

    public static class MongoExtendedJsonBigDecimalSerializer
    extends StdScalarSerializer<BigDecimal> {
        protected MongoExtendedJsonBigDecimalSerializer() {
            super(BigDecimal.class);
        }

        public void serialize(BigDecimal value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class MongoExtendedJsonBigIntegerDeserializer
    extends StdScalarDeserializer<BigInteger> {
        protected MongoExtendedJsonBigIntegerDeserializer() {
            super(BigInteger.class);
        }

        public BigInteger deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() != JsonToken.VALUE_STRING && jp.getCurrentToken() != JsonToken.VALUE_NUMBER_INT) {
                ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo big integer format. Should be string or int.");
            }
            return new BigInteger(jp.getValueAsString());
        }
    }

    public static class MongoExtendedJsonBigIntegerSerializer
    extends StdScalarSerializer<BigInteger> {
        protected MongoExtendedJsonBigIntegerSerializer() {
            super(BigInteger.class);
        }

        public void serialize(BigInteger value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class MongoExtendedJsonLongDeserializer
    extends StdScalarDeserializer<Long> {
        protected MongoExtendedJsonLongDeserializer() {
            super(Long.class);
        }

        public Long deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                if (jp.nextToken() != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("$numberLong") || jp.nextToken() != JsonToken.VALUE_STRING) {
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo long format. Should be in format {'$numberLong' : '<value>'}.");
                }
                Long result = jp.getValueAsLong();
                jp.nextToken();
                return result;
            }
            return jp.getValueAsLong();
        }
    }

    public static class MongoExtendedJsonLongSerializer
    extends StdScalarSerializer<Long> {
        protected MongoExtendedJsonLongSerializer() {
            super(Long.class);
        }

        public void serialize(Long value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeFieldName("$numberLong");
            jgen.writeString(value.toString());
            jgen.writeEndObject();
        }
    }

    public static class MongoExtendedJsonByteArrayDeserializer
    extends StdScalarDeserializer<byte[]> {
        protected MongoExtendedJsonByteArrayDeserializer() {
            super(byte[].class);
        }

        public byte[] deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                if (jp.nextToken() != JsonToken.FIELD_NAME) {
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo binary format. Should be in format {'$binary' : <base64>, '$type' : 0}.");
                }
                byte[] result = null;
                while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                    if (jp.getCurrentName().equals("$binary")) {
                        jp.nextToken();
                        result = jp.getBinaryValue();
                        jp.nextToken();
                        continue;
                    }
                    if (jp.getCurrentName().equals("$type")) {
                        jp.nextToken();
                        jp.nextToken();
                        continue;
                    }
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo binary format. Should be in format {'$binary' : <base64>, '$type' : 0}.");
                }
                return result;
            }
            return jp.getBinaryValue();
        }
    }

    public static final class MongoExtendedJsonByteArraySerializer
    extends StdSerializer<byte[]> {
        public MongoExtendedJsonByteArraySerializer() {
            super(byte[].class);
        }

        public boolean isEmpty(byte[] value) {
            return value == null || value.length == 0;
        }

        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            jgen.writeFieldName("$binary");
            jgen.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
            jgen.writeFieldName("$type");
            jgen.writeString(Integer.toHexString(0));
            jgen.writeEndObject();
        }
    }

    public static class MongoExtendedJsonSqlTimestampDeserializer
    extends StdScalarDeserializer<Timestamp> {
        protected MongoExtendedJsonSqlTimestampDeserializer() {
            super(Timestamp.class);
        }

        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                if (jp.nextToken() != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("$date") || jp.nextToken() != JsonToken.VALUE_NUMBER_INT) {
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo date format. Should be in format {'$date' : <millis>}.");
                }
                Timestamp date = new Timestamp(jp.getLongValue());
                jp.nextToken();
                return date;
            }
            return new Timestamp(jp.getLongValue());
        }
    }

    public static class MongoExtendedJsonSqlDateDeserializer
    extends StdScalarDeserializer<Date> {
        protected MongoExtendedJsonSqlDateDeserializer() {
            super(Date.class);
        }

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                if (jp.nextToken() != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("$date") || jp.nextToken() != JsonToken.VALUE_NUMBER_INT) {
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo date format. Should be in format {'$date' : <millis>}.");
                }
                Date date = new Date(jp.getLongValue());
                jp.nextToken();
                return date;
            }
            return new Date(jp.getLongValue());
        }
    }

    public static class MongoExtendedJsonDateDeserializer
    extends StdScalarDeserializer<java.util.Date> {
        protected MongoExtendedJsonDateDeserializer() {
            super(java.util.Date.class);
        }

        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                if (jp.nextToken() != JsonToken.FIELD_NAME || !jp.getCurrentName().equals("$date") || jp.nextToken() != JsonToken.VALUE_NUMBER_INT) {
                    ctxt.wrongTokenException(jp, jp.getCurrentToken(), "Invalid mongo date format. Should be in format {'$date' : <millis>}.");
                }
                java.util.Date date = new java.util.Date(jp.getLongValue());
                jp.nextToken();
                return date;
            }
            return new java.util.Date(jp.getLongValue());
        }
    }

    public static class MongoExtendedJsonDateSerializer
    extends StdScalarSerializer<java.util.Date> {
        protected MongoExtendedJsonDateSerializer() {
            super(java.util.Date.class);
        }

        public void serialize(java.util.Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("$date");
            jgen.writeNumber(value.getTime());
            jgen.writeEndObject();
        }
    }

    private static class Holder {
        private static JSONSerializer serializer;

        private Holder() {
        }

        static {
            try {
                serializer = RuntimeContext.getInstance().getJSONSerializerFactory().createSerializerDefaultBuilderLazy("MongoSerialzierExtended").apply(b -> {
                    b.setJsonNotation(JsonNotation.TOP_ELEMENT);
                    b.setJsonNotationLevel(new JsonNotationLevel[]{JsonNotationLevel.POLYMORPHIC_OBJECTS, JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS});
                    SimpleModule module = new SimpleModule(){

                        public void setupModule(Module.SetupContext context) {
                            super.setupModule(context);
                            context.addDeserializationProblemHandler(new DeserializationProblemHandler(){

                                public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                                    if (propertyName.equals("_id")) {
                                        return true;
                                    }
                                    return super.handleUnknownProperty(ctxt, jp, deserializer, beanOrClass, propertyName);
                                }
                            });
                            context.insertAnnotationIntrospector(new AnnotationIntrospector(){

                                public Object findSerializer(Annotated am) {
                                    if (am.getName().equals("_id")) {
                                        return new MongoExtendedJsonOidSerializer();
                                    }
                                    return null;
                                }

                                public Object findDeserializer(Annotated am) {
                                    if (am.getName().equals("_id")) {
                                        return new MongoExtendedJsonOidDeserializer();
                                    }
                                    return null;
                                }

                                public Version version() {
                                    return PackageVersion.VERSION;
                                }
                            });
                        }
                    };
                    module.addSerializer(java.util.Date.class, (JsonSerializer)new MongoExtendedJsonDateSerializer());
                    module.addDeserializer(java.util.Date.class, (JsonDeserializer)new MongoExtendedJsonDateDeserializer());
                    module.addSerializer(Date.class, (JsonSerializer)new MongoExtendedJsonDateSerializer());
                    module.addDeserializer(Date.class, (JsonDeserializer)new MongoExtendedJsonSqlDateDeserializer());
                    module.addSerializer(Timestamp.class, (JsonSerializer)new MongoExtendedJsonDateSerializer());
                    module.addDeserializer(Timestamp.class, (JsonDeserializer)new MongoExtendedJsonSqlTimestampDeserializer());
                    module.addSerializer(byte[].class, (JsonSerializer)new MongoExtendedJsonByteArraySerializer());
                    module.addDeserializer(byte[].class, (JsonDeserializer)new MongoExtendedJsonByteArrayDeserializer());
                    module.addSerializer(Long.class, (JsonSerializer)new MongoExtendedJsonLongSerializer());
                    module.addDeserializer(Long.class, (JsonDeserializer)new MongoExtendedJsonLongDeserializer());
                    module.addSerializer(Long.TYPE, (JsonSerializer)new MongoExtendedJsonLongSerializer());
                    module.addDeserializer(Long.TYPE, (JsonDeserializer)new MongoExtendedJsonLongDeserializer());
                    module.addSerializer(BigInteger.class, (JsonSerializer)new MongoExtendedJsonBigIntegerSerializer());
                    module.addDeserializer(BigInteger.class, (JsonDeserializer)new MongoExtendedJsonBigIntegerDeserializer());
                    module.addSerializer(BigDecimal.class, (JsonSerializer)new MongoExtendedJsonBigDecimalSerializer());
                    module.addDeserializer(BigDecimal.class, (JsonDeserializer)new MongoExtendedJsonBigDecimalDeserializer());
                    module.addSerializer(Time.class, (JsonSerializer)new JsonDateTimeSerializers.DefaultSqlTimeSerializer());
                    module.addDeserializer(Time.class, (JsonDeserializer)new JsonDateTimeSerializers.DefaultSqlTimeDeserializer());
                    b.addModule(module);
                }).build();
            }
            catch (Exception exception) {
                Trace.logError(MongoExtendedJacksonSerializer.class, (String)"Failed to initialize MongoSerializer");
                throw exception;
            }
        }
    }
}

