/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.streamscape.lib.nosql.mongo.client.MongoClientConnection;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodecException;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoDatabaseDelegate;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import java.util.Map;
import org.bson.conversions.Bson;

public class MongoDatabaseWrapper
extends MongoDatabaseDelegate {
    private Class<?> resultObjectClazz;
    private MongoClientConnection mongoClientConnection;

    public MongoDatabaseWrapper(MongoDatabase database, MongoClientConnection mongoClientConnection) {
        super(database);
        this.mongoClientConnection = mongoClientConnection;
    }

    public Class<?> getResultObjectClass() {
        return this.resultObjectClazz;
    }

    @Override
    public <TResult> TResult runCommand(Bson command, Class<TResult> resultClass) {
        this.resultObjectClazz = resultClass;
        return (TResult)super.runCommand(command, this.mongoClientConnection.getCodec().getDocumentClass());
    }

    public MongoCollection<?> getCollectionForCodec(String collectionName) {
        return super.getCollection(collectionName, this.mongoClientConnection.getCodec().getDocumentClass());
    }

    public String toJson(Object object) throws MongoSdoCodecException {
        return this.mongoClientConnection.getCodec().toJson(object);
    }

    public String toJson(Object object, boolean prettyPrint) throws MongoSdoCodecException {
        return this.mongoClientConnection.getCodec().toJson(object, prettyPrint);
    }

    public Object fromJson(String json, String semanticType) throws MongoSdoCodecException {
        return this.mongoClientConnection.getCodec().fromJson(json, this.getClass(semanticType));
    }

    public Map newDocument() throws MongoSdoCodecException {
        return this.mongoClientConnection.getCodec().newDocument();
    }

    public Map<String, Object> toDocument(Object object) throws MongoSdoCodecException {
        return this.mongoClientConnection.getCodec().toDocument(object);
    }

    public Object fromDocument(Object object, String semanticType) throws MongoSdoCodecException {
        return this.mongoClientConnection.getCodec().fromDocument(object, this.getClass(semanticType));
    }

    public UpdateOneModel<?> createUpdateOneModel(Bson filter, Bson replacement) {
        return new UpdateOneModel(filter, replacement);
    }

    public UpdateOneModel<?> createUpdateOneModel(Bson filter, Bson replacement, UpdateOptions options) {
        return new UpdateOneModel(filter, replacement, options);
    }

    private Class<?> getClass(String semanticType) throws MongoSdoCodecException {
        SemanticType type = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(semanticType);
        if (type == null) {
            throw new MongoSdoCodecException("Semantic type '" + semanticType + "' doesn't exist.");
        }
        try {
            return RuntimeContext.getInstance().getSystemClassLoaderChain().loadClass(type.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new MongoSdoCodecException("Failed to load semantic type " + semanticType);
        }
    }
}

