/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.DocumentBuilder;
import com.streamscape.lib.nosql.mongo.dsl.parser.DocumentBuilderForDocumentImpl;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoMethodExternalArgument;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;

public class JsonArgumentHolder {
    private List<Object> parts = new ArrayList<Object>();
    private DocumentBuilder builder;

    public JsonArgumentHolder(Class<?> documentClass) {
        if (documentClass != Document.class) {
            throw new IllegalArgumentException("Wrong docuemnt class " + documentClass);
        }
        this.builder = new DocumentBuilderForDocumentImpl();
    }

    public JsonArgumentHolder(String value) {
        this.parts.add(value);
    }

    public void addPart(Object part) {
        this.parts.add(part);
    }

    public DocumentBuilder getBuilder() {
        return this.builder;
    }

    public List<Object> getExternalExpressions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object part : this.parts) {
            if (!(part instanceof MongoMethodArgument)) continue;
            result.addAll(((MongoMethodArgument)part).getExternalExpressions());
        }
        return result;
    }

    public void setClass(Class<?> clazz) {
        for (Object part : this.parts) {
            if (!(part instanceof MongoMethodExternalArgument)) continue;
            ((MongoMethodExternalArgument)part).setClass(clazz);
        }
    }

    public Map getDocument(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        return this.builder.getResolveResultDocument(service, executionContext);
    }

    public static boolean isJsonValue(Object value) {
        if (value instanceof String) {
            int i;
            String svalue = (String)value;
            if (svalue.length() == 0) {
                return false;
            }
            for (i = 0; i < svalue.length() && Character.isWhitespace(svalue.charAt(i)); ++i) {
            }
            if (i == svalue.length()) {
                return false;
            }
            char c = svalue.charAt(i);
            if (i < svalue.length() && (c == '{' || c == ']')) {
                int j;
                for (j = svalue.length() - 1; j > i && Character.isWhitespace(svalue.charAt(j)); --j) {
                }
                if (j <= i) {
                    return false;
                }
                char cc = svalue.charAt(j);
                return cc == '}' && c == '{' || cc == ']' && c == '[';
            }
        }
        return false;
    }

    public static boolean isSimpleObject(Object object) {
        return object != null && JsonArgumentHolder.isSimpleClass(object.getClass());
    }

    public static boolean isSimpleClass(Class<?> clazz) {
        return String.class == clazz || Number.class.isAssignableFrom(clazz) || Boolean.class == clazz || ObjectId.class == clazz;
    }

    public void toString(StringBuilder builder) {
        for (Object part : this.parts) {
            builder.append(part);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

