/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.client.serialization;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class BasicJavaTypesCodecProvider
implements CodecProvider {
    private static final Map<Class<?>, Codec<?>> codecs = new HashMap();

    private static <T> void addCodec(Codec<T> codec) {
        codecs.put(codec.getEncoderClass(), codec);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return codecs.get(clazz);
    }

    static {
        BasicJavaTypesCodecProvider.addCodec(new BigDecimalCodec());
        BasicJavaTypesCodecProvider.addCodec(new BigIntegerCodec());
    }

    private static class BigIntegerCodec
    implements Codec<BigInteger> {
        private BigIntegerCodec() {
        }

        @Override
        public void encode(BsonWriter writer, BigInteger value, EncoderContext encoderContext) {
            writer.writeString(value.toString());
        }

        @Override
        public BigInteger decode(BsonReader reader, DecoderContext decoderContext) {
            return new BigInteger(reader.readString());
        }

        @Override
        public Class<BigInteger> getEncoderClass() {
            return BigInteger.class;
        }
    }

    private static class BigDecimalCodec
    implements Codec<BigDecimal> {
        private BigDecimalCodec() {
        }

        @Override
        public void encode(BsonWriter writer, BigDecimal value, EncoderContext encoderContext) {
            writer.writeString(value.toString());
        }

        @Override
        public BigDecimal decode(BsonReader reader, DecoderContext decoderContext) {
            return new BigDecimal(reader.readString());
        }

        @Override
        public Class<BigDecimal> getEncoderClass() {
            return BigDecimal.class;
        }
    }
}

