/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.JsonArgumentHolder;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodJsonDocumentArgument;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class MongoMethodDocumentListArgument
implements MongoMethodArgument {
    private List<JsonArgumentHolder> holders;

    MongoMethodDocumentListArgument(List<JsonArgumentHolder> holders) {
        this.holders = holders;
    }

    @Override
    public Class<?> resolveType(ExternalResolveTypeContext resolveTypeContext) {
        return List.class;
    }

    @Override
    public MongoMethodArgument castTo(Class<?> type, ExternalResolveTypeContext resolveTypeContext) {
        if (type == List.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        ArrayList<Document> result = new ArrayList<Document>();
        for (JsonArgumentHolder holder : this.holders) {
            result.add((Document)new MongoMethodJsonDocumentArgument(holder).execute(service, null));
        }
        return result;
    }

    @Override
    public List<Object> getExternalExpressions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonArgumentHolder holder : this.holders) {
            result.addAll(holder.getExternalExpressions());
        }
        return result;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.holders.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

