/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCall;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCollectionWrapper;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoDatabaseWrapper;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;

public class MongoGetCollectionCall
implements MongoCall {
    private String collectionName;
    private MongoCollectionWrapper mongoCollection;

    public MongoGetCollectionCall(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public Class<?> resolveResultClass(Class<?> clazz, ExternalResolveTypeContext executionResolveTypeContext) {
        return MongoCollectionWrapper.class;
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, Object object, ExternalExecutionContext executionContext) throws Exception {
        if (!(object instanceof MongoDatabaseWrapper)) {
            throw new Exception("Failed to get collection from object of type '" + object != null ? object.getClass().getName() : "null'.");
        }
        this.mongoCollection = new MongoCollectionWrapper(((MongoDatabaseWrapper)object).getCollectionForCodec(this.collectionName));
        return this.mongoCollection;
    }

    public MongoCollectionWrapper getMongoCollection() {
        return this.mongoCollection;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.collectionName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

