/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl;

import com.mongodb.client.MongoCollection;
import com.streamscape.Trace;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallParser;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallSequence;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCompletionException;
import com.streamscape.sef.evtrigger.function.fields.FieldsMethodsAllowedForCompletion;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.MethodSuggestion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import com.streamscape.tools.parser.ParserException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TreeSet;

public class MongoCompleter
implements ScriptCompleter<MongoFactoryConnectionService> {
    private MongoCallParser parser;

    public MongoCompleter() {
    }

    public MongoCompleter(MongoCallParser parser) {
        this.parser = parser;
    }

    public DSLCompletion complete(String script, String processedScript, MongoFactoryConnectionService callable, MFSession session) {
        DSLCompletion completion;
        if (this.parser == null) {
            try {
                this.parser = new MongoCallParser(callable);
                this.parser.setParseDBPrefix(false);
            }
            catch (ParserException exception) {
                Trace.logError((Object)this, (String)("Failed to create mongo parser. Cause: " + exception.getMessage()));
                return null;
            }
        }
        if ((completion = this.parser.complete(script)) != null && completion.getException() instanceof MongoCompletionException) {
            MongoCompletionException completionException = (MongoCompletionException)((Object)completion.getException());
            MongoCallSequence calls = completionException.getCalls();
            String prefix = completionException.getPrefix();
            if (calls.isEmpty()) {
                completion = CompoundCompleter.mergeCompletions((String)"", (DSLCompletion)this.completeCollections(calls, prefix, callable), (DSLCompletion)this.completeMethods(calls, prefix));
            } else if (prefix != null && prefix.length() > 0 || script != null && script.trim().endsWith(".")) {
                completion = this.completeMethods(calls, prefix);
            }
            if (completion != null) {
                completion.setException(null);
            }
        }
        return completion;
    }

    private DSLCompletion completeCollections(MongoCallSequence calls, String prefix, MongoFactoryConnectionService callable) {
        DSLCompletion completion = null;
        try {
            ArrayList<String> collections = new ArrayList<String>();
            for (String collectionName : callable.getConnection().listCollections()) {
                if (!collectionName.startsWith(prefix)) continue;
                collections.add(collectionName);
            }
            completion = DSLCompletion.buildPrefixAndCompletion((String)prefix, collections);
            if (completion != null) {
                for (String collection : collections) {
                    completion.addSuggestion(new TokenSuggestion(collection, SuggestionGroup.COLLECTION).setOffset(prefix));
                }
                completion.checkAndCompress();
                completion.moveSingleSuggestionToCompletion();
                if (completion.getCompletion() == null && completion.getSuggestions().size() == 0) {
                    completion.setCompletion((Suggestion)new TokenSuggestion("."));
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((Object)this, (String)("Failed to complete mongo script. Cause: " + exception.getMessage()));
            completion = new DSLCompletion(new Exception(exception.getMessage()));
        }
        return completion;
    }

    private boolean isMethodAllowed(Method method) {
        if (MongoCollection.class.isAssignableFrom(method.getDeclaringClass())) {
            return !method.getName().equals("find") || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Class.class;
        }
        return true;
    }

    private DSLCompletion completeMethods(MongoCallSequence calls, String prefix) {
        DSLCompletion completion = null;
        Class<?> clazz = calls.resolveResultClass((ExternalResolveTypeContext)this.parser.getExternalParserContext());
        TreeSet<String> methodNames = new TreeSet<String>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith(prefix) || !this.isMethodAllowed(method) || !FieldsMethodsAllowedForCompletion.isMethodAllowed(clazz, (Method)method, (boolean)false)) continue;
            methodNames.add(method.getName());
            methods.add(method);
        }
        completion = DSLCompletion.buildPrefixAndCompletion((String)prefix, new ArrayList(methodNames));
        if (completion != null) {
            for (Method method : methods) {
                MethodSuggestion suggestion = new MethodSuggestion(method.getName(), method.getReturnType().getSimpleName(), SuggestionGroup.METHOD);
                suggestion.setOffset(prefix);
                int i = 0;
                for (Class<?> parameter : method.getParameterTypes()) {
                    suggestion.addArgument(new MethodSuggestion.MethodArgument("a" + ++i, new String[]{parameter.getSimpleName()}));
                }
                completion.addSuggestion((Suggestion)suggestion);
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

