/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl;

import com.mongodb.MongoException;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodecException;
import com.streamscape.lib.nosql.mongo.dsl.MongoResultConverter;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetClientIteratorImpl;
import com.streamscape.sdo.sys.Void;
import com.streamscape.slex.SLSessionData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class MongoSLResponseBuilder {
    private MongoFactoryConnectionService service;

    public MongoSLResponseBuilder(MongoFactoryConnectionService service) {
        this.service = service;
    }

    public SLResponse build(Object object, SLSessionData slSessionData) throws MongoSdoCodecException {
        boolean prettyPrint;
        if (object == null) {
            return new SLResponse();
        }
        if (object != null && (object.equals(java.lang.Void.class) || object.getClass().equals(java.lang.Void.class) || object.getClass().equals(Void.class))) {
            return new SLResponse();
        }
        RowMetaData meta = new RowMetaData();
        meta.addColumn("Result", SQLType.STRING);
        SLResponse result = new SLResponse();
        boolean bl = prettyPrint = slSessionData.getDataObjectNotation() == SLSessionData.DataObjectNotation.json_pretty;
        if (slSessionData.getFetchSize() > 0 && (object instanceof Iterator || object instanceof Iterable)) {
            Iterator iterator = (Iterator)MongoResultConverter.builder(this.service, slSessionData).setResultClass(Iterator.class).build().convert(object);
            if (iterator != null) {
                RowSet rowSet = new RowSet(meta);
                while (iterator.hasNext() && rowSet.getRowCount() < slSessionData.getFetchSize()) {
                    try {
                        rowSet.addToRowSet(new Object[]{iterator.next()});
                    }
                    catch (SQLException sQLException) {}
                }
                if (iterator.hasNext()) {
                    result.setObject((Object)new RowSetClientIteratorImpl(slSessionData.getFetchSize(), iterator, rowSet));
                } else {
                    result = new SLResponse(rowSet);
                }
            } else {
                result = new SLResponse(new RowSet(meta));
            }
        } else {
            RowSet rowSet = new RowSet(meta);
            object = MongoResultConverter.builder(this.service, slSessionData).build().convert(object);
            try {
                if (object instanceof List) {
                    for (Object o : (List)object) {
                        rowSet.addToRowSet(new Object[]{o});
                    }
                } else {
                    rowSet.addToRowSet(new Object[]{object});
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            result = new SLResponse(rowSet);
        }
        return result;
    }

    public SLResponse build(MongoException exception) {
        return new SLResponse(exception.toString(), false);
    }

    public SLResponse build(Exception exception) {
        return new SLResponse(exception.toString(), false);
    }
}

