/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.client;

import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.client.MongoOptionsBuilder;
import com.streamscape.lib.nosql.mongo.client.Version;
import com.streamscape.lib.nosql.mongo.client.serialization.BasicJavaTypesCodecProvider;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodec;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodecException;
import com.streamscape.lib.nosql.mongo.client.serialization.jackson.DocumentCodecProviderCustomized;
import com.streamscape.lib.nosql.mongo.client.serialization.jackson.MongoSdoCodecBasedOnJackson;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.sef.factory.connection.UsableClientConnection;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class MongoClientConnection
extends AbstractClientConnection
implements UsableClientConnection {
    private String host;
    private int port;
    private MongoSdoCodec<?> codec;
    private CodecRegistry codecRegistry;
    private MongoClient mongoClient;
    private MongoDatabase database;

    public void init(ClientFactory factory) throws ClientException {
        this.factory = factory;
        this.host = this.getUrlHost(factory.getUrl());
        this.port = this.getUrlPort(factory.getUrl());
        this.logInfo(Version.getVersionString());
        this.logInfo("Using jackson codec for mongo connection.");
        this.codecRegistry = CodecRegistries.fromRegistries(CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new DBRefCodecProvider(), new DocumentCodecProviderCustomized(), new DBObjectCodecProvider(), new BsonValueCodecProvider(), new GeoJsonCodecProvider())), CodecRegistries.fromProviders(new BasicJavaTypesCodecProvider()));
    }

    public MongoSdoCodec<?> getCodec() {
        if (this.codec == null) {
            this.codec = new MongoSdoCodecBasedOnJackson(this.codecRegistry);
        }
        return this.codec;
    }

    public synchronized void connect() throws ClientException {
        if (this.mongoClient == null) {
            this.setState(ConnectionState.CONNECTING);
            this.openMongoClient();
            new SingleTaskWorker("SVC:MongoConnect.Worker", "Pings mongo database first time after connect in background."){

                protected void doExecute() throws FabricException, InterruptedException {
                    try {
                        MongoClientConnection.this.ping();
                    }
                    catch (Throwable exception) {
                        MongoClientConnection.this.logError("Ping connection failed. Error: " + exception.getMessage());
                    }
                }
            }.start();
        }
    }

    public synchronized void disconnect() throws ClientException {
        if (this.mongoClient != null) {
            this.setState(ConnectionState.CLOSING);
            this.closeMongoClient();
            this.setState(ConnectionState.CLOSED);
        } else {
            this.setState(ConnectionState.CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ping() throws ClientException {
        MongoClientConnection mongoClientConnection = this;
        synchronized (mongoClientConnection) {
            if (this.mongoClient == null || this.database == null) {
                this.setState(ConnectionState.CLOSED);
                return -2;
            }
        }
        Exception pingException = null;
        try {
            this.database.runCommand(new BsonDocument("ping", new BsonInt32(1)));
        }
        catch (Exception exception) {
            pingException = exception;
        }
        MongoClientConnection mongoClientConnection2 = this;
        synchronized (mongoClientConnection2) {
            if (this.mongoClient != null) {
                if (pingException != null) {
                    this.setState(ConnectionState.RECONNECTING);
                    this.raiseException(pingException);
                    return -1;
                }
                if (this.getState() != ConnectionState.CONNECTED) {
                    this.setState(ConnectionState.CONNECTED);
                    try {
                        this.logInfo("Successfully connected to mongo server on " + this.host + ":" + this.port + ".");
                        this.logInfo("isMasterResult: " + this.getIsMaster());
                        this.logInfo("buildInfoResult: " + this.getBuildInfo());
                    }
                    catch (Exception exception) {
                        this.logError("Failed to get server info. Cause: " + exception.getMessage());
                    }
                }
                this.setState(ConnectionState.CONNECTED);
                return 0;
            }
            return -2;
        }
    }

    public void raiseException(Exception exception) {
        if (this.getExceptionEventListener() != null) {
            this.getExceptionEventListener().onEvent(new ClientException(1030, (Throwable)exception));
        }
    }

    public String getUrl() {
        return this.factory.getUrl();
    }

    private void openMongoClient() throws ClientException {
        if (this.mongoClient == null) {
            try {
                String databaseName = this.factory.getProperty("database");
                if (databaseName == null || databaseName.trim().length() == 0) {
                    throw new IllegalArgumentException("Dataspace property is not set.");
                }
                ArrayList<MongoCredential> credentials = new ArrayList();
                if (this.factory.getDefaultUser() != null && this.factory.getDefaultUser().length() > 0) {
                    credentials = Arrays.asList(MongoCredential.createCredential(this.factory.getDefaultUser(), databaseName, this.factory.getDefaultPassword().toCharArray()));
                }
                MongoClientOptions options = MongoOptionsBuilder.builder().build(this.factory);
                this.logInfo("Connecting to mongo database on " + this.host + ":" + this.port + ", credentials " + credentials + ", database: " + databaseName + ", options: " + options);
                this.mongoClient = new MongoClient(new ServerAddress(this.host, this.port), credentials, options);
                this.database = this.mongoClient.getDatabase(databaseName).withCodecRegistry(this.codecRegistry);
            }
            catch (Exception exception) {
                this.raiseException(exception);
                this.disconnect();
                throw new ClientException(1030, "Open Mongo connection error: " + exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void closeMongoClient() throws ClientException {
        if (this.mongoClient != null) {
            try {
                this.mongoClient.close();
                this.mongoClient = null;
                this.logInfo("Mongo client closed.");
            }
            catch (Exception exception) {
                this.mongoClient = null;
                this.logInfo("Closing mongo client failed. Cause: " + exception.getMessage());
                this.setState(ConnectionState.CLOSED);
                this.raiseException((Exception)new ClientException(1030, "Close Mongo connection error: " + exception.getMessage(), (Throwable)exception));
            }
        }
    }

    protected void checkState() throws ClientException {
        if (this.mongoClient == null || this.database == null) {
            throw new ClientException(1030, "Mongo connection is not opened.");
        }
    }

    public <T> Object toDocument(T object) throws ClientException {
        try {
            return this.getCodec().toDocument(object);
        }
        catch (MongoSdoCodecException exception) {
            throw new ClientException(1030, exception.getMessage(), (Throwable)exception);
        }
    }

    public <T> T fromDocument(Object object, Class<T> clazz) throws ClientException {
        try {
            return this.getCodec().fromDocument(object, clazz);
        }
        catch (MongoSdoCodecException exception) {
            throw new ClientException(1030, exception.getMessage(), (Throwable)exception);
        }
    }

    public Bson toBson(Object object) throws ClientException {
        try {
            return this.getCodec().toBson(object);
        }
        catch (MongoSdoCodecException exception) {
            throw new ClientException(1030, exception.getMessage(), (Throwable)exception);
        }
    }

    public Document getBuildInfo() throws ClientException {
        return this.getDatabase().runCommand(new BsonDocument("buildinfo", new BsonInt32(1)));
    }

    public Document getIsMaster() throws ClientException {
        return this.getDatabase().runCommand(new BsonDocument("ismaster", new BsonInt32(1)));
    }

    public String getServerVersion() throws ClientException {
        try {
            return this.getBuildInfo().getString("version");
        }
        catch (Exception exception) {
            this.logError("Failed to get server info. Cause: " + exception.getMessage());
            return "unknown";
        }
    }

    public MongoDatabase getDatabase() throws ClientException {
        this.checkState();
        return this.database;
    }

    public List<String> listCollections() throws ClientException {
        this.checkState();
        return this.database.listCollectionNames().into(new ArrayList());
    }

    public <T, TT> void insert(String collectionName, T data) throws ClientException {
        this.checkState();
        this.getCollection(collectionName).insertOne(this.toDocument(data));
    }

    public <T> UpdateResult update(String collectionName, T data) throws ClientException {
        return this.update(collectionName, data, null);
    }

    public <T> UpdateResult update(String collectionName, T data, String jsonCriteria) throws ClientException {
        return this.update(collectionName, data, jsonCriteria, new UpdateOptions());
    }

    public <T> UpdateResult update(String collectionName, T data, String jsonCriteria, UpdateOptions options) throws ClientException {
        this.checkState();
        if (jsonCriteria == null) {
            jsonCriteria = "{}";
        }
        Map map = this.getCodec().newDocument();
        map.put("$set", this.toDocument(data));
        return this.getCollection(collectionName).updateMany(this.toBson(jsonCriteria), this.toBson(map), options);
    }

    public <T> DeleteResult deleteAll(String collectionName) throws ClientException {
        return this.delete(collectionName, null);
    }

    public <T> DeleteResult delete(String collectionName, String jsonCriteria) throws ClientException {
        this.checkState();
        if (jsonCriteria == null) {
            jsonCriteria = "{}";
        }
        return this.getCollection(collectionName).deleteMany(this.toBson(jsonCriteria));
    }

    public long count(String collectionName) throws ClientException {
        this.checkState();
        return this.database.getCollection(collectionName).count();
    }

    public <T> List<T> findAll(String collectionName, Class<T> clazz) throws ClientException {
        return this.findAll(collectionName, clazz, null);
    }

    public <T> T findOne(String collectionName, Class<T> clazz) throws ClientException {
        return this.findOne(collectionName, clazz, null);
    }

    public <T> List<T> findAll(String collectionName, Class<T> clazz, String jsonCriteria) throws ClientException {
        return this.findAll(collectionName, clazz, jsonCriteria, null);
    }

    public <T> List<T> findAll(String collectionName, Class<T> clazz, String jsonCriteria, String jsonKeys) throws ClientException {
        this.checkState();
        if (jsonCriteria == null) {
            jsonCriteria = "{}";
        }
        FindIterable findIterable = this.getCollection(collectionName).find(this.toBson(jsonCriteria));
        if (jsonKeys != null && jsonKeys.length() > 0) {
            findIterable.projection(this.toBson(jsonKeys));
        }
        MongoCursor cursor = findIterable.iterator();
        ArrayList<T> result = new ArrayList<T>();
        while (cursor.hasNext()) {
            result.add(this.fromDocument(cursor.next(), clazz));
        }
        return result;
    }

    public <T> T findOne(String collectionName, Class<T> clazz, String jsonCriteria) throws ClientException {
        return this.findOne(collectionName, clazz, jsonCriteria, null);
    }

    public <T> T findOne(String collectionName, Class<T> clazz, String jsonCriteria, String jsonKeys) throws ClientException {
        this.checkState();
        if (jsonCriteria == null) {
            jsonCriteria = "{}";
        }
        FindIterable findFluent = this.getCollection(collectionName).find(this.toBson(jsonCriteria));
        if (jsonKeys != null && jsonKeys.length() > 0) {
            findFluent.projection(this.toBson(jsonKeys));
        }
        findFluent.limit(1);
        MongoCursor cursor = findFluent.iterator();
        if (cursor.hasNext()) {
            return this.fromDocument(cursor.next(), clazz);
        }
        return null;
    }

    public <TT> MongoCollection<TT> getCollection(String collectionName) {
        return this.database.getCollection(collectionName, this.getCodec().getDocumentClass());
    }

    public FactoryConnectionService createConnectionService() {
        return new MongoFactoryConnectionService(this);
    }

    static {
        try {
            LogManager.getLogManager().readConfiguration(MongoClientConnection.class.getResourceAsStream("/logging.properties"));
        }
        catch (Exception exception) {
            Trace.logError(MongoClientConnection.class, (String)"Failed to set java.util.logging.LogManager configuration.");
            Trace.logException(MongoClientConnection.class, (Throwable)exception, (boolean)true);
        }
    }
}

