/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.client;

import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.streamscape.service.osf.clients.ClientFactory;

public class MongoOptionsBuilder {
    public static MongoOptionsBuilder builder() {
        return new MongoOptionsBuilder();
    }

    public MongoClientOptions build(ClientFactory factory) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        String property = factory.getProperty("description");
        if (property != null && property.length() > 0) {
            builder.description(property);
        }
        if ((property = factory.getProperty("readPreference")) != null && property.length() > 0) {
            builder.readPreference(ReadPreference.valueOf(property.toUpperCase()));
        }
        if ((property = factory.getProperty("writeConcern")) != null && property.length() > 0) {
            builder.writeConcern(WriteConcern.valueOf(property.toUpperCase()));
        }
        if ((property = factory.getProperty("minConnectionPoolSize")) != null && property.length() > 0) {
            builder.minConnectionsPerHost(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("maxConnectionPoolSize")) != null && property.length() > 0) {
            builder.connectionsPerHost(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("serverSelectionTimeout")) != null && property.length() > 0) {
            builder.serverSelectionTimeout(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("maxWaitTime")) != null && property.length() > 0) {
            builder.maxWaitTime(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("maxConnectionIdleTime")) != null && property.length() > 0) {
            builder.maxConnectionIdleTime(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("maxConnectionLifeTime")) != null && property.length() > 0) {
            builder.maxConnectionLifeTime(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("threadsAllowedToBlockForConnectionMultiplier")) != null && property.length() > 0) {
            builder.threadsAllowedToBlockForConnectionMultiplier(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("connectTimeout")) != null && property.length() > 0) {
            builder.connectTimeout(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("socketTimeout")) != null && property.length() > 0) {
            builder.socketTimeout(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("socketKeepAlive")) != null && property.length() > 0) {
            builder.socketKeepAlive(Boolean.parseBoolean(property));
        }
        if ((property = factory.getProperty("sslEnabled")) != null && property.length() > 0) {
            builder.sslEnabled(Boolean.parseBoolean(property));
        }
        if ((property = factory.getProperty("alwaysUseMBeans")) != null && property.length() > 0) {
            builder.alwaysUseMBeans(Boolean.parseBoolean(property));
        }
        if ((property = factory.getProperty("heartbeatFrequency")) != null && property.length() > 0) {
            builder.heartbeatFrequency(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("minHeartbeatFrequency")) != null && property.length() > 0) {
            builder.minHeartbeatFrequency(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("heartbeatConnectTimeout")) != null && property.length() > 0) {
            builder.heartbeatConnectTimeout(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("heartbeatSocketTimeout")) != null && property.length() > 0) {
            builder.heartbeatSocketTimeout(Integer.parseInt(property));
        }
        if ((property = factory.getProperty("localThreshold")) != null && property.length() > 0) {
            builder.localThreshold(Integer.parseInt(property));
        }
        return builder.build();
    }
}

