/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.AbstractMongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodEnumArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodTypedArgument;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;

public class MongoMethodLiteralArgument
extends AbstractMongoMethodArgument {
    public MongoMethodLiteralArgument(String value) {
        super(value);
    }

    @Override
    public Class<?> resolveType(ExternalResolveTypeContext resolveTypeContext) {
        return Object.class;
    }

    @Override
    public MongoMethodArgument castTo(Class<?> type, ExternalResolveTypeContext resolveTypeContext) {
        if (this.value.equals("null")) {
            return this;
        }
        if (!type.isEnum()) {
            Type t = TypeFactory.resolveBasicType(type);
            if (t != null) {
                try {
                    Object newValue = t.convertValue((Object)this.value, null);
                    return new MongoMethodTypedArgument(newValue.getClass(), newValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return new MongoMethodEnumArgument(type, this.value).castTo(type, null);
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        if (this.value.equals("null")) {
            return null;
        }
        throw new UnsupportedOperationException("execute is not allowed in literal argument");
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.value);
    }
}

