/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.mongodb.util.JSONParseException;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.AbstractMongoMethodJsonArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.JsonArgumentHolder;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodJsonObjectArgument;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoMethodJsonDocumentArgument
extends AbstractMongoMethodJsonArgument {
    private Class<?> resultType = Document.class;

    public MongoMethodJsonDocumentArgument(String value) {
        this(new JsonArgumentHolder(value));
    }

    public MongoMethodJsonDocumentArgument(JsonArgumentHolder holder) {
        super(holder);
    }

    @Override
    public Class<?> resolveType(ExternalResolveTypeContext resolveTypeContext) {
        return this.resultType;
    }

    @Override
    public MongoMethodArgument castTo(Class<?> type, ExternalResolveTypeContext resolveTypeContext) {
        if (type == Object.class || type == Document.class) {
            return this;
        }
        if (type == Bson.class) {
            this.resultType = Bson.class;
            return this;
        }
        if (type == Class.class) {
            return null;
        }
        return new MongoMethodJsonObjectArgument(type, this.holder);
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        try {
            Object result = this.holder.getDocument(service, executionContext);
            if (this.resultType == Bson.class) {
                result = service.getConnection().getCodec().toBson(result);
            }
            return result;
        }
        catch (JSONParseException exception) {
            throw new Exception("Could not parse given json. Cause: " + exception.getMessage());
        }
    }
}

