/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.streamscape.Trace;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCall;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodTypedArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoMethodExternalArgument;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class MongoMethodCall
implements MongoCall {
    private String methodName;
    private List<MongoMethodArgument> arguments = new ArrayList<MongoMethodArgument>();
    private boolean setBatchSize = true;

    public MongoMethodCall(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public MongoMethodCall addArgument(MongoMethodArgument argument) {
        this.arguments.add(argument);
        return this;
    }

    public List<MongoMethodArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public Class<?> resolveResultClass(Class<?> clazz, ExternalResolveTypeContext executionResolveTypeContext) {
        Pair<Method, List<MongoMethodArgument>> entry = this.lookupMethod(clazz, executionResolveTypeContext);
        if (entry == null) {
            return null;
        }
        return ((Method)entry.first).getReturnType();
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, Object object, ExternalExecutionContext executionContext) throws Exception {
        if (object == null) {
            throw new Exception("Failed to execute method '" + this.toString() + "' on null object.");
        }
        Class<?> clazz = object.getClass();
        Pair<Method, List<MongoMethodArgument>> entry = this.lookupMethod(clazz, (ExternalResolveTypeContext)executionContext);
        if (entry == null) {
            Trace.logDebug((Object)this, (String)("Method '" + this.toString() + "' not found in class '" + clazz + "'."));
            throw new Exception("Method '" + this.toString() + "' not found.");
        }
        Object[] params = new Object[((List)entry.second).size()];
        for (int i = 0; i < ((List)entry.second).size(); ++i) {
            params[i] = i == 0 && ((List)entry.second).get(i) instanceof MongoMethodExternalArgument && ((Method)entry.first).getName().equals("toJson") ? executionContext.getValue(((MongoMethodExternalArgument)((List)entry.second).get(i)).getExpression()) : ((MongoMethodArgument)((List)entry.second).get(i)).execute(service, executionContext);
        }
        try {
            ((Method)entry.first).setAccessible(true);
            Class<Void> result = ((Method)entry.first).invoke(object, params);
            if (result == null && ((Method)entry.first).getReturnType().equals(Void.TYPE)) {
                result = Void.class;
            }
            return this.invokeBatchSize(service, result, executionContext);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new Exception("Failed to execute method '" + this.toString() + "'. Cause : " + exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof MongoException) {
                throw (MongoException)exception.getTargetException();
            }
            throw new Exception("Failed to execute method '" + this.toString() + "'. Cause : " + exception.getTargetException().getMessage());
        }
    }

    private Object invokeBatchSize(MongoFactoryConnectionService service, Object object, ExternalExecutionContext executionContext) throws Exception {
        if (this.setBatchSize && executionContext.getFetchSize() > 0 && object instanceof FindIterable) {
            object = new MongoMethodCall("batchSize").setBatchSize(false).addArgument(new MongoMethodTypedArgument(Integer.TYPE, executionContext.getFetchSize())).execute(service, object, executionContext);
        }
        return object;
    }

    private MongoMethodCall setBatchSize(boolean setBatchSize) {
        this.setBatchSize = setBatchSize;
        return this;
    }

    private Pair<Method, List<MongoMethodArgument>> lookupMethod(Class<?> clazz, ExternalResolveTypeContext executionResolveTypeContext) {
        ArrayList<Pair> methods = new ArrayList<Pair>();
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(this.methodName) || method.getParameterTypes().length != this.arguments.size()) continue;
            boolean matches = true;
            ArrayList<MongoMethodArgument> newArguments = new ArrayList<MongoMethodArgument>();
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> type = method.getParameterTypes()[i];
                newArguments.add(this.arguments.get(i).castTo(type, executionResolveTypeContext));
                if (newArguments.get(i) != null) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            methods.add(new Pair((Object)method, newArguments));
        }
        if (methods.size() != 0) {
            if (methods.size() != 1) {
                Trace.logDebug((Object)this, (String)("WARNING: More than one method found for '" + this.toString() + "' for class '" + clazz.getName() + "'. Use first one."));
            }
            return (Pair)methods.get(0);
        }
        return null;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.methodName).append("(");
        boolean first = true;
        for (MongoMethodArgument argument : this.arguments) {
            if (!first) {
                builder.append(",");
            }
            argument.toString(builder);
            first = false;
        }
        builder.append(")");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

