/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser.external;

import com.streamscape.ds.types.TimestampData;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.client.serialization.JsonExtendedConverter;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoMethodExternalArgument
implements MongoMethodArgument {
    private Object expression;
    private Class<?> clazz;
    private JsonExtendedConverter converter = null;
    private Class<?> lastValueClass;

    public MongoMethodExternalArgument(Object expression) {
        this.expression = expression;
    }

    public void setConverter(JsonExtendedConverter converter) {
        this.converter = converter;
    }

    @Override
    public Class<?> resolveType(ExternalResolveTypeContext resolveTypeContext) {
        if (this.clazz == null) {
            return resolveTypeContext.resolveType(this.expression);
        }
        return this.clazz;
    }

    @Override
    public MongoMethodArgument castTo(Class<?> type, ExternalResolveTypeContext resolveTypeContext) {
        Class c = resolveTypeContext.resolveType(this.expression);
        if (!((type = TypeFactory.unwrapBoxer(type)) == (c = TypeFactory.unwrapBoxer((Class)c)) || type == Object.class && this.clazz != Class.class || type == Document.class || type == Bson.class || type == Class.class && c == String.class)) {
            return null;
        }
        this.clazz = type;
        return this;
    }

    public void setClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        Object value = executionContext.getValue(this.expression);
        if (this.converter != null) {
            value = this.converter.convert(value);
        }
        if (value instanceof TimestampData) {
            value = new Date(((TimestampData)value).getMilliseconds() + (long)(((TimestampData)value).getZone() * 1000));
        }
        Class<?> clazz = this.lastValueClass = value != null ? value.getClass() : null;
        if (this.clazz == Object.class || this.clazz == Document.class) {
            value = service.getConnection().toDocument(value);
        } else {
            if (this.clazz == Bson.class) {
                return service.getConnection().toBson(value);
            }
            if (this.clazz == Class.class) {
                if (!(value instanceof String)) {
                    throw new Exception("Expected semantic type argument of type string but passed " + value);
                }
                SemanticType semanticType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType((String)value);
                if (semanticType == null) {
                    throw new Exception("Semantic type '" + (String)value + "' doesn't exist.");
                }
                value = ClassUtils.loadClass((String)semanticType.getClassName(), (ClassLoader)executionContext.getClassLoader());
            }
        }
        return value;
    }

    public Object getExpression() {
        return this.expression;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.expression);
    }

    @Override
    public List<Object> getExternalExpressions() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.expression);
        return result;
    }

    public Class<?> getLastValueClass() {
        return this.lastValueClass;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

