/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.AbstractMongoMethodArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodArgument;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;

public class MongoMethodEnumArgument
extends AbstractMongoMethodArgument {
    private Class<? extends Enum> clazz;
    private Enum enumValue;

    MongoMethodEnumArgument(Class<? extends Enum> clazz, String value) {
        super(value);
        this.clazz = clazz;
    }

    @Override
    public Class<?> resolveType(ExternalResolveTypeContext resolveTypeContext) {
        return this.clazz;
    }

    @Override
    public MongoMethodArgument castTo(Class<?> type, ExternalResolveTypeContext resolveTypeContext) {
        if (!this.clazz.isEnum() || type != this.clazz) {
            return null;
        }
        this.initEnumValue();
        return this.enumValue == null ? null : this;
    }

    @Override
    public Object execute(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        if (this.enumValue == null) {
            this.initEnumValue();
        }
        return this.enumValue;
    }

    private void initEnumValue() {
        try {
            this.enumValue = Enum.valueOf(this.clazz, this.value);
        }
        catch (Exception exception) {
            this.enumValue = null;
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(this.value);
    }
}

