/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.Trace;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.JsonArgumentHolder;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCallSequence;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoCompletionException;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoGetCollectionCall;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodCall;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodLiteralArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.MongoMethodStringArgument;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoMethodExternalArgument;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.sef.factory.connection.external.ExternalParserContext;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.parser.AbstractParser;
import com.streamscape.tools.parser.ParserException;

public class MongoCallParser
extends AbstractParser<LexerFactory.DummyTokenType> {
    private ExternalParserContext externalParserContext;
    private boolean parseDBPrefix = true;
    private MongoFactoryConnectionService service;

    public MongoCallParser(MongoFactoryConnectionService service) throws ParserException {
        super(LexerFactory.DummyTokenType.class);
        this.service = service;
    }

    public void setExternalParserContext(ExternalParserContext externalParserContext) {
        this.externalParserContext = externalParserContext;
    }

    public ExternalParserContext getExternalParserContext() {
        return this.externalParserContext;
    }

    public void setParseDBPrefix(boolean parseDBPrefix) {
        this.parseDBPrefix = parseDBPrefix;
    }

    public MongoCallSequence parse(String script) throws ParserException {
        this.lexer.reset(script);
        MongoCallSequence sequence = new MongoCallSequence();
        try {
            if (this.parseDBPrefix) {
                this.lexer.readToken("db");
                this.lexer.readToken((TokenType)CommonTokenType.DOT);
            }
            this.lexer.readToken();
            if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.LITERAL) || this.lexer.getCurrentToken().getValue().trim().length() == 0) {
                if (this.isCompleteMode) {
                    throw new MongoCompletionException(sequence, "");
                }
                throw this.unexpectedToken(new Object[]{"Collection name or database function"});
            }
            String collectionName = this.lexer.getCurrentToken().getValue();
            this.lexer.readToken();
            if (this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) {
                sequence.addCall(new MongoGetCollectionCall(collectionName));
            } else if (this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_BRACKET)) {
                this.readMethod(collectionName, sequence);
                if (this.externalParserContext == null) {
                    if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.BUFFER_END) && !this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) {
                        throw this.unexpectedToken(new TokenType[]{CommonTokenType.DOT});
                    }
                } else if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) {
                    this.externalParserContext.setPosition(this.lexer.getCurrentTokenPosition());
                    return sequence;
                }
            } else {
                if (this.isCompleteMode) {
                    throw new MongoCompletionException(sequence, collectionName);
                }
                throw this.unexpectedToken(new Object[]{"Collection name or database function", CommonTokenType.DOT, CommonTokenType.OPEN_BRACKET});
            }
            do {
                boolean isDot = this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT);
                this.lexer.readToken();
                if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.LITERAL) || this.lexer.getCurrentToken().getValue().trim().length() == 0) {
                    if (this.isCompleteMode) {
                        throw new MongoCompletionException(sequence, "");
                    }
                    if (sequence.getLastCall() == null || !(sequence.getLastCall() instanceof MongoMethodCall) || isDot) {
                        throw this.unexpectedToken(new Object[]{"function name"});
                    }
                    break;
                }
                String methodName = this.lexer.getCurrentToken().getValue();
                this.lexer.readToken();
                if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_BRACKET)) {
                    if (this.isCompleteMode) {
                        throw new MongoCompletionException(sequence, methodName);
                    }
                    throw this.unexpectedToken(new Object[]{"function name", CommonTokenType.OPEN_BRACKET});
                }
                this.readMethod(methodName, sequence);
                if (this.externalParserContext == null) {
                    if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.BUFFER_END) && !this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) {
                        throw this.unexpectedToken(new TokenType[]{CommonTokenType.DOT});
                    }
                } else if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) {
                    this.externalParserContext.setPosition(this.lexer.getCurrentTokenPosition());
                    break;
                }
                this.lexer.skipSpaces();
            } while (!this.lexer.isCurrentToken((TokenType)CommonTokenType.BUFFER_END));
        }
        catch (LexerException exception) {
            throw this.parserException(exception.getMessage());
        }
        return sequence;
    }

    private void readMethod(String methodName, MongoCallSequence sequence) throws LexerException, ParserException {
        MongoMethodCall methodCall = new MongoMethodCall(methodName);
        this.readMethodArguments(methodCall);
        sequence.addCall(methodCall);
    }

    private void readMethodArguments(MongoMethodCall methodCall) throws LexerException, ParserException {
        this.lexer.readToken();
        while (true) {
            if (this.lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_BRACKET)) break;
            if (this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_CURLY_BRACKET) || this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_SQUARE_BRACKET)) {
                this.readJsonArgument(methodCall);
                this.lexer.readToken();
            } else if (this.externalParserContext != null) {
                int position = this.lexer.getCurrentTokenPosition();
                try {
                    this.externalParserContext.setPosition(position);
                    Object expression = this.externalParserContext.parseExpression();
                    methodCall.addArgument(new MongoMethodExternalArgument(expression));
                }
                catch (Exception exception) {
                    this.lexer.rewind(position);
                    throw this.parserException("Failed to parse method argument. Cause: " + exception.getMessage());
                }
                this.lexer.rewind(this.externalParserContext.getPosition());
                this.lexer.readToken();
            } else if (this.lexer.isCurrentToken((TokenType)CommonTokenType.STRING_LITERAL)) {
                methodCall.addArgument(new MongoMethodStringArgument(this.lexer.getCurrentToken().getValue()));
                this.lexer.readToken();
            } else if (this.lexer.isCurrentToken((TokenType)CommonTokenType.LITERAL)) {
                String value = this.lexer.getCurrentToken().getValue();
                this.lexer.readToken();
                while (this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) {
                    this.lexer.readToken((TokenType)CommonTokenType.LITERAL);
                    value = value + "." + this.lexer.getCurrentToken().getValue();
                    this.lexer.readToken();
                }
                methodCall.addArgument(new MongoMethodLiteralArgument(value));
            } else {
                throw this.unexpectedToken(new Object[]{"function argument"});
            }
            if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.COMMA)) continue;
            this.lexer.readToken();
        }
        this.lexer.readToken();
    }

    /*
     * Exception decompiling
     */
    private void readJsonArgument(MongoMethodCall methodCall) throws ParserException, LexerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readJsonObject(JsonArgumentContext context) throws LexerException, ParserException {
        context.holder.getBuilder().startJsonObject();
        this.lexer.readToken();
        if (this.lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_CURLY_BRACKET)) {
            context.holder.getBuilder().endJsonObject();
            return;
        }
        while (true) {
            int nameStartPos = this.lexer.getCurrentTokenPosition();
            String fieldName = this.lexer.getCurrentToken().getValue();
            while (true) {
                if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.LITERAL) && !this.lexer.isCurrentToken((TokenType)CommonTokenType.STRING_LITERAL)) {
                    throw this.unexpectedToken(new Object[]{"json element name"});
                }
                this.lexer.readToken();
                if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.DOT)) break;
                this.lexer.readToken();
                fieldName = null;
            }
            if (fieldName == null) {
                fieldName = this.lexer.substring(nameStartPos, this.lexer.getCurrentTokenPosition()).trim();
            }
            context.holder.getBuilder().setFieldName(fieldName);
            if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.COLON)) {
                throw this.unexpectedToken(new TokenType[]{CommonTokenType.COLON});
            }
            this.lexer.readToken();
            if (this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_CURLY_BRACKET)) {
                this.readJsonObject(context);
            } else if (this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_SQUARE_BRACKET)) {
                this.readJsonArray(context);
            } else {
                boolean isCurrentTokenBoolean;
                int currentTokenPosition = this.lexer.getCurrentTokenPosition();
                String tokenValue = this.lexer.getCurrentToken().getValue();
                boolean isCurrentTokenLiteral = this.lexer.isCurrentToken((TokenType)CommonTokenType.LITERAL);
                boolean isCurrentTokenNumber = isCurrentTokenLiteral && TypeFactory.defineNumberType((String)tokenValue) != null;
                boolean bl = isCurrentTokenBoolean = isCurrentTokenLiteral && (tokenValue.equalsIgnoreCase("true") || tokenValue.equalsIgnoreCase("false"));
                if (this.externalParserContext != null) {
                    this.lexer.readToken();
                    if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.COMMA) && !this.lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_CURLY_BRACKET) || isCurrentTokenLiteral && !isCurrentTokenNumber && !isCurrentTokenBoolean) {
                        this.lexer.rewind(currentTokenPosition);
                        context.appendFromLexer();
                        try {
                            this.externalParserContext.setPosition(currentTokenPosition);
                            MongoMethodExternalArgument a = new MongoMethodExternalArgument(this.externalParserContext.parseExpression());
                            context.holder.addPart(a);
                            context.holder.getBuilder().setFieldValue(a);
                            tokenValue = null;
                        }
                        catch (Exception exception) {
                            throw this.parserException("Failed to parse method argument. Cause: " + exception.getMessage());
                        }
                        this.lexer.rewind(this.externalParserContext.getPosition());
                        context.updateEndPositionFromLexer();
                    } else {
                        this.lexer.rewind(currentTokenPosition);
                        this.lexer.readToken();
                    }
                } else if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.STRING_LITERAL) && !this.lexer.isCurrentToken((TokenType)CommonTokenType.LITERAL)) {
                    throw this.unexpectedToken(new Object[]{"json value"});
                }
                if (tokenValue != null) {
                    Object value = tokenValue;
                    if (isCurrentTokenNumber) {
                        try {
                            value = TypeFactory.defineNumberType((String)tokenValue).convertValue((Object)tokenValue, TypeFactory.STRING);
                        }
                        catch (ValueConversionException e) {
                            Trace.logError((Object)((Object)this), (String)e.getMessage());
                        }
                    } else if (isCurrentTokenBoolean) {
                        value = tokenValue.equalsIgnoreCase("true");
                    } else if (tokenValue.equalsIgnoreCase("null")) {
                        value = null;
                    }
                    context.holder.getBuilder().setFieldValue(value);
                }
            }
            this.lexer.readToken();
            if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.COMMA)) break;
            this.lexer.readToken();
        }
        if (this.lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_CURLY_BRACKET)) {
            context.holder.getBuilder().endJsonObject();
            return;
        }
        throw this.unexpectedToken(new Object[]{",", "}"});
    }

    private void readJsonArray(JsonArgumentContext context) throws LexerException, ParserException {
        if (this.lexer.isCurrentToken((TokenType)CommonTokenType.OPEN_SQUARE_BRACKET)) {
            context.holder.getBuilder().startJsonArray();
        }
        do {
            this.lexer.readToken((TokenType)CommonTokenType.OPEN_CURLY_BRACKET);
            this.readJsonObject(context);
            this.lexer.readToken();
            if (!this.lexer.isCurrentToken((TokenType)CommonTokenType.CLOSE_SQUARE_BRACKET)) continue;
            context.holder.getBuilder().endJsonArray();
            return;
        } while (this.lexer.isCurrentToken((TokenType)CommonTokenType.COMMA));
        throw this.unexpectedToken(new Object[]{",", "]"});
    }

    protected void onComplete(String buffer) throws ParserException {
        this.parse(buffer);
    }

    private class JsonArgumentContext {
        JsonArgumentHolder holder;
        private int endPosition;

        JsonArgumentContext() {
            this.holder = new JsonArgumentHolder(MongoCallParser.this.service.getConnection().getCodec().getDocumentClass());
            this.updateEndPositionFromLexer();
        }

        void appendFromLexer() {
            if (this.endPosition < MongoCallParser.this.lexer.getCurrentPosition()) {
                this.holder.addPart(MongoCallParser.this.lexer.substring(this.endPosition, MongoCallParser.this.lexer.getCurrentPosition()));
            }
            this.endPosition = MongoCallParser.this.lexer.getCurrentPosition();
        }

        void updateEndPositionFromLexer() {
            this.endPosition = MongoCallParser.this.lexer.getCurrentTokenPosition();
        }
    }
}

