/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl.parser;

import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.dsl.parser.DocumentBuilder;
import com.streamscape.lib.nosql.mongo.dsl.parser.external.MongoMethodExternalArgument;
import com.streamscape.sef.factory.connection.external.ExternalExecutionContext;
import com.streamscape.sef.factory.connection.external.ExternalResolveTypeContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class AbstractDocumentBuilder<T extends Map>
implements DocumentBuilder {
    private Stack<DocumentHolder<T>> holders;
    private boolean isArray;
    private Object result;

    @Override
    public void startJsonObject() {
        if (this.holders == null) {
            this.holders = new Stack();
        }
        if (this.holders.isEmpty() || ((DocumentHolder)this.holders.lastElement()).fieldName != null) {
            DocumentHolder holder = new DocumentHolder();
            holder.documents.add(this.newDocument());
            this.holders.add(holder);
        } else {
            ((DocumentHolder)this.holders.lastElement()).documents.add(this.newDocument());
        }
    }

    @Override
    public void endJsonObject() {
        DocumentHolder<T> holder = this.holders.peek();
        if (!holder.isArray) {
            Map document = (Map)this.holders.pop().documents.get(0);
            if (this.holders.isEmpty()) {
                this.result = document;
            } else {
                this.setFieldValue(document);
            }
        }
    }

    @Override
    public void setFieldName(String name) {
        this.holders.peek().fieldName = name;
    }

    @Override
    public void setFieldValue(Object value) {
        DocumentHolder<T> holder = this.holders.peek();
        ((Map)holder.documents.get(holder.documents.size() - 1)).put(holder.fieldName, this.convertValue(value));
        holder.fieldName = null;
    }

    @Override
    public void startJsonArray() {
        if (this.holders != null) {
            DocumentHolder holder = new DocumentHolder();
            holder.isArray = true;
            this.holders.add(holder);
        } else {
            this.isArray = true;
        }
    }

    @Override
    public void endJsonArray() {
        if (this.holders != null && this.holders.size() > 1) {
            List array = this.holders.pop().documents;
            DocumentHolder<T> holder = this.holders.peek();
            ((Map)holder.documents.get(holder.documents.size() - 1)).put(holder.fieldName, this.convertValue(array));
            holder.fieldName = null;
        } else if (this.holders != null && this.holders.size() == 1) {
            this.result = this.holders.pop().documents;
        }
    }

    @Override
    public Map getResolveResultDocument(MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        if (this.result instanceof List) {
            throw new Exception("Failed to convert list of documents to document.");
        }
        if (!(this.result instanceof Map)) {
            throw new Exception("Failed to convert " + this.result + " to document.");
        }
        return (Map)this.resolveDocument(this.result, service, executionContext);
    }

    private Object resolveDocument(Object document, MongoFactoryConnectionService service, ExternalExecutionContext executionContext) throws Exception {
        if (document instanceof Map) {
            T result = this.newDocument();
            for (Map.Entry entry : ((Map)document).entrySet()) {
                result.put(entry.getKey(), (Object)this.resolveDocument(entry.getValue(), service, executionContext));
            }
            return result;
        }
        if (document instanceof List) {
            List result = this.newArray();
            for (int i = 0; i < ((List)document).size(); ++i) {
                result.add(this.resolveDocument(((List)document).get(i), service, executionContext));
            }
            return result;
        }
        Object unwrapped = this.unwrapValue(document);
        if (unwrapped instanceof MongoMethodExternalArgument) {
            if (((MongoMethodExternalArgument)unwrapped).resolveType((ExternalResolveTypeContext)executionContext) == Bson.class) {
                ((MongoMethodExternalArgument)unwrapped).castTo(Document.class, (ExternalResolveTypeContext)executionContext);
            }
            unwrapped = ((MongoMethodExternalArgument)unwrapped).execute(service, executionContext);
            unwrapped = service.getConnection().getCodec().toDocumentOrPrimitiveObject(unwrapped);
            document = this.convertValue(unwrapped);
        }
        return document;
    }

    protected Object unwrapValue(Object value) {
        return value;
    }

    protected abstract T newDocument();

    protected abstract List newArray();

    protected abstract Object convertValue(Object var1);

    private static class DocumentHolder<T> {
        List<T> documents = new ArrayList<T>();
        String fieldName = null;
        boolean isArray = false;

        private DocumentHolder() {
        }
    }
}

