/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.nosql.mongo.dsl;

import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.nosql.mongo.client.MongoFactoryConnectionService;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodec;
import com.streamscape.lib.nosql.mongo.client.serialization.MongoSdoCodecException;
import com.streamscape.lib.nosql.mongo.dsl.MongoSLResponseBuilder;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.SLSessionData;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;

public class MongoResultConverter {
    private boolean objectAsString = true;
    private Class<?> objectClass = null;
    private Class<?> resultClass = null;
    private MongoFactoryConnectionService service;
    public SLSessionData slSessionData;

    private MongoResultConverter() {
    }

    public static Builder builder(MongoFactoryConnectionService service, SLSessionData slSessionData) {
        return new Builder(service, slSessionData);
    }

    public Object convert(Object object) throws MongoSdoCodecException {
        if (this.resultClass == RowSet.class) {
            return this.convertToRowSet(object);
        }
        if (this.resultClass == null && this.objectClass == null && !this.objectAsString && this.slSessionData != null && this.slSessionData.getDataObjectNotation() != SLSessionData.DataObjectNotation.none) {
            return new MongoSLResponseBuilder(this.service).build(object, this.slSessionData).getRowSet();
        }
        return this.convertToObject(object);
    }

    private boolean isDocumentClass(Object object) {
        return object != null && this.isDocumentClass(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    private boolean isDocumentClass(Class<?> clazz) {
        return this.service.getConnection().getCodec().getDocumentClass().equals(clazz);
    }

    private Object convertToRowSet(Object object) {
        if (object instanceof Iterator || object instanceof Iterable || this.isDocumentClass(object)) {
            Iterator iterator;
            ArrayList<Object> documents = new ArrayList<Object>();
            if (object instanceof Iterator) {
                iterator = (Iterator)object;
                while (iterator.hasNext()) {
                    documents.add(iterator.next());
                }
            } else if (object instanceof Iterable) {
                iterator = ((Iterable)object).iterator();
                while (iterator.hasNext()) {
                    documents.add(iterator.next());
                }
                if (iterator instanceof Closeable) {
                    try {
                        ((Closeable)((Object)iterator)).close();
                    }
                    catch (IOException exception) {
                        Trace.logDebug((Object)this, (String)("Failed to close mongo cursor. Cause: " + exception.getMessage()));
                    }
                }
            } else if (this.isDocumentClass(object)) {
                documents.add(object);
            }
            LinkedHashSet columns = new LinkedHashSet();
            for (Object document : documents) {
                columns.addAll(((Map)document).keySet());
            }
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logDebug((Object)this, (String)("Converting documents to RowSet: " + documents));
            }
            RowMetaData metaData = new RowMetaData();
            for (String column : columns) {
                metaData.addColumn(column, SQLType.STRING);
            }
            RowSet rowSet = new RowSet(metaData);
            for (Object e : documents) {
                Row row = rowSet.newRow();
                try {
                    Set entrySet = ((Map)e).entrySet();
                    for (Map.Entry entry : entrySet) {
                        Object value = entry.getValue();
                        String key = (String)entry.getKey();
                        if (this.isDocumentClass(value)) {
                            MongoResultConverter valueConverter = this;
                            if (this.objectClass != null) {
                                try {
                                    Field f = this.objectClass.getDeclaredField(key);
                                    valueConverter = MongoResultConverter.builder(this.service, this.slSessionData).setObjectAsString(this.objectAsString).setObjectClass(f.getType()).build();
                                }
                                catch (Exception e2) {
                                    Trace.logError((Object)this, (String)("Field '" + key + "' not found in class " + this.objectClass));
                                }
                            }
                            value = valueConverter.convertToObject(value);
                        }
                        row.setColumn(key, (Object)(value != null ? value.toString() : null));
                    }
                    rowSet.addToRowSet(row);
                }
                catch (Exception exception) {
                    Trace.logError((Object)this, (String)("Failed to add row to RowSet. Cause: " + exception.getMessage()));
                }
            }
            object = rowSet;
        } else {
            object = this.convertOthers(object);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object convertToObject(Object object) throws MongoSdoCodecException {
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            MongoResultConverter converter = MongoResultConverter.builder(this.service, this.slSessionData).setObjectAsString(this.objectAsString).setObjectClass(this.objectClass).setResultClass(Object.class).build();
            if (this.resultClass != Iterator.class) {
                ArrayList<Object> result = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    result.add(converter.convertToObject(iterator.next()));
                }
                return result;
            }
            if (!(object instanceof MongoCursor)) return new IteratorWrapper(iterator, converter);
            return new MongoCursorWrapper((MongoCursor)iterator, converter);
        }
        if (object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            object = this.convertToObject(iterator);
            if (!(iterator instanceof Closeable)) return object;
            if (this.resultClass == Iterator.class) return object;
            try {
                ((Closeable)((Object)iterator)).close();
                return object;
            }
            catch (IOException exception) {
                Trace.logDebug((Object)this, (String)("Failed to close mongo cursor. Cause: " + exception.getMessage()));
            }
            return object;
        } else {
            Class<?> targetClass;
            if (!this.isDocumentClass(object)) {
                if (object == null) return this.convertOthers(object);
                if (object.getClass() != Document.class) return this.convertOthers(object);
            }
            MongoSdoCodec<?> codec = this.service.getConnection().getCodec();
            Class<?> clazz = targetClass = this.objectClass != null ? this.objectClass : this.resultClass;
            if (!this.objectAsString && targetClass != null && targetClass != Object.class) {
                try {
                    return codec.fromDocument(object, targetClass);
                }
                catch (MongoSdoCodecException exception) {
                    Trace.logError((Object)this, (String)("Failed to deserialize object " + object + " to class " + targetClass));
                    Trace.logError((Object)this, (String)exception.getMessage());
                    throw new MongoSdoCodecException("Failed to deserialize object " + object + " to class " + targetClass, exception);
                }
            }
            if (!this.objectAsString) return object;
            return codec.toJson(object, this.slSessionData != null && this.slSessionData.getDataObjectNotation() == SLSessionData.DataObjectNotation.json_pretty);
        }
    }

    private Object convertOthers(Object object) {
        if (object instanceof UpdateResult) {
            if (this.objectAsString) {
                UpdateResult r = (UpdateResult)object;
                object = object.getClass().getSimpleName() + "{acknowledged : " + r.wasAcknowledged();
                if (r.wasAcknowledged()) {
                    object = object + ", modifiedCount : " + r.getModifiedCount() + ", matchedCount : " + r.getMatchedCount() + ", upsertId : " + r.getUpsertedId();
                }
                object = object + "}";
            }
        } else if (object instanceof DeleteResult) {
            if (this.objectAsString) {
                DeleteResult r = (DeleteResult)object;
                object = object.getClass().getSimpleName() + "{acknowledged : " + r.wasAcknowledged();
                if (r.wasAcknowledged()) {
                    object = object + ", deleteCount : " + r.getDeletedCount();
                }
                object = object + "}";
            }
        } else if (object != null) {
            object = this.objectAsString ? object.toString() : object;
        }
        return object;
    }

    public Class<?> convert(Class<?> clazz) {
        if (clazz == null) {
            return Object.class;
        }
        if (Iterator.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz)) {
            return List.class;
        }
        if (this.isDocumentClass(clazz)) {
            return this.objectAsString || this.objectClass == null ? String.class : this.objectClass;
        }
        if (UpdateResult.class.isAssignableFrom(clazz) || DeleteResult.class.isAssignableFrom(clazz)) {
            return String.class;
        }
        return this.objectAsString ? String.class : Object.class;
    }

    public static class MongoCursorWrapper
    extends IteratorWrapper
    implements MongoCursor {
        public MongoCursorWrapper(Iterator<?> iterator, MongoResultConverter converter) {
            super(iterator, converter);
        }

        @Override
        public void close() {
            this.mongoCursor().close();
        }

        public Object tryNext() {
            return this.mongoCursor().tryNext();
        }

        @Override
        public ServerCursor getServerCursor() {
            return this.mongoCursor().getServerCursor();
        }

        @Override
        public ServerAddress getServerAddress() {
            return this.mongoCursor().getServerAddress();
        }

        private MongoCursor mongoCursor() {
            return (MongoCursor)this.iterator();
        }
    }

    public static class IteratorWrapper
    implements Iterator {
        private Iterator<?> iterator;
        private MongoResultConverter converter;

        public IteratorWrapper(Iterator<?> iterator, MongoResultConverter converter) {
            this.iterator = iterator;
            this.converter = converter;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            try {
                return this.converter.convert(this.iterator.next());
            }
            catch (MongoSdoCodecException exception) {
                throw new DataspaceException((Throwable)exception);
            }
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        protected Iterator<?> iterator() {
            return this.iterator;
        }
    }

    public static class Builder {
        private boolean objectAsString = true;
        private Class<?> objectClass = null;
        private Class<?> resultClass;
        private MongoFactoryConnectionService service;
        private SLSessionData slSessionData;

        public Builder(MongoFactoryConnectionService service, SLSessionData slSessionData) {
            this.service = service;
            this.slSessionData = slSessionData;
        }

        public Builder setObjectAsString(boolean objectAsString) {
            this.objectAsString = objectAsString;
            return this;
        }

        public Builder setResultClass(Class<?> resultClass) {
            this.resultClass = resultClass;
            return this;
        }

        public Builder setObjectClass(Class<?> objectClass) {
            this.objectClass = objectClass;
            return this;
        }

        public MongoResultConverter build() {
            MongoResultConverter result = new MongoResultConverter();
            result.objectAsString = this.objectAsString;
            result.objectClass = this.objectClass;
            result.resultClass = this.resultClass;
            result.service = this.service;
            result.slSessionData = this.slSessionData;
            return result;
        }
    }
}

